/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.getfilenames.FileItem;
import org.apache.hop.pipeline.transforms.getfilenames.FilterItem;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.WidgetUtils;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GetFileNamesDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = GetFileNamesMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private Button wDoNotFailIfNoFile;
    private Label wlDoNotFailIfNoFile;
    private Label wlRaiseAnExceptionIfNoFile;
    private Button wRaiseAnExceptionIfNoFile;
    private TextVar wFilename;
    private TableView wFilenameList;
    private TextVar wExcludeFilemask;
    private TextVar wFilemask;
    private CCombo wFilterFileType;
    private final GetFileNamesMeta input;
    private Button wFileField;
    private CCombo wFilenameField;
    private CCombo wWildcardField;
    private CCombo wExcludeWildcardField;
    private Button wIncludeSubFolder;
    private Button wAddResult;
    private Text wLimit;
    private Button wInclRownum;
    private TextVar wInclRownumField;
    private boolean getPreviousFields = false;
    private Group groupAsDefined;
    private Group groupFromField;
    private Label wFileFieldWarning;

    public GetFileNamesDialog(Shell parent, IVariables variables, GetFileNamesMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    private void createTransformName(Shell shell, int margin, int middle, ModifyListener lsMod) {
        this.wlTransformName = new Label((Composite)shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.wlTransformName.setLayoutData((Object)new FormDataBuilder().left(0, margin).top(0, margin).right(middle, -2 * margin).result());
        this.wTransformName = new Text((Composite)shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.wTransformName.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top(0, margin).right(100, -margin).result());
    }

    private void createDialogButtons(Shell shell, int margin) {
        this.wOk = new Button((Composite)shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Preview.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
    }

    private Group createGroupOpMode(Composite parent, int margin, int middle) {
        Group group = new Group(parent, 32);
        PropsUi.setLook((Widget)group);
        group.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.OpMode.Label", (String[])new String[0]));
        WidgetUtils.setFormLayout((Composite)group, (int)10);
        Label label = new Label((Composite)group, 131072);
        label.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)label);
        label.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)group, margin).right(middle, -2 * margin).result());
        this.wFileField = new Button((Composite)group, 32);
        PropsUi.setLook((Widget)this.wFileField);
        this.wFileField.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileField.Tooltip", (String[])new String[0]));
        this.wFileField.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top(0, margin).result());
        this.wFileField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFileNamesDialog.this.activateFileField();
                GetFileNamesDialog.this.setFileField();
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        this.wFileFieldWarning = new Label((Composite)group, 16384);
        this.wFileFieldWarning.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileField.Warning", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFileFieldWarning);
        this.wFileFieldWarning.setLayoutData((Object)new FormDataBuilder().left((Control)this.wFileField, margin).top((Control)label, 0, 0x1000000).right(100, -margin).result());
        return group;
    }

    private Group createGroupFromField(Composite parent, int margin, int middle, ModifyListener lsMod) {
        Group group = new Group(parent, 32);
        PropsUi.setLook((Widget)group);
        group.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.FromField.Label", (String[])new String[0]));
        WidgetUtils.setFormLayout((Composite)group, (int)10);
        Label wlFilenameField = new Label((Composite)group, 131072);
        wlFilenameField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameField);
        wlFilenameField.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)this.wFileField, margin).right(middle, -2 * margin).result());
        this.wFilenameField = new CCombo((Composite)group, 2056);
        this.wFilenameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        this.wFilenameField.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wFileField, margin).right(100, -margin).result());
        Label wlWildcardField = new Label((Composite)group, 131072);
        wlWildcardField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.WildcardField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWildcardField);
        wlWildcardField.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)this.wFilenameField, margin).right(middle, -2 * margin).result());
        this.wWildcardField = new CCombo((Composite)group, 2056);
        this.wWildcardField.setEditable(true);
        PropsUi.setLook((Widget)this.wWildcardField);
        this.wWildcardField.addModifyListener(lsMod);
        this.wWildcardField.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wFilenameField, margin).right(100, -margin).result());
        Label wlExcludeWildcardField = new Label((Composite)group, 131072);
        wlExcludeWildcardField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeWildcardField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExcludeWildcardField);
        wlExcludeWildcardField.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)this.wWildcardField, margin).right(middle, -2 * margin).result());
        this.wExcludeWildcardField = new CCombo((Composite)group, 2056);
        this.wExcludeWildcardField.setEditable(true);
        PropsUi.setLook((Widget)this.wExcludeWildcardField);
        this.wExcludeWildcardField.addModifyListener(lsMod);
        this.wExcludeWildcardField.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wWildcardField, margin).right(100, -margin).result());
        Label wlIncludeSubFolder = new Label((Composite)group, 131072);
        wlIncludeSubFolder.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeSubFolder);
        wlIncludeSubFolder.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)this.wExcludeWildcardField, margin).right(middle, -2 * margin).result());
        this.wIncludeSubFolder = new Button((Composite)group, 32);
        PropsUi.setLook((Widget)this.wIncludeSubFolder);
        this.wIncludeSubFolder.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubFolder.Tooltip", (String[])new String[0]));
        this.wIncludeSubFolder.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)wlIncludeSubFolder, 0, 0x1000000).result());
        this.wIncludeSubFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        return group;
    }

    private Group createGroupAsDefined(Composite parent, int margin, int middle, ModifyListener lsMod) {
        Group group = new Group(parent, 32);
        PropsUi.setLook((Widget)group);
        group.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.ByDefinition.Label", (String[])new String[0]));
        WidgetUtils.setFormLayout((Composite)group, (int)10);
        Label wlFilename = new Label((Composite)group, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        wlFilename.setLayoutData((Object)new FormDataBuilder().left(0, -margin).top((Control)this.wFileField, margin).right(middle, -2 * margin).result());
        Button wbbFilename = new Button((Composite)group, 0x1000008);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        wbbFilename.setLayoutData((Object)new FormDataBuilder().top((Control)wlFilename, 0, 0x1000000).right(100, 0).result());
        wbbFilename.addListener(13, e -> {
            if (!Utils.isEmpty((CharSequence)this.wFilemask.getText()) || !Utils.isEmpty((CharSequence)this.wExcludeFilemask.getText())) {
                BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables);
            } else {
                BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileType.TextAndCSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
            }
        });
        Button wbaFilename = new Button((Composite)group, 0x1000008);
        PropsUi.setLook((Widget)wbaFilename);
        wbaFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameAdd.Button", (String[])new String[0]));
        wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        wbaFilename.setLayoutData((Object)new FormDataBuilder().top((Control)wlFilename, 0, 0x1000000).right((Control)wbbFilename, -margin).result());
        this.wFilename = new TextVar(this.variables, (Composite)group, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.wFilename.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)wlFilename, 0, 0x1000000).right((Control)wbaFilename, -margin).result());
        SelectionAdapter addFileToListAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFileNamesDialog.this.wFilenameList.add(new String[]{GetFileNamesDialog.this.wFilename.getText(), GetFileNamesDialog.this.wFilemask.getText(), GetFileNamesDialog.this.wExcludeFilemask.getText(), GetFileNamesMeta.RequiredFilesCode[0], GetFileNamesMeta.RequiredFilesCode[0]});
                GetFileNamesDialog.this.wFilename.setText("");
                GetFileNamesDialog.this.wFilemask.setText("");
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.wFilenameList.optWidth(true);
            }
        };
        wbaFilename.addSelectionListener((SelectionListener)addFileToListAdapter);
        this.wFilename.addSelectionListener(addFileToListAdapter);
        Label wlFilemask = new Label((Composite)group, 131072);
        wlFilemask.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Filemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilemask);
        wlFilemask.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wFilename, margin).right(middle, -2 * margin).result());
        this.wFilemask = new TextVar(this.variables, (Composite)group, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        this.wFilemask.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)wlFilemask, 0, 0x1000000).right((Control)this.wFilename, 0, 131072).result());
        Label wlExcludeFilemask = new Label((Composite)group, 131072);
        wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeFilemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExcludeFilemask);
        wlExcludeFilemask.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)wlFilemask, margin).right(middle, -2 * margin).result());
        this.wExcludeFilemask = new TextVar(this.variables, (Composite)group, 18436);
        PropsUi.setLook((Widget)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(lsMod);
        this.wExcludeFilemask.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)wlExcludeFilemask, 0, 0x1000000).right((Control)this.wFilename, 0, 131072).result());
        Label wlFilenameList = new Label((Composite)group, 131072);
        wlFilenameList.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilenameList);
        wlFilenameList.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wExcludeFilemask, margin).right(middle, -2 * margin).result());
        Button wbdFilename = new Button((Composite)group, 0x1000008);
        PropsUi.setLook((Widget)wbdFilename);
        wbdFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameDelete.Button", (String[])new String[0]));
        wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameDelete.Tooltip", (String[])new String[0]));
        wbdFilename.setLayoutData((Object)new FormDataBuilder().top((Control)this.wExcludeFilemask, margin).right(100, 0).result());
        wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = GetFileNamesDialog.this.wFilenameList.getSelectionIndices();
                GetFileNamesDialog.this.wFilenameList.remove(idx);
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        Button wbeFilename = new Button((Composite)group, 0x1000008);
        PropsUi.setLook((Widget)wbeFilename);
        wbeFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameEdit.Button", (String[])new String[0]));
        wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        wbeFilename.setLayoutData((Object)new FormDataBuilder().left((Control)wbdFilename, 0, 16384).top((Control)wbdFilename, margin).right(100, 0).result());
        wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = GetFileNamesDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = GetFileNamesDialog.this.wFilenameList.getItem(idx);
                    GetFileNamesDialog.this.wFilename.setText(string[0]);
                    GetFileNamesDialog.this.wFilemask.setText(string[1]);
                    GetFileNamesDialog.this.wExcludeFilemask.setText(string[2]);
                    GetFileNamesDialog.this.wFilenameList.remove(idx);
                }
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        Button wbShowFiles = new Button((Composite)group, 0x1000008);
        PropsUi.setLook((Widget)wbShowFiles);
        wbShowFiles.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ShowFiles.Button", (String[])new String[0]));
        wbShowFiles.setLayoutData((Object)new FormDataBuilder().left(middle, 0).bottom(100, 0).result());
        wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetFileNamesMeta tfii = new GetFileNamesMeta();
                GetFileNamesDialog.this.getInfo(tfii);
                String[] files = tfii.getFilePaths(GetFileNamesDialog.this.variables);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(GetFileNamesDialog.this.shell, files, "Files read", "Files read:");
                    esd.setViewOnly();
                    esd.open();
                } else {
                    String elementTypeToGet = FileInputList.FileTypeFilter.getByOrdinal((int)GetFileNamesDialog.this.wFilterFileType.getSelectionIndex()).toString();
                    MessageBox mb = new MessageBox(GetFileNamesDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.NoFilesFound.DialogMessage", (String[])new String[]{elementTypeToGet}));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileDirColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.WildcardColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeWildcardColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RegExpColumn.Column", (String[])new String[0]));
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeRegExpColumn.Column", (String[])new String[0]));
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubDirs.ToolTip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, (Composite)group, 67588, colinfo, colinfo.length, lsMod, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        this.wFilenameList.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)this.wExcludeFilemask, margin).right((Control)wbdFilename, -margin).bottom((Control)wbShowFiles, -margin).result());
        return group;
    }

    private void createTabFile(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod) {
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite composite = new Composite((Composite)wTabFolder, 0);
        composite.setLayoutData((Object)new FormDataBuilder().left(0, 0).top(0, 0).right(100, 0).bottom(100, 0));
        PropsUi.setLook((Widget)composite);
        WidgetUtils.setFormLayout((Composite)composite, (int)3);
        Group opModeGroup = this.createGroupOpMode(composite, margin, middle);
        opModeGroup.setLayoutData((Object)new FormDataBuilder().left(0, margin).top(0, margin).right(100, -margin).result());
        FormData belowOpModeGroupLayout = new FormDataBuilder().left(0, margin).top((Control)opModeGroup, margin).right(100, -margin).bottom(100, -margin).result();
        this.groupAsDefined = this.createGroupAsDefined(composite, margin, middle, lsMod);
        this.groupAsDefined.setLayoutData((Object)belowOpModeGroupLayout);
        this.groupFromField = this.createGroupFromField(composite, margin, middle, lsMod);
        this.groupFromField.setLayoutData((Object)belowOpModeGroupLayout);
        composite.layout();
        wFileTab.setControl((Control)composite);
    }

    private void createTabFilter(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod) {
        CTabItem wFilterTab = new CTabItem(wTabFolder, 0);
        wFilterTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilterTab.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.TabTitle", (String[])new String[0]));
        Composite wFilterComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFilterComp);
        WidgetUtils.setFormLayout((Composite)wFilterComp, (int)3);
        Label wlFilterFileType = new Label(wFilterComp, 131072);
        wlFilterFileType.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilterFileType);
        wlFilterFileType.setLayoutData((Object)new FormDataBuilder().left(0, margin).top(0, 3 * margin).right(middle, -margin).result());
        this.wFilterFileType = new CCombo(wFilterComp, 2060);
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.All.Label", (String[])new String[0]));
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.OnlyFile.Label", (String[])new String[0]));
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.OnlyFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFilterFileType);
        this.wFilterFileType.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top(0, 3 * margin).right(100, -3 * margin).result());
        this.wFilterFileType.addModifyListener(lsMod);
        Group wAdditionalGroup = new Group(wFilterComp, 32);
        PropsUi.setLook((Widget)wAdditionalGroup);
        wAdditionalGroup.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        WidgetUtils.setFormLayout((Composite)wAdditionalGroup, (int)10);
        wAdditionalGroup.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wFilterFileType, margin).right(100, -margin).result());
        Label wlInclRownum = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownum);
        wlInclRownum.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wFilterFileType, margin).right(middle, -2 * margin).result());
        this.wInclRownum = new Button((Composite)wAdditionalGroup, 32);
        PropsUi.setLook((Widget)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownum.Tooltip", (String[])new String[0]));
        this.wInclRownum.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)wlInclRownum, 0, 0x1000000).right(100, -margin).result());
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
                GetFileNamesDialog.this.wInclRownumField.setEnabled(GetFileNamesDialog.this.wInclRownum.getSelection());
            }
        });
        Label wlInclRownumField = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownumField);
        wlInclRownumField.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)wlInclRownum, margin).right(middle, -2 * margin).result());
        this.wInclRownumField = new TextVar(this.variables, (Composite)wAdditionalGroup, 18436);
        PropsUi.setLook((Widget)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        this.wInclRownumField.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wInclRownum, margin).right(100, -margin).result());
        Group wNoFilesFolderGroup = new Group(wFilterComp, 32);
        PropsUi.setLook((Widget)wNoFilesFolderGroup);
        wNoFilesFolderGroup.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.NoFilesFolder.Label", (String[])new String[0]));
        WidgetUtils.setFormLayout((Composite)wNoFilesFolderGroup, (int)10);
        this.wlDoNotFailIfNoFile = new Label((Composite)wNoFilesFolderGroup, 131072);
        this.wlDoNotFailIfNoFile.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DoNotFailIfNoFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDoNotFailIfNoFile);
        this.wlDoNotFailIfNoFile.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)wAdditionalGroup, margin).right(middle, -2 * margin).result());
        this.wDoNotFailIfNoFile = new Button((Composite)wNoFilesFolderGroup, 32);
        PropsUi.setLook((Widget)this.wDoNotFailIfNoFile);
        this.wDoNotFailIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DoNotFailIfNoFile.Tooltip", (String[])new String[0]));
        this.wDoNotFailIfNoFile.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wlDoNotFailIfNoFile, 0, 0x1000000).result());
        this.wlRaiseAnExceptionIfNoFile = new Label((Composite)wNoFilesFolderGroup, 131072);
        this.wlRaiseAnExceptionIfNoFile.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RaiseAnExceptionIfNoFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRaiseAnExceptionIfNoFile);
        this.wlRaiseAnExceptionIfNoFile.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wlDoNotFailIfNoFile, margin).right(middle, -2 * margin).result());
        this.wRaiseAnExceptionIfNoFile = new Button((Composite)wNoFilesFolderGroup, 32);
        PropsUi.setLook((Widget)this.wRaiseAnExceptionIfNoFile);
        this.wRaiseAnExceptionIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RaiseAnExceptionIfNoFiles.Tooltip", (String[])new String[0]));
        this.wRaiseAnExceptionIfNoFile.setLayoutData((Object)new FormDataBuilder().left(middle, -margin).top((Control)this.wlRaiseAnExceptionIfNoFile, 0, 0x1000000).result());
        this.wRaiseAnExceptionIfNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.wDoNotFailIfNoFile.setSelection(false);
                GetFileNamesDialog.this.wlDoNotFailIfNoFile.setEnabled(!GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.getSelection());
                GetFileNamesDialog.this.wDoNotFailIfNoFile.setEnabled(!GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.getSelection());
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        this.wDoNotFailIfNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.wlRaiseAnExceptionIfNoFile.setEnabled(!GetFileNamesDialog.this.wDoNotFailIfNoFile.getSelection());
                GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.setEnabled(!GetFileNamesDialog.this.wDoNotFailIfNoFile.getSelection());
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        wNoFilesFolderGroup.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)wAdditionalGroup, margin).right(100, -margin).result());
        Label wlLimit = new Label(wFilterComp, 131072);
        PropsUi.setLook((Widget)wlLimit);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Limit.Label", (String[])new String[0]));
        wlLimit.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)wNoFilesFolderGroup, margin).right(middle, -margin).result());
        this.wLimit = new Text(wFilterComp, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.wLimit.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)wNoFilesFolderGroup, margin).right(100, -3 * margin).result());
        Label wlAddResult = new Label(wFilterComp, 131072);
        PropsUi.setLook((Widget)wlAddResult);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.AddResult.Label", (String[])new String[0]));
        wlAddResult.setLayoutData((Object)new FormDataBuilder().left(0, margin).top((Control)this.wLimit, margin).right(middle, -margin).result());
        this.wAddResult = new Button(wFilterComp, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.AddResult.Tooltip", (String[])new String[0]));
        this.wAddResult.setLayoutData((Object)new FormDataBuilder().left(middle, 0).top((Control)wlAddResult, 0, 0x1000000).result());
        this.wAddResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        wFilterComp.setLayoutData((Object)new FormDataBuilder().left(0, 0).top(0, 0).right(100, 0).bottom(100, 0).result());
        wFilterComp.layout();
        wFilterTab.setControl((Control)wFilterComp);
    }

    public String open() {
        Shell parentShell = this.getParent();
        this.shell = new Shell(parentShell, 3312);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DialogTitle", (String[])new String[0]));
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        WidgetUtils.setFormLayout((Composite)this.shell, (int)PropsUi.getFormMargin());
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.createTransformName(this.shell, margin, middle, lsMod);
        this.createDialogButtons(this.shell, margin);
        CTabFolder tabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)tabFolder, (int)4);
        tabFolder.setLayoutData((Object)new FormDataBuilder().left(0, 0).top((Control)this.wTransformName, margin).right(100, 0).bottom((Control)this.wOk, -2 * margin).result());
        this.createTabFile(tabFolder, margin, middle, lsMod);
        this.createTabFilter(tabFolder, margin, middle, lsMod);
        tabFolder.setSelection(0);
        this.setFileField();
        this.getData(this.input);
        this.activateFileField();
        this.setErrorsMgmtCheckboxesStatus();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setFileField() {
        block8: {
            try {
                if (this.getPreviousFields) break block8;
                this.getPreviousFields = true;
                String filename = this.wFilenameField.getText();
                String wildcard = this.wWildcardField.getText();
                String excludewildcard = this.wExcludeWildcardField.getText();
                this.wFilenameField.removeAll();
                this.wWildcardField.removeAll();
                this.wExcludeWildcardField.removeAll();
                IRowMeta r = null;
                try {
                    r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                }
                catch (NullPointerException e) {
                    LogChannel.UI.logBasic("Failed to read previous transform fields", new Object[]{e});
                }
                if (r != null) {
                    this.wFilenameField.setItems(r.getFieldNames());
                    this.wWildcardField.setItems(r.getFieldNames());
                    this.wExcludeWildcardField.setItems(r.getFieldNames());
                }
                if (filename != null) {
                    this.wFilenameField.setText(filename);
                }
                if (wildcard != null) {
                    this.wWildcardField.setText(wildcard);
                }
                if (excludewildcard != null) {
                    this.wExcludeWildcardField.setText(excludewildcard);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    private void activateFileField() {
        boolean isFromField = this.wFileField.getSelection();
        this.groupFromField.setVisible(isFromField);
        for (Control c : this.groupFromField.getChildren()) {
            c.setEnabled(isFromField);
        }
        this.groupAsDefined.setVisible(!isFromField);
        for (Control c : this.groupAsDefined.getChildren()) {
            c.setEnabled(!isFromField);
        }
        this.wPreview.setEnabled(!isFromField);
        this.wFileFieldWarning.setVisible(!isFromField && this.hasPreviousTransform());
    }

    private boolean hasPreviousTransform() {
        return this.pipelineMeta.findPipelineHopTo(this.transformMeta) != null;
    }

    protected void setErrorsMgmtCheckboxesStatus() {
        if (this.wRaiseAnExceptionIfNoFile.getSelection()) {
            this.wDoNotFailIfNoFile.setSelection(false);
        }
        this.wlRaiseAnExceptionIfNoFile.setEnabled(!this.wDoNotFailIfNoFile.getSelection());
        this.wRaiseAnExceptionIfNoFile.setEnabled(!this.wDoNotFailIfNoFile.getSelection());
        if (this.wDoNotFailIfNoFile.getSelection()) {
            this.wRaiseAnExceptionIfNoFile.setSelection(false);
        }
        this.wlDoNotFailIfNoFile.setEnabled(!this.wRaiseAnExceptionIfNoFile.getSelection());
        this.wDoNotFailIfNoFile.setEnabled(!this.wRaiseAnExceptionIfNoFile.getSelection());
    }

    public void getData(GetFileNamesMeta in) {
        if (!in.getFilesList().isEmpty()) {
            this.wFilenameList.removeAll();
            for (int i = 0; i < in.getFilesList().size(); ++i) {
                FileItem fi = in.getFilesList().get(i);
                this.wFilenameList.add(new String[]{fi.getFileName(), fi.getFileMask(), fi.getExcludeFileMask(), fi.getFileRequired(), fi.getIncludeSubFolders()});
            }
        }
        this.wDoNotFailIfNoFile.setSelection(in.isDoNotFailIfNoFile());
        this.wRaiseAnExceptionIfNoFile.setSelection(in.isRaiseAnExceptionIfNoFile());
        this.wFilenameList.removeEmptyRows();
        this.wFilenameList.setRowNums();
        this.wFilenameList.optWidth(true);
        FileInputList.FileTypeFilter elementTypeToGet = FileInputList.FileTypeFilter.getByName((String)in.getFilterItemList().get(0).getFileTypeFilterSelection());
        if (elementTypeToGet != null) {
            this.wFilterFileType.select(elementTypeToGet.ordinal());
        } else {
            this.wFilterFileType.select(0);
        }
        this.wInclRownum.setSelection(in.isIncludeRowNumber());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wAddResult.setSelection(in.isAddResultFile());
        this.wFileField.setSelection(in.isFileField());
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        if (in.getDynamicFilenameField() != null) {
            this.wFilenameField.setText(in.getDynamicFilenameField());
        }
        if (in.getDynamicWildcardField() != null) {
            this.wWildcardField.setText(in.getDynamicWildcardField());
        }
        if (in.getDynamicExcludeWildcardField() != null) {
            this.wExcludeWildcardField.setText(in.getDynamicExcludeWildcardField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.wIncludeSubFolder.setSelection(in.isDynamicIncludeSubFolders());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(GetFileNamesMeta in) {
        this.transformName = this.wTransformName.getText();
        int itemsNum = this.wFilenameList.getItemCount();
        in.getFilesList().clear();
        for (int i = 0; i < itemsNum; ++i) {
            FileItem fi = new FileItem(this.wFilenameList.getItem(i, 1), this.wFilenameList.getItem(i, 2), this.wFilenameList.getItem(i, 3), this.wFilenameList.getItem(i, 4), this.wFilenameList.getItem(i, 5));
            in.getFilesList().add(fi);
        }
        in.getFilterItemList().clear();
        in.getFilterItemList().add(new FilterItem(FileInputList.FileTypeFilter.getByOrdinal((int)this.wFilterFileType.getSelectionIndex()).toString()));
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setAddResultFile(this.wAddResult.getSelection());
        in.setDynamicFilenameField(this.wFilenameField.getText());
        in.setDynamicWildcardField(this.wWildcardField.getText());
        in.setDynamicExcludeWildcardField(this.wExcludeWildcardField.getText());
        in.setFileField(this.wFileField.getSelection());
        in.setRowNumberField(this.wInclRownum.getSelection() ? this.wInclRownumField.getText() : "");
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setDynamicIncludeSubFolders(this.wIncludeSubFolder.getSelection());
        in.setDoNotFailIfNoFile(this.wDoNotFailIfNoFile.getSelection());
        in.setRaiseAnExceptionIfNoFile(this.wRaiseAnExceptionIfNoFile.getSelection());
    }

    private void preview() {
        GetFileNamesMeta oneMeta = new GetFileNamesMeta();
        this.getInfo(oneMeta);
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            oneMeta.setRowLimit(previewSize);
            PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ErrorInPreview.DialogMessage", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
    }
}

