/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.mssqlbulkload;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;

@Action(id="MSSQL_BULK_LOAD", name="i18n::ActionMssqlBulkLoad.Name", description="i18n::ActionMssqlBulkLoad.Description", image="MssqlBulkLoad.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.BulkLoading", keywords={"i18n::ActionMssqlBulkLoad.keyword"}, documentationUrl="/workflow/actions/mssqlbulkload.html")
public class ActionMssqlBulkLoad
extends ActionBase {
    private static final Class<?> PKG = ActionMssqlBulkLoad.class;
    @HopMetadataProperty(key="schemaname")
    private String schemaName = null;
    @HopMetadataProperty(key="tablename")
    private String tableName = null;
    @HopMetadataProperty(key="filename")
    private String fileName = null;
    @HopMetadataProperty(key="datafiletype")
    private String dataFileType = "char";
    @HopMetadataProperty(key="fieldterminator")
    private String fieldTerminator = null;
    @HopMetadataProperty(key="lineterminated")
    private String lineTerminated = null;
    @HopMetadataProperty(key="codepage")
    private String codePage = "OEM";
    @HopMetadataProperty(key="specificcodepage")
    private String specificCodePage = null;
    @HopMetadataProperty(key="startfile")
    private int startFile = 0;
    @HopMetadataProperty(key="endfile")
    private int endFile = 0;
    @HopMetadataProperty(key="orderby")
    private String orderBy = null;
    @HopMetadataProperty(key="addfiletoresult")
    private boolean addFileToResult = false;
    @HopMetadataProperty(key="formatfilename")
    private String formatFileName = null;
    @HopMetadataProperty(key="firetriggers")
    private boolean fireTriggers = false;
    @HopMetadataProperty(key="checkconstraints")
    private boolean checkConstraints = false;
    @HopMetadataProperty(key="keepnulls")
    private boolean keepNulls = false;
    @HopMetadataProperty(key="tablock")
    private boolean tabLock = false;
    @HopMetadataProperty(key="errorfilename")
    private String errorFileName = null;
    @HopMetadataProperty(key="adddatetime")
    private boolean addDatetime = false;
    @HopMetadataProperty(key="orderdirection")
    private String orderDirection = "Asc";
    @HopMetadataProperty(key="maxerrors")
    private int maxErrors = 0;
    @HopMetadataProperty(key="batchsize")
    private int batchSize = 0;
    @HopMetadataProperty(key="rowsperbatch")
    private int rowsPerBatch = 0;
    @HopMetadataProperty(key="keepidentity")
    private boolean keepIdentity = false;
    @HopMetadataProperty(key="truncate")
    private boolean truncate = false;
    @HopMetadataProperty(key="connection")
    private String connection = null;

    public ActionMssqlBulkLoad(String n) {
        super(n, "");
    }

    public ActionMssqlBulkLoad() {
        this("");
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Result execute(Result previousResult, int nr) {
        block66: {
            takeFirstNbrLines = "";
            lineTerminatedby = "";
            fieldTerminatedby = "";
            useFieldSeparator = false;
            useCodepage = "";
            errorfileName = "";
            result = previousResult;
            result.setResult(false);
            vfsFilename = this.resolve(this.fileName);
            fileObject = null;
            if (Utils.isEmpty((CharSequence)vfsFilename)) break block66;
            try {
                fileObject = HopVfs.getFileObject((String)vfsFilename);
                if (!(fileObject instanceof LocalFile)) {
                    throw new HopException(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.OnlyLocalFileSupported", (String[])new String[]{vfsFilename}));
                }
                realFilename = HopVfs.getFilename((FileObject)fileObject);
                file = new File(realFilename);
                if (!file.exists() || !file.canRead()) break block67;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.FileExists.Label", (String[])new String[]{realFilename}));
                }
                if (this.connection == null) break block68;
                dbMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
                pluginId = dbMeta.getPluginId();
                if (!"MSSQL".equals(pluginId) && !"MSSQLNATIVE".equals(pluginId)) {
                    this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.DbNotMSSQL", (String[])new String[]{dbMeta.getDatabaseName()}));
                    var16_19 = result;
                    return var16_19;
                }
                db = new Database((ILoggingObject)this, (IVariables)this, dbMeta);
                db.connect();
                realSchemaname = this.resolve(this.schemaName);
                realTablename = this.resolve(this.tableName);
                if (!db.checkTableExists(realSchemaname, realTablename)) ** GOTO lbl137
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.TableExists.Label", (String[])new String[]{realTablename}));
                }
                if (!Utils.isEmpty((CharSequence)(fieldTerminator = this.getRealFieldTerminator())) || !this.dataFileType.equals("char") && !this.dataFileType.equals("widechar")) ** break block63
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.FieldTerminatorMissing", (String[])new String[0]));
                var20_28 = result;
                db.close();
            }
            catch (Exception e) {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.UnexpectedError.Label", (String[])new String[0]), e);
            }
            finally {
                try {
                    if (fileObject != null) {
                        fileObject.close();
                    }
                }
                catch (Exception var12_15) {}
            }
            return var20_28;
            {
                if (this.dataFileType.equals("char") || this.dataFileType.equals("widechar")) {
                    useFieldSeparator = true;
                    fieldTerminatedby = "FIELDTERMINATOR='" + fieldTerminator + "'";
                }
                if (!this.codePage.equals("Specific")) ** GOTO lbl57
                realCodePage = this.resolve(this.codePage);
                if (this.specificCodePage.length() >= 0) ** break block64
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.SpecificCodePageMissing", (String[])new String[0]));
                var21_31 = result;
                db.close();
            }
            return var21_31;
            {
                block69: {
                    useCodepage = "CODEPAGE = '" + realCodePage + "'";
                    break block69;
lbl57:
                    // 1 sources

                    useCodepage = "CODEPAGE = '" + this.codePage + "'";
                }
                realErrorFile = this.resolve(this.errorFileName);
                if (realErrorFile == null) ** GOTO lbl78
                errorfile = new File(realErrorFile);
                if (!errorfile.exists() || this.addDatetime) ** break block65
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.ErrorFileExists", (String[])new String[0]));
                var22_34 = result;
                db.close();
            }
            return var22_34;
            {
                block67: {
                    block68: {
                        try {
                            try {
                                if (this.addDatetime) {
                                    daf = new SimpleDateFormat();
                                    now = new Date();
                                    daf.applyPattern("yyyMMdd_HHmmss");
                                    d = daf.format(now);
                                    errorfileName = "ERRORFILE ='" + realErrorFile + "_" + d + "'";
                                } else {
                                    errorfileName = "ERRORFILE ='" + realErrorFile + "'";
                                }
lbl78:
                                // 3 sources

                                if (!Utils.isEmpty((CharSequence)(rowterminator = this.getRealLineterminated()))) {
                                    lineTerminatedby = "ROWTERMINATOR='" + rowterminator + "'";
                                }
                                if (this.startFile > 0) {
                                    takeFirstNbrLines = "FIRSTROW=" + this.startFile;
                                }
                                if (this.endFile > 0) {
                                    takeFirstNbrLines = "LASTROW=" + this.endFile;
                                }
                                sqlBulkLoad = "";
                                if (this.truncate) {
                                    sqlBulkLoad = "TRUNCATE TABLE " + realTablename + ";";
                                }
                                sqlBulkLoad = (String)sqlBulkLoad + "BULK INSERT " + realTablename + " FROM '" + realFilename.replace('\\', '/') + "'";
                                sqlBulkLoad = (String)sqlBulkLoad + " WITH (";
                                sqlBulkLoad = useFieldSeparator != false ? (String)sqlBulkLoad + (String)fieldTerminatedby : (String)sqlBulkLoad + "DATAFILETYPE ='" + this.dataFileType + "'";
                                if (!lineTerminatedby.isEmpty()) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)lineTerminatedby;
                                }
                                if (!takeFirstNbrLines.isEmpty()) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)takeFirstNbrLines;
                                }
                                if (!useCodepage.isEmpty()) {
                                    sqlBulkLoad = (String)sqlBulkLoad + "," + (String)useCodepage;
                                }
                                if ((realFormatFile = this.resolve(this.formatFileName)) != null) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", FORMATFILE='" + realFormatFile + "'";
                                }
                                if (this.fireTriggers) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",FIRE_TRIGGERS";
                                }
                                if (this.keepNulls) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",KEEPNULLS";
                                }
                                if (this.keepIdentity) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",KEEPIDENTITY";
                                }
                                if (this.checkConstraints) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",CHECK_CONSTRAINTS";
                                }
                                if (this.tabLock) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",TABLOCK";
                                }
                                if (this.orderBy != null) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ",ORDER ( " + this.orderBy + " " + this.orderDirection + ")";
                                }
                                if (!errorfileName.isEmpty()) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", " + (String)errorfileName;
                                }
                                if (this.maxErrors > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", MAXERRORS=" + this.maxErrors;
                                }
                                if (this.batchSize > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", BATCHSIZE=" + this.batchSize;
                                }
                                if (this.rowsPerBatch > 0) {
                                    sqlBulkLoad = (String)sqlBulkLoad + ", ROWS_PER_BATCH=" + this.rowsPerBatch;
                                }
                                sqlBulkLoad = (String)sqlBulkLoad + ")";
                                try {
                                    db.execStatement((String)sqlBulkLoad);
                                    db.disconnect();
                                    if (this.isAddFileToResult()) {
                                        resultFile = new ResultFile(0, HopVfs.getFileObject((String)realFilename), this.parentWorkflow.getWorkflowName(), this.toString());
                                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                    }
                                    result.setResult(true);
                                }
                                catch (HopDatabaseException je) {
                                    result.setNrErrors(1L);
                                    this.logError("An error occurred executing this action : " + je.getMessage(), je);
                                }
                                catch (HopFileException e) {
                                    this.logError("An error occurred executing this action : " + e.getMessage(), e);
                                    result.setNrErrors(1L);
                                }
lbl137:
                                // 1 sources

                                result.setNrErrors(1L);
                                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.TableNotExists", (String[])new String[]{realTablename}));
                            }
                            catch (Throwable var17_24) {
                                throw var17_24;
                            }
                            finally {
                                db.close();
                            }
                        }
                        catch (HopDatabaseException dbe) {
                            result.setNrErrors(1L);
                            this.logError("An error occurred executing this entry: " + dbe.getMessage());
                        }
                    }
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Nodatabase.Label", (String[])new String[0]));
                }
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Error.FileNotExists", (String[])new String[]{realFilename}));
            }
        }
        result.setNrErrors(1L);
        this.logError(BaseMessages.getString(ActionMssqlBulkLoad.PKG, (String)"ActionMssqlBulkLoad.Nofilename.Label", (String[])new String[0]));
        return result;
    }

    public String getRealLineterminated() {
        return this.resolve(this.getLineTerminated());
    }

    public String getRealFieldTerminator() {
        return this.resolve(this.getFieldTerminator());
    }

    public String getRealOrderBy() {
        return this.resolve(this.getOrderBy());
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        DatabaseMeta dbMeta = null;
        if (this.connection != null) {
            try {
                dbMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.getMetadataProvider(), (String)this.connection);
            }
            catch (HopXmlException e) {
                this.logError("Error loading connection", e);
            }
            reference = new ResourceReference((IResourceHolder)this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(dbMeta.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(dbMeta.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.fileName != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "tablename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getDataFileType() {
        return this.dataFileType;
    }

    @Generated
    public String getFieldTerminator() {
        return this.fieldTerminator;
    }

    @Generated
    public String getLineTerminated() {
        return this.lineTerminated;
    }

    @Generated
    public String getCodePage() {
        return this.codePage;
    }

    @Generated
    public String getSpecificCodePage() {
        return this.specificCodePage;
    }

    @Generated
    public int getStartFile() {
        return this.startFile;
    }

    @Generated
    public int getEndFile() {
        return this.endFile;
    }

    @Generated
    public String getOrderBy() {
        return this.orderBy;
    }

    @Generated
    public boolean isAddFileToResult() {
        return this.addFileToResult;
    }

    @Generated
    public String getFormatFileName() {
        return this.formatFileName;
    }

    @Generated
    public boolean isFireTriggers() {
        return this.fireTriggers;
    }

    @Generated
    public boolean isCheckConstraints() {
        return this.checkConstraints;
    }

    @Generated
    public boolean isKeepNulls() {
        return this.keepNulls;
    }

    @Generated
    public boolean isTabLock() {
        return this.tabLock;
    }

    @Generated
    public String getErrorFileName() {
        return this.errorFileName;
    }

    @Generated
    public boolean isAddDatetime() {
        return this.addDatetime;
    }

    @Generated
    public String getOrderDirection() {
        return this.orderDirection;
    }

    @Generated
    public int getMaxErrors() {
        return this.maxErrors;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public int getRowsPerBatch() {
        return this.rowsPerBatch;
    }

    @Generated
    public boolean isKeepIdentity() {
        return this.keepIdentity;
    }

    @Generated
    public boolean isTruncate() {
        return this.truncate;
    }

    @Generated
    public String getConnection() {
        return this.connection;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Generated
    public void setDataFileType(String dataFileType) {
        this.dataFileType = dataFileType;
    }

    @Generated
    public void setFieldTerminator(String fieldTerminator) {
        this.fieldTerminator = fieldTerminator;
    }

    @Generated
    public void setLineTerminated(String lineTerminated) {
        this.lineTerminated = lineTerminated;
    }

    @Generated
    public void setCodePage(String codePage) {
        this.codePage = codePage;
    }

    @Generated
    public void setSpecificCodePage(String specificCodePage) {
        this.specificCodePage = specificCodePage;
    }

    @Generated
    public void setStartFile(int startFile) {
        this.startFile = startFile;
    }

    @Generated
    public void setEndFile(int endFile) {
        this.endFile = endFile;
    }

    @Generated
    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    @Generated
    public void setAddFileToResult(boolean addFileToResult) {
        this.addFileToResult = addFileToResult;
    }

    @Generated
    public void setFormatFileName(String formatFileName) {
        this.formatFileName = formatFileName;
    }

    @Generated
    public void setFireTriggers(boolean fireTriggers) {
        this.fireTriggers = fireTriggers;
    }

    @Generated
    public void setCheckConstraints(boolean checkConstraints) {
        this.checkConstraints = checkConstraints;
    }

    @Generated
    public void setKeepNulls(boolean keepNulls) {
        this.keepNulls = keepNulls;
    }

    @Generated
    public void setTabLock(boolean tabLock) {
        this.tabLock = tabLock;
    }

    @Generated
    public void setErrorFileName(String errorFileName) {
        this.errorFileName = errorFileName;
    }

    @Generated
    public void setAddDatetime(boolean addDatetime) {
        this.addDatetime = addDatetime;
    }

    @Generated
    public void setOrderDirection(String orderDirection) {
        this.orderDirection = orderDirection;
    }

    @Generated
    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Generated
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Generated
    public void setRowsPerBatch(int rowsPerBatch) {
        this.rowsPerBatch = rowsPerBatch;
    }

    @Generated
    public void setKeepIdentity(boolean keepIdentity) {
        this.keepIdentity = keepIdentity;
    }

    @Generated
    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    @Generated
    public void setConnection(String connection) {
        this.connection = connection;
    }
}

