/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.Trace;
import java.nio.CharBuffer;

class Mlog {
    static final char[] hexa = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static int loRange = 100;
    static int hiRange = 100;
    static int cnt = 1;
    static boolean logFlag;

    Mlog() {
    }

    public static boolean logEnable(boolean newFlag) {
        boolean oldFlag = logFlag;
        logFlag = newFlag;
        return oldFlag;
    }

    public static void putLine(String s) {
        if (!logFlag) {
            return;
        }
        int len = s.length();
        if (len <= loRange + hiRange) {
            Trace.log(5, cnt++ + ": " + s);
        } else {
            Trace.log(5, cnt++ + ": " + s.substring(0, loRange));
            Trace.log(5, ". . . " + (len - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, s.substring(len - hiRange, len));
        }
    }

    public static String toHex(char[] chars, boolean compact) {
        return Mlog.toHex(chars, 0, chars.length, compact);
    }

    public static String toHex(char[] input, int offset, int limit, boolean compact) {
        if (limit <= offset) {
            return "";
        }
        int len = limit - offset;
        char[] chars = new char[len * 5];
        int k = 0;
        for (int i = offset; i < limit; ++i) {
            char c = input[i];
            if (c < '\u0100') {
                if (!compact) {
                    chars[k++] = 48;
                    chars[k++] = 48;
                }
            } else {
                chars[k++] = hexa[c >> 12];
                chars[k++] = hexa[(c & 0xF00) >> 8];
            }
            chars[k++] = hexa[(c & 0xF0) >> 4];
            chars[k++] = hexa[c & 0xF];
            chars[k++] = 32;
        }
        return new String(chars, 0, k - 1);
    }

    public static String toHex(String s, boolean compact) {
        return Mlog.toHex(s.toCharArray(), 0, s.length(), compact);
    }

    public static void putHexLine(char[] input, boolean compact) {
        if (logFlag) {
            Mlog.putHexLine(input, 0, input.length, compact);
        }
    }

    public static void putHexLine(char[] input, int offset, int limit, boolean compact) {
        if (!logFlag) {
            return;
        }
        int len = limit - offset;
        if (len <= loRange + hiRange) {
            Trace.log(5, cnt + ": " + Mlog.toHex(input, offset, limit, compact));
            Trace.log(5, cnt++ + ": " + new String(input, offset, limit - offset));
        } else {
            Trace.log(5, cnt + ": " + Mlog.toHex(input, offset, offset + loRange, compact));
            Trace.log(5, ". . . " + (len - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, Mlog.toHex(input, limit - hiRange, limit, compact));
            Trace.log(5, cnt++ + ": " + new String(input, offset, loRange));
            Trace.log(5, ". . . " + (len - loRange - hiRange) + " chars omitted . . .");
            Trace.log(5, new String(input, limit - hiRange, hiRange));
        }
    }

    public static void putHexLine(String s) {
        if (logFlag) {
            Mlog.putHexLine(s.toCharArray(), false);
        }
    }

    public static void putHexLine(String s, boolean compact) {
        if (logFlag) {
            Mlog.putHexLine(s.toCharArray(), compact);
        }
    }

    public static boolean logReturn(boolean flag) {
        if (logFlag) {
            Mlog.putLine("return flag = " + flag);
        }
        return flag;
    }

    public static char[] logReturn(char[] chars) {
        if (logFlag) {
            Mlog.putLine("return chars = " + Mlog.toHex(chars, true));
            --cnt;
            Mlog.putLine("return chars = " + new String(chars));
        }
        return chars;
    }

    public static String logReturn(String s) {
        if (logFlag) {
            Mlog.putLine("return string = " + Mlog.toHex(s, true));
            --cnt;
            Mlog.putLine("return string = " + s);
        }
        return s;
    }

    public static CharBuffer logReturn(CharBuffer cb) {
        if (logFlag) {
            Mlog.putLine("return buffer = " + Mlog.toHex(cb.toString(), true));
            --cnt;
            Mlog.putLine("return buffer = " + cb.toString());
        }
        return cb;
    }

    public static void printStackTrace(String s) {
        if (!logFlag) {
            return;
        }
        Exception e = new Exception();
        StackTraceElement[] stack = e.getStackTrace();
        Mlog.putLine("Entering:  " + s);
        for (int i = 1; i < stack.length; ++i) {
            --cnt;
            Mlog.putLine("   " + stack[i].toString());
        }
    }
}

