/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Calendar;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.SQLConversionSettings;
import com.ibm.as400.access.SQLDataBase;
import java.io.CharConversionException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;

final class SQLDate
extends SQLDataBase {
    static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    private int dateFormat_;
    private int year_ = 0;
    private int month_ = 0;
    private int day_ = 0;

    SQLDate(SQLConversionSettings settings, int dateFormat) {
        super(settings);
        this.dateFormat_ = dateFormat;
    }

    @Override
    public Object clone() {
        return new SQLDate(this.settings_, this.dateFormat_);
    }

    public static Date stringToDate(String s, SQLConversionSettings settings, Calendar calendar) throws SQLException {
        String sTrim = s.trim();
        int sTrimLength = sTrim.length();
        try {
            if (sTrimLength == 0 || Integer.parseInt(sTrim) == 0) {
                return new Date(0L);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        try {
            switch (settings.getDateFormat()) {
                case 4: {
                    calendar.set(1, Integer.parseInt(s.substring(6, 10)));
                    calendar.set(2, Integer.parseInt(s.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(3, 5)));
                    break;
                }
                case 6: {
                    calendar.set(1, Integer.parseInt(s.substring(6, 10)));
                    calendar.set(2, Integer.parseInt(s.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(0, 2)));
                    break;
                }
                case 0: {
                    if (sTrimLength <= 6) {
                        calendar.set(6, Integer.parseInt(s.substring(3, 6)));
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(s.substring(0, 2))));
                        break;
                    }
                    calendar.set(6, Integer.parseInt(s.substring(5, 8)));
                    calendar.set(1, Integer.parseInt(s.substring(0, 4)));
                    break;
                }
                case 1: {
                    if (sTrimLength <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(s.substring(6, 8))));
                    } else {
                        calendar.set(1, Integer.parseInt(s.substring(6, 10)));
                    }
                    calendar.set(2, Integer.parseInt(s.substring(0, 2)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(3, 5)));
                    break;
                }
                case 2: {
                    if (sTrimLength <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(s.substring(6, 8))));
                    } else {
                        calendar.set(1, Integer.parseInt(s.substring(6, 10)));
                    }
                    calendar.set(2, Integer.parseInt(s.substring(3, 5)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(0, 2)));
                    break;
                }
                case 3: {
                    if (sTrimLength <= 8) {
                        calendar.set(1, SQLDate.twoDigitYearToFour(Integer.parseInt(s.substring(0, 2))));
                        calendar.set(2, Integer.parseInt(s.substring(3, 5)) - 1);
                        calendar.set(5, Integer.parseInt(s.substring(6, 8)));
                        break;
                    }
                    calendar.set(1, Integer.parseInt(s.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(s.substring(5, 7)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(8, 10)));
                    break;
                }
                case 5: 
                case 7: {
                    calendar.set(1, Integer.parseInt(s.substring(0, 4)));
                    calendar.set(2, Integer.parseInt(s.substring(5, 7)) - 1);
                    calendar.set(5, Integer.parseInt(s.substring(8, 10)));
                }
            }
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        catch (NumberFormatException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        catch (StringIndexOutOfBoundsException e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + s, e);
            }
            JDError.throwSQLException("07006", s);
        }
        try {
            long millis = calendar.getTimeInMillis();
            return new Date(millis);
        }
        catch (Exception e) {
            if (JDTrace.isTraceOn()) {
                JDTrace.logException(null, "Error parsing date " + s, e);
            }
            JDError.throwSQLException("07006", s);
            return null;
        }
    }

    public static String localDateToString(LocalDate d, SQLConversionSettings dateFormat, Calendar calendar) {
        GregorianCalendar gcal = new GregorianCalendar(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth());
        return SQLDate.dateToString(gcal.getTime(), dateFormat, calendar);
    }

    public static String dateToString(java.util.Date d, SQLConversionSettings dataFormat, Calendar calendar) {
        StringBuffer buffer = new StringBuffer();
        String separator = dataFormat.getDateSeparator();
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.setTime(d);
        switch (dataFormat.getDateFormat()) {
            case 4: {
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append('/');
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                buffer.append('/');
                buffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                break;
            }
            case 6: {
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                buffer.append('.');
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append('.');
                buffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                break;
            }
            case 0: {
                buffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(6), 3));
                break;
            }
            case 1: {
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                break;
            }
            case 2: {
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                break;
            }
            case 3: {
                buffer.append(JDUtilities.padZeros(calendar.get(1), 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append(separator);
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
                break;
            }
            case 5: 
            case 7: {
                buffer.append(JDUtilities.padZeros(calendar.get(1), 4));
                buffer.append('-');
                buffer.append(JDUtilities.padZeros(calendar.get(2) + 1, 2));
                buffer.append('-');
                buffer.append(JDUtilities.padZeros(calendar.get(5), 2));
            }
        }
        return buffer.toString();
    }

    private static int twoDigitYearToFour(int twoDigitYear) {
        return twoDigitYear <= 39 ? twoDigitYear + 2000 : twoDigitYear + 1900;
    }

    @Override
    public void convertFromRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter, boolean ignoreConversionErrors) throws SQLException {
        int connectionDateFormat = this.settings_.getDateFormat();
        switch (this.dateFormat_ != -1 && this.dateFormat_ != connectionDateFormat ? this.dateFormat_ : connectionDateFormat) {
            case 0: {
                this.year_ = SQLDate.twoDigitYearToFour((rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF));
                Calendar calendar = AS400Calendar.getGregorianInstance();
                calendar.clear();
                calendar.set(1, this.year_);
                calendar.set(6, (rawBytes[offset + 3] & 0xF) * 100 + (rawBytes[offset + 4] & 0xF) * 10 + (rawBytes[offset + 5] & 0xF));
                calendar.setTime(calendar.getTime());
                this.month_ = calendar.get(2);
                this.day_ = calendar.get(5);
                break;
            }
            case 1: {
                this.month_ = (rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF) - 1;
                this.day_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF);
                this.year_ = SQLDate.twoDigitYearToFour((rawBytes[offset + 6] & 0xF) * 10 + (rawBytes[offset + 7] & 0xF));
                break;
            }
            case 2: {
                this.day_ = (rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF);
                this.month_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF) - 1;
                this.year_ = SQLDate.twoDigitYearToFour((rawBytes[offset + 6] & 0xF) * 10 + (rawBytes[offset + 7] & 0xF));
                break;
            }
            case 3: {
                this.year_ = SQLDate.twoDigitYearToFour((rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF));
                this.month_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF) - 1;
                this.day_ = (rawBytes[offset + 6] & 0xF) * 10 + (rawBytes[offset + 7] & 0xF);
                break;
            }
            case 4: {
                this.month_ = (rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF) - 1;
                this.day_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF);
                this.year_ = (rawBytes[offset + 6] & 0xF) * 1000 + (rawBytes[offset + 7] & 0xF) * 100 + (rawBytes[offset + 8] & 0xF) * 10 + (rawBytes[offset + 9] & 0xF);
                break;
            }
            case 5: 
            case 7: {
                this.year_ = (rawBytes[offset + 0] & 0xF) * 1000 + (rawBytes[offset + 1] & 0xF) * 100 + (rawBytes[offset + 2] & 0xF) * 10 + (rawBytes[offset + 3] & 0xF);
                this.month_ = (rawBytes[offset + 5] & 0xF) * 10 + (rawBytes[offset + 6] & 0xF) - 1;
                this.day_ = (rawBytes[offset + 8] & 0xF) * 10 + (rawBytes[offset + 9] & 0xF);
                break;
            }
            case 6: {
                this.day_ = (rawBytes[offset + 0] & 0xF) * 10 + (rawBytes[offset + 1] & 0xF);
                this.month_ = (rawBytes[offset + 3] & 0xF) * 10 + (rawBytes[offset + 4] & 0xF) - 1;
                this.year_ = (rawBytes[offset + 6] & 0xF) * 1000 + (rawBytes[offset + 7] & 0xF) * 100 + (rawBytes[offset + 8] & 0xF) * 10 + (rawBytes[offset + 9] & 0xF);
            }
        }
    }

    @Override
    public void convertToRawBytes(byte[] rawBytes, int offset, ConvTable ccsidConverter) throws SQLException {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(JDUtilities.padZeros(this.year_, 4));
        buffer.append('-');
        buffer.append(JDUtilities.padZeros(this.month_ + 1, 2));
        buffer.append('-');
        buffer.append(JDUtilities.padZeros(this.day_, 2));
        try {
            ccsidConverter.stringToByteArray(buffer.toString(), rawBytes, offset);
        }
        catch (CharConversionException e) {
            JDError.throwSQLException("HY000", e);
        }
    }

    @Override
    public void set(Object object, Calendar calendar, int scale) throws SQLException {
        if (calendar == null) {
            calendar = AS400Calendar.getGregorianInstance();
            calendar.setLenient(false);
        } else {
            calendar = AS400Calendar.getConversionCalendar(calendar);
        }
        if (object instanceof String) {
            SQLDate.stringToDate((String)object, this.settings_, calendar);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof Timestamp) {
            calendar.setTime((Timestamp)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof java.util.Date) {
            calendar.setTime((java.util.Date)object);
            this.year_ = calendar.get(1);
            this.month_ = calendar.get(2);
            this.day_ = calendar.get(5);
        } else if (object instanceof LocalDate) {
            LocalDate d = (LocalDate)object;
            this.year_ = d.getYear();
            this.month_ = d.getMonthValue() - 1;
            this.day_ = d.getDayOfMonth();
        } else if (object instanceof LocalDateTime) {
            LocalDateTime d = (LocalDateTime)object;
            this.year_ = d.getYear();
            this.month_ = d.getMonthValue() - 1;
            this.day_ = d.getDayOfMonth();
        } else {
            if (JDTrace.isTraceOn()) {
                if (object == null) {
                    JDTrace.logInformation(this, "Unable to assign null object");
                } else {
                    JDTrace.logInformation(this, "Unable to assign object(" + object + ") of class(" + object.getClass().toString() + ")");
                }
            }
            if (object != null) {
                JDError.throwSQLException((Object)this, "07006", object.getClass().getName());
            } else {
                JDError.throwSQLException((Object)this, "07006");
            }
        }
    }

    @Override
    public int getSQLType() {
        return 10;
    }

    @Override
    public String getCreateParameters() {
        return null;
    }

    @Override
    public int getDisplaySize() {
        return 10;
    }

    @Override
    public String getJavaClassName() {
        return "java.sql.Date";
    }

    @Override
    public String getLiteralPrefix() {
        return "'";
    }

    @Override
    public String getLiteralSuffix() {
        return "'";
    }

    @Override
    public String getLocalName() {
        return "DATE";
    }

    @Override
    public int getMaximumPrecision() {
        return 10;
    }

    @Override
    public int getMaximumScale() {
        return 0;
    }

    @Override
    public int getMinimumScale() {
        return 0;
    }

    @Override
    public int getNativeType() {
        return 384;
    }

    @Override
    public int getPrecision() {
        return 10;
    }

    @Override
    public int getRadix() {
        return 10;
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public int getType() {
        return 91;
    }

    @Override
    public String getTypeName() {
        return "DATE";
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public boolean isText() {
        return false;
    }

    @Override
    public int getActualSize() {
        return 10;
    }

    @Override
    public int getTruncated() {
        return this.truncated_;
    }

    @Override
    public boolean getOutOfBounds() {
        return this.outOfBounds_;
    }

    @Override
    public BigDecimal getBigDecimal(int scale) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Blob getBlob() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return false;
    }

    @Override
    public byte getByte() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Date getDate(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        return new Date(millis);
    }

    @Override
    public double getDouble() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0;
    }

    @Override
    public float getFloat() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1.0f;
    }

    @Override
    public int getInt() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public long getLong() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1L;
    }

    @Override
    public Object getObject() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        return this.getDate(null);
    }

    @Override
    public short getShort() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return -1;
    }

    @Override
    public String getString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Date d = new Date(millis);
        return SQLDate.dateToString(d, this.settings_, calendar);
    }

    @Override
    public Time getTime(Calendar calendar) throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public Timestamp getTimestamp(Calendar calendar) throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        calendar = calendar == null ? AS400Calendar.getGregorianInstance() : AS400Calendar.getConversionCalendar(calendar);
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Timestamp ts = new Timestamp(millis);
        ts.setNanos(0);
        return ts;
    }

    @Override
    public String getNString() throws SQLException {
        this.truncated_ = 0;
        this.outOfBounds_ = false;
        Calendar calendar = AS400Calendar.getGregorianInstance();
        calendar.set(this.year_, this.month_, this.day_, 0, 0, 0);
        calendar.set(14, 0);
        long millis = calendar.getTimeInMillis();
        Date d = new Date(millis);
        return SQLDate.dateToString(d, this.settings_, calendar);
    }

    @Override
    public RowId getRowId() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public SQLXML getSQLXML() throws SQLException {
        JDError.throwSQLException((Object)this, "07006");
        return null;
    }

    @Override
    public void saveValue() throws SQLException {
        this.savedValue_ = this.getObject();
    }
}

