/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Result;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.LoggingRegistry;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateComponentMetrics;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineMetrics;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IEngineMetric;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;

public final class ExecutionStateBuilder {
    private ExecutionType executionType;
    private Date updateTime = new Date();
    private String statusDescription;
    private String parentId;
    private String id;
    private String name;
    private String copyNr;
    private String loggingText;
    private Integer lastLogLineNr;
    private List<ExecutionStateComponentMetrics> metrics = new ArrayList<ExecutionStateComponentMetrics>();
    private List<String> childIds = new ArrayList<String>();
    private boolean failed;
    private Map<String, String> details = new HashMap<String, String>();
    private String containerId;
    private Date executionEndDate;

    private ExecutionStateBuilder() {
    }

    public static ExecutionStateBuilder of() {
        return new ExecutionStateBuilder();
    }

    private static String getLoggingText(String logChannelId, Integer lastLogLineNr) {
        StringBuffer loggingTextBuffer = lastLogLineNr != null ? HopLogStore.getAppender().getBuffer(logChannelId, false, lastLogLineNr.intValue()) : HopLogStore.getAppender().getBuffer(logChannelId, false);
        return loggingTextBuffer.toString();
    }

    public static ExecutionStateBuilder fromExecutor(IPipelineEngine<PipelineMeta> pipeline, Integer lastLogLineNr) {
        String parentLogChannelId = pipeline.getParent() == null ? null : pipeline.getParent().getLogChannelId();
        int lastNrInLogStore = HopLogStore.getLastBufferLineNr();
        ExecutionStateBuilder builder = ExecutionStateBuilder.of().withExecutionType(ExecutionType.Pipeline).withParentId(parentLogChannelId).withId(pipeline.getLogChannelId()).withName(pipeline.getPipelineMeta().getName()).withLoggingText(ExecutionStateBuilder.getLoggingText(pipeline.getLogChannelId(), lastLogLineNr)).withLastLogLineNr(lastNrInLogStore).withFailed(pipeline.getErrors() > 0).withStatusDescription(pipeline.getStatusDescription()).withChildIds((List)LoggingRegistry.getInstance().getChildrenMap().get(pipeline.getLogChannelId())).withContainerId(pipeline.getContainerId()).withExecutionEndDate(pipeline.getExecutionEndDate());
        EngineMetrics engineMetrics = pipeline.getEngineMetrics();
        if (engineMetrics != null) {
            for (IEngineComponent component : pipeline.getComponents()) {
                ExecutionStateComponentMetrics componentMetrics = new ExecutionStateComponentMetrics(component.getName(), Integer.toString(component.getCopyNr()));
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_INIT);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_INPUT);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_OUTPUT);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_READ);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_WRITTEN);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_ERROR);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_REJECTED);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_UPDATED);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_BUFFER_IN);
                ExecutionStateBuilder.addMetric(componentMetrics, engineMetrics, component, Pipeline.METRIC_BUFFER_OUT);
                builder.addMetrics(componentMetrics);
            }
        }
        return builder;
    }

    public static ExecutionStateBuilder fromTransform(IPipelineEngine<PipelineMeta> pipeline, IEngineComponent component) {
        return ExecutionStateBuilder.of().withExecutionType(ExecutionType.Transform).withId(component.getLogChannelId()).withStatusDescription(component.getStatusDescription()).withFailed(component.getErrors() > 0L).withName(component.getName()).withCopyNr(Integer.toString(component.getCopyNr())).withParentId(pipeline.getLogChannelId()).withContainerId(pipeline.getContainerId()).withExecutionEndDate(component.getExecutionEndDate());
    }

    private static void addMetric(ExecutionStateComponentMetrics componentMetrics, EngineMetrics engineMetrics, IEngineComponent component, IEngineMetric metric) {
        Long value = engineMetrics.getComponentMetric(component, metric);
        if (value != null) {
            componentMetrics.getMetrics().put(metric.getHeader(), value);
        }
    }

    public static ExecutionStateBuilder fromExecutor(IWorkflowEngine<WorkflowMeta> workflow, Integer lastLogLineNr) {
        String parentLogChannelId = workflow.getParent() == null ? null : workflow.getParent().getLogChannelId();
        int lastNrInLogStore = HopLogStore.getLastBufferLineNr();
        Result result = workflow.getResult();
        return ExecutionStateBuilder.of().withExecutionType(ExecutionType.Workflow).withParentId(parentLogChannelId).withId(workflow.getLogChannelId()).withName(workflow.getWorkflowMeta().getName()).withLoggingText(ExecutionStateBuilder.getLoggingText(workflow.getLogChannelId(), lastLogLineNr)).withLastLogLineNr(lastNrInLogStore).withFailed(result != null && !result.isResult()).withStatusDescription(workflow.getStatusDescription()).withChildIds((List)LoggingRegistry.getInstance().getChildrenMap().get(workflow.getLogChannelId())).withContainerId(workflow.getContainerId()).withExecutionEndDate(workflow.getExecutionEndDate());
    }

    public ExecutionStateBuilder withExecutionType(ExecutionType executionType) {
        assert (executionType != null) : "Execution type can not be null";
        this.executionType = executionType;
        return this;
    }

    public ExecutionStateBuilder withParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public ExecutionStateBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public ExecutionStateBuilder withStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
        return this;
    }

    public ExecutionStateBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ExecutionStateBuilder withCopyNr(String copyNr) {
        this.copyNr = copyNr;
        return this;
    }

    public ExecutionStateBuilder withLoggingText(String loggingText) {
        this.loggingText = loggingText;
        return this;
    }

    public ExecutionStateBuilder withLastLogLineNr(Integer lastLogLineNr) {
        this.lastLogLineNr = lastLogLineNr;
        return this;
    }

    public ExecutionStateBuilder withMetrics(List<ExecutionStateComponentMetrics> metrics) {
        this.metrics = metrics;
        return this;
    }

    public ExecutionStateBuilder addMetrics(ExecutionStateComponentMetrics ... metrics) {
        this.metrics.addAll(Arrays.asList(metrics));
        return this;
    }

    public ExecutionStateBuilder withUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
        return this;
    }

    public ExecutionStateBuilder withChildIds(List<String> childIds) {
        this.childIds = childIds;
        return this;
    }

    public ExecutionStateBuilder withFailed(boolean failed) {
        this.failed = failed;
        return this;
    }

    public ExecutionStateBuilder withDetails(Map<String, String> details) {
        this.details = details;
        return this;
    }

    public ExecutionStateBuilder withContainerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    public ExecutionStateBuilder withExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
        return this;
    }

    public ExecutionState build() {
        ExecutionState state = new ExecutionState();
        state.setExecutionType(this.executionType);
        state.setParentId(this.parentId);
        state.setId(this.id);
        state.setName(this.name);
        state.setCopyNr(this.copyNr);
        state.setLoggingText(this.loggingText);
        state.setLastLogLineNr(this.lastLogLineNr);
        state.setMetrics(this.metrics);
        state.setUpdateTime(this.updateTime);
        state.setStatusDescription(this.statusDescription);
        state.setChildIds(this.childIds);
        state.setFailed(this.failed);
        state.setDetails(this.details);
        state.setContainerId(this.containerId);
        state.setExecutionEndDate(this.executionEndDate);
        return state;
    }
}

