/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelineSvgPainter;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.IHopServerPlugin;

@HopServerServlet(id="pipelineImage", name="Generate a PNG image of a pipeline")
public class GetPipelineImageServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -4365372274638005929L;
    public static final float ZOOM_FACTOR = 1.0f;
    private static final Class<?> PKG = GetPipelineImageServlet.class;
    public static final String CONTEXT_PATH = "/hop/pipelineImage";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            if (this.isJettyMode() && !request.getContextPath().startsWith(CONTEXT_PATH)) {
                return;
            }
            if (!this.supportGraphicEnvironment) {
                response.setStatus(204);
                return;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"GetPipelineImageServlet.Log.PipelineImageRequested", (String[])new String[0]));
            }
            String pipelineName = request.getParameter("name");
            String id = request.getParameter("id");
            try (ByteArrayOutputStream svgStream = null;){
                if (Utils.isEmpty((CharSequence)id)) {
                    throw new Exception("Please provide the ID of pipeline '" + pipelineName + "'");
                }
                HopServerObjectEntry entry = new HopServerObjectEntry(pipelineName, id);
                IPipelineEngine<PipelineMeta> pipeline = this.getPipelineMap().getPipeline(entry);
                if (pipeline == null) break block13;
                response.setStatus(200);
                response.setCharacterEncoding("UTF-8");
                response.setContentType("image/svg+xml");
                String svgXml = PipelineSvgPainter.generatePipelineSvg(pipeline.getPipelineMeta(), 1.0f, this.variables);
                svgStream = new ByteArrayOutputStream();
                try {
                    svgStream.write(svgXml.getBytes(StandardCharsets.UTF_8));
                }
                finally {
                    svgStream.flush();
                }
                response.setContentLength(svgStream.size());
                ServletOutputStream out = response.getOutputStream();
                out.write(svgStream.toByteArray());
            }
        }
    }

    public String toString() {
        return "Pipeline Image IHandler";
    }

    @Override
    public String getService() {
        return "/hop/pipelineImage (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

