/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tokenreplacement;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacement;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacementData;
import org.apache.hop.pipeline.transforms.tokenreplacement.TokenReplacementField;
import org.w3c.dom.Node;

@Transform(id="TokenReplacementPlugin", image="token.svg", name="i18n::TokenReplacement.Name", description="i18n::TokenReplacement.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::TokenReplacementMeta.keyword"}, documentationUrl="/pipeline/transforms/tokenreplacement.html")
@InjectionSupported(localizationPrefix="TokenReplacement.Injection.", groups={"OUTPUT_FIELDS"})
public class TokenReplacementMeta
extends BaseTransformMeta<TokenReplacement, TokenReplacementData> {
    private static final Class<?> PKG = TokenReplacementMeta.class;
    public static final String INPUT_TYPE = "input_type";
    public static final String INPUT_FIELD_NAME = "input_field_name";
    public static final String INPUT_FILENAME = "input_filename";
    public static final String INPUT_FILENAME_IN_FIELD = "input_filename_in_field";
    public static final String INPUT_FILENAME_FIELD = "input_filename_field";
    public static final String ADD_INPUT_FILENAME_TO_RESULT = "add_input_filename_to_result";
    public static final String OUTPUT_TYPE = "output_type";
    public static final String OUTPUT_FIELD_NAME = "output_field_name";
    public static final String OUTPUT_FILENAME = "output_filename";
    public static final String OUTPUT_FILENAME_IN_FIELD = "output_filename_in_field";
    public static final String OUTPUT_FILENAME_FIELD = "output_filename_field";
    public static final String APPEND_OUTPUT_FILENAME = "append_output_filename";
    public static final String CREATE_PARENT_FOLDER = "create_parent_folder";
    public static final String INCLUDE_TRANSFORM_NR_IN_OUTPUT_FILENAME = "include_transform_nr_in_output_filename";
    public static final String INCLUDE_PART_NR_IN_OUTPUT_FILENAME = "include_part_nr_in_output_filename";
    public static final String INCLUDE_DATE_IN_OUTPUT_FILENAME = "include_date_in_output_filename";
    public static final String INCLUDE_TIME_IN_OUTPUT_FILENAME = "include_time_in_output_filename";
    public static final String SPECIFY_DATE_FORMAT_OUTPUT_FILENAME = "specify_date_format_output_filename";
    public static final String DATE_FORMAT_OUTPUT_FILENAME = "date_format_output_filename";
    public static final String ADD_OUTPUT_FILENAME_TO_RESULT = "add_output_filename_to_result";
    public static final String TOKEN_START_STRING = "token_start_string";
    public static final String TOKEN_END_STRING = "token_end_string";
    public static final String FIELD_NAME = "field_name";
    public static final String TOKEN_NAME = "token_name";
    public static final String INPUT_TEXT = "input_text";
    public static final String OUTPUT_FILE_ENCODING = "output_file_encoding";
    public static final String OUTPUT_SPLIT_EVERY = "output_split_every";
    public static final String OUTPUT_FILE_FORMAT = "output_file_format";
    public static final String CONST_FIELD = "field";
    public static final String[] INPUT_TYPES = new String[]{"text", "field", "file"};
    public static final String[] OUTPUT_TYPES = new String[]{"field", "file"};
    public static final String[] formatMapperLineTerminator = new String[]{"DOS", "UNIX", "CR", "None"};
    public static final String[] formatMapperLineTerminatorDescriptions = new String[]{BaseMessages.getString(PKG, (String)"TokenReplacementDialog.Format.DOS", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TokenReplacementDialog.Format.UNIX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TokenReplacementDialog.Format.CR", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TokenReplacementDialog.Format.None", (String[])new String[0])};
    public static final String CONST_FILE_ENCODING = "file.encoding";
    public static final String CONST_UTF_8 = "UTF-8";
    @Injection(name="INPUT_TYPE")
    private String inputType;
    @Injection(name="INPUT_TEXT")
    private String inputText;
    @Injection(name="INPUT_FIELD")
    private String inputFieldName;
    @Injection(name="INPUT_FILENAME")
    private String inputFileName;
    @Injection(name="INPUT_FILENAME_IN_FIELD")
    private boolean inputFileNameInField;
    @Injection(name="INPUT_FILENAME_FIELD")
    private String inputFileNameField;
    @Injection(name="ADD_INPUT_FILENAME_TO_RESULT")
    private boolean addInputFileNameToResult;
    @Injection(name="OUTPUT_TYPE")
    private String outputType;
    @Injection(name="OUTPUT_FIELD")
    private String outputFieldName;
    @Injection(name="OUTPUT_FILENAME")
    private String outputFileName;
    @Injection(name="OUTPUT_FILENAME_IN_FIELD")
    private boolean outputFileNameInField;
    @Injection(name="OUTPUT_FILENAME_FIELD")
    private String outputFileNameField;
    @Injection(name="APPEND_OUTPUT_FILE")
    private boolean appendOutputFileName;
    @Injection(name="CREATE_PARENT_FOLDER")
    private boolean createParentFolder;
    @Injection(name="OUTPUT_FORMAT")
    private String outputFileFormat;
    @Injection(name="OUTPUT_ENCODING")
    private String outputFileEncoding;
    @Injection(name="OUTPUT_SPLIT_EVERY")
    private int splitEvery;
    @Injection(name="OUTPUT_INCLUDE_TRANSFORMNR")
    private boolean includeTransformNrInOutputFileName;
    @Injection(name="OUTPUT_INCLUDE_PARTNR")
    private boolean includePartNrInOutputFileName;
    @Injection(name="OUTPUT_INCLUDE_DATE")
    private boolean includeDateInOutputFileName;
    @Injection(name="OUTPUT_INCLUDE_TIME")
    private boolean includeTimeInOutputFileName;
    @Injection(name="OUTPUT_SPECIFY_DATE_FORMAT")
    private boolean specifyDateFormatOutputFileName;
    @Injection(name="OUTPUT_DATE_FORMAT")
    private String dateFormatOutputFileName;
    @Injection(name="ADD_OUTPUT_FILENAME_TO_RESULT")
    private boolean addOutputFileNameToResult;
    @Injection(name="TOKEN_START_STRING")
    private String tokenStartString;
    @Injection(name="TOKEN_END_STRING")
    private String tokenEndString;
    @InjectionDeep
    private TokenReplacementField[] tokenReplacementFields;

    public TokenReplacementMeta() {
        this.allocate(0);
    }

    public String getInputType() {
        return this.inputType;
    }

    public void setInputType(String inputType) {
        this.inputType = inputType;
    }

    public String getInputText() {
        return this.inputText;
    }

    public void setInputText(String inputText) {
        this.inputText = inputText;
    }

    public String getInputFieldName() {
        return this.inputFieldName;
    }

    public void setInputFieldName(String inputFieldName) {
        this.inputFieldName = inputFieldName;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String inputFileName) {
        this.inputFileName = inputFileName;
    }

    public boolean isInputFileNameInField() {
        return this.inputFileNameInField;
    }

    public void setInputFileNameInField(boolean inputFileNameInField) {
        this.inputFileNameInField = inputFileNameInField;
    }

    public String getInputFileNameField() {
        return this.inputFileNameField;
    }

    public void setInputFileNameField(String inputFileNameField) {
        this.inputFileNameField = inputFileNameField;
    }

    public boolean isAddInputFileNameToResult() {
        return this.addInputFileNameToResult;
    }

    public void setAddInputFileNameToResult(boolean addInputFileNameToResult) {
        this.addInputFileNameToResult = addInputFileNameToResult;
    }

    public String getOutputType() {
        return this.outputType;
    }

    public void setOutputType(String outputType) {
        this.outputType = outputType;
    }

    public String getOutputFieldName() {
        return this.outputFieldName;
    }

    public void setOutputFieldName(String outputFieldName) {
        this.outputFieldName = outputFieldName;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public boolean isOutputFileNameInField() {
        return this.outputFileNameInField;
    }

    public void setOutputFileNameInField(boolean outputFileNameInField) {
        this.outputFileNameInField = outputFileNameInField;
    }

    public String getOutputFileNameField() {
        return this.outputFileNameField;
    }

    public void setOutputFileNameField(String outputFileNameField) {
        this.outputFileNameField = outputFileNameField;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public String getOutputFileEncoding() {
        return Const.NVL((String)this.outputFileEncoding, (String)Const.getEnvironmentVariable((String)CONST_FILE_ENCODING, (String)CONST_UTF_8));
    }

    public void setOutputFileEncoding(String outputFileEncoding) {
        this.outputFileEncoding = outputFileEncoding;
    }

    public String getOutputFileFormat() {
        return this.outputFileFormat;
    }

    public String getOutputFileFormatString() {
        if (this.outputFileFormat.equals("DOS")) {
            return "\r\n";
        }
        if (this.outputFileFormat.equals("UNIX")) {
            return "\n";
        }
        if (this.outputFileFormat.equals("CR")) {
            return "\r";
        }
        return "";
    }

    public void setOutputFileFormat(String outputFileFormat) {
        this.outputFileFormat = outputFileFormat;
    }

    public int getSplitEvery() {
        return this.splitEvery;
    }

    public void setSplitEvery(int splitEvery) {
        this.splitEvery = splitEvery;
    }

    public boolean isIncludeTransformNrInOutputFileName() {
        return this.includeTransformNrInOutputFileName;
    }

    public void setIncludeTransformNrInOutputFileName(boolean includeTransformNrInOutputFileName) {
        this.includeTransformNrInOutputFileName = includeTransformNrInOutputFileName;
    }

    public boolean isIncludePartNrInOutputFileName() {
        return this.includePartNrInOutputFileName;
    }

    public void setIncludePartNrInOutputFileName(boolean includePartNrInOutputFileName) {
        this.includePartNrInOutputFileName = includePartNrInOutputFileName;
    }

    public boolean isIncludeDateInOutputFileName() {
        return this.includeDateInOutputFileName;
    }

    public void setIncludeDateInOutputFileName(boolean includeDateInOutputFileName) {
        this.includeDateInOutputFileName = includeDateInOutputFileName;
    }

    public boolean isIncludeTimeInOutputFileName() {
        return this.includeTimeInOutputFileName;
    }

    public void setIncludeTimeInOutputFileName(boolean includeTimeInOutputFileName) {
        this.includeTimeInOutputFileName = includeTimeInOutputFileName;
    }

    public boolean isSpecifyDateFormatOutputFileName() {
        return this.specifyDateFormatOutputFileName;
    }

    public void setSpecifyDateFormatOutputFileName(boolean specifyDateFormatOutputFileName) {
        this.specifyDateFormatOutputFileName = specifyDateFormatOutputFileName;
    }

    public String getDateFormatOutputFileName() {
        return this.dateFormatOutputFileName;
    }

    public void setDateFormatOutputFileName(String dateFormatOutputFileName) {
        this.dateFormatOutputFileName = dateFormatOutputFileName;
    }

    public boolean isAddOutputFileNameToResult() {
        return this.addOutputFileNameToResult;
    }

    public void setAddOutputFileNameToResult(boolean addOutputFileNameToResult) {
        this.addOutputFileNameToResult = addOutputFileNameToResult;
    }

    public String getTokenStartString() {
        return this.tokenStartString;
    }

    public void setTokenStartString(String tokenStartString) {
        this.tokenStartString = tokenStartString;
    }

    public String getTokenEndString() {
        return this.tokenEndString;
    }

    public void setTokenEndString(String tokenEndString) {
        this.tokenEndString = tokenEndString;
    }

    public TokenReplacementField[] getTokenReplacementFields() {
        return this.tokenReplacementFields;
    }

    public void setTokenReplacementFields(TokenReplacementField[] tokenReplacementFields) {
        this.tokenReplacementFields = tokenReplacementFields;
    }

    public boolean isAppendOutputFileName() {
        return this.appendOutputFileName;
    }

    public void setAppendOutputFileName(boolean appendOutputFileName) {
        this.appendOutputFileName = appendOutputFileName;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.inputType = XmlHandler.getTagValue((Node)transformNode, (String)INPUT_TYPE);
            this.inputText = XmlHandler.getTagValue((Node)transformNode, (String)INPUT_TEXT);
            this.inputFieldName = XmlHandler.getTagValue((Node)transformNode, (String)INPUT_FIELD_NAME);
            this.inputFileName = XmlHandler.getTagValue((Node)transformNode, (String)INPUT_FILENAME);
            this.inputFileNameInField = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)INPUT_FILENAME_IN_FIELD), (String)""));
            this.inputFileNameField = XmlHandler.getTagValue((Node)transformNode, (String)INPUT_FILENAME_FIELD);
            this.addInputFileNameToResult = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)ADD_INPUT_FILENAME_TO_RESULT), (String)""));
            this.outputType = XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_TYPE);
            this.outputFieldName = XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FIELD_NAME);
            this.outputFileName = XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FILENAME);
            this.outputFileNameInField = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FILENAME_IN_FIELD), (String)""));
            this.outputFileNameField = XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FILENAME_FIELD);
            this.appendOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)APPEND_OUTPUT_FILENAME), (String)""));
            this.outputFileFormat = XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FILE_FORMAT);
            this.outputFileEncoding = Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_FILE_ENCODING), (String)Const.getEnvironmentVariable((String)CONST_FILE_ENCODING, (String)CONST_UTF_8));
            this.splitEvery = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)OUTPUT_SPLIT_EVERY), (int)0);
            this.createParentFolder = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)CREATE_PARENT_FOLDER), (String)""));
            this.includeTransformNrInOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE_TRANSFORM_NR_IN_OUTPUT_FILENAME), (String)""));
            this.includePartNrInOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE_PART_NR_IN_OUTPUT_FILENAME), (String)""));
            this.includeDateInOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE_DATE_IN_OUTPUT_FILENAME), (String)""));
            this.includeTimeInOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)INCLUDE_TIME_IN_OUTPUT_FILENAME), (String)""));
            this.specifyDateFormatOutputFileName = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)SPECIFY_DATE_FORMAT_OUTPUT_FILENAME), (String)""));
            this.dateFormatOutputFileName = XmlHandler.getTagValue((Node)transformNode, (String)DATE_FORMAT_OUTPUT_FILENAME);
            this.addOutputFileNameToResult = "Y".equalsIgnoreCase(Const.NVL((String)XmlHandler.getTagValue((Node)transformNode, (String)ADD_OUTPUT_FILENAME_TO_RESULT), (String)""));
            this.tokenStartString = XmlHandler.getTagValue((Node)transformNode, (String)TOKEN_START_STRING);
            this.tokenEndString = XmlHandler.getTagValue((Node)transformNode, (String)TOKEN_END_STRING);
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrfields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.tokenReplacementFields[i] = new TokenReplacementField();
                this.tokenReplacementFields[i].setName(XmlHandler.getTagValue((Node)fnode, (String)FIELD_NAME));
                this.tokenReplacementFields[i].setTokenName(XmlHandler.getTagValue((Node)fnode, (String)TOKEN_NAME));
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"BaseTransformMeta.Exception.ErrorLoadingTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void allocate(int nrfields) {
        this.tokenReplacementFields = new TokenReplacementField[nrfields];
    }

    public Object clone() {
        TokenReplacementMeta retval = (TokenReplacementMeta)((Object)super.clone());
        int nrfields = this.tokenReplacementFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.tokenReplacementFields[i] = (TokenReplacementField)this.tokenReplacementFields[i].clone();
        }
        return retval;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(800);
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_TYPE, (String)this.inputType));
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_TEXT, (String)this.inputText));
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_FIELD_NAME, (String)this.inputFieldName));
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_FILENAME, (String)this.inputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_FILENAME_IN_FIELD, (boolean)this.inputFileNameInField));
        retval.append("    " + XmlHandler.addTagValue((String)INPUT_FILENAME_FIELD, (String)this.inputFileNameField));
        retval.append("    " + XmlHandler.addTagValue((String)ADD_INPUT_FILENAME_TO_RESULT, (boolean)this.addInputFileNameToResult));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_TYPE, (String)this.outputType));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FIELD_NAME, (String)this.outputFieldName));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FILENAME, (String)this.outputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FILENAME_IN_FIELD, (boolean)this.outputFileNameInField));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FILENAME_FIELD, (String)this.outputFileNameField));
        retval.append("    " + XmlHandler.addTagValue((String)APPEND_OUTPUT_FILENAME, (boolean)this.appendOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)CREATE_PARENT_FOLDER, (boolean)this.createParentFolder));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FILE_FORMAT, (String)this.outputFileFormat));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_FILE_ENCODING, (String)this.outputFileEncoding));
        retval.append("    " + XmlHandler.addTagValue((String)OUTPUT_SPLIT_EVERY, (int)this.splitEvery));
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE_TRANSFORM_NR_IN_OUTPUT_FILENAME, (boolean)this.includeTransformNrInOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE_PART_NR_IN_OUTPUT_FILENAME, (boolean)this.includePartNrInOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE_DATE_IN_OUTPUT_FILENAME, (boolean)this.includeDateInOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)INCLUDE_TIME_IN_OUTPUT_FILENAME, (boolean)this.includeTimeInOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)SPECIFY_DATE_FORMAT_OUTPUT_FILENAME, (boolean)this.specifyDateFormatOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)DATE_FORMAT_OUTPUT_FILENAME, (String)this.dateFormatOutputFileName));
        retval.append("    " + XmlHandler.addTagValue((String)ADD_OUTPUT_FILENAME_TO_RESULT, (boolean)this.addOutputFileNameToResult));
        retval.append("    " + XmlHandler.addTagValue((String)TOKEN_START_STRING, (String)this.tokenStartString));
        retval.append("    " + XmlHandler.addTagValue((String)TOKEN_END_STRING, (String)this.tokenEndString));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.tokenReplacementFields.length; ++i) {
            TokenReplacementField field = this.tokenReplacementFields[i];
            if (Utils.isEmpty((CharSequence)field.getName())) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XmlHandler.addTagValue((String)FIELD_NAME, (String)field.getName()));
            retval.append("        ").append(XmlHandler.addTagValue((String)TOKEN_NAME, (String)field.getTokenName()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    public void setDefault() {
        this.inputType = "Text";
        this.inputFileNameInField = false;
        this.addInputFileNameToResult = false;
        this.outputType = "Field";
        this.outputFileNameInField = false;
        this.appendOutputFileName = false;
        this.createParentFolder = false;
        this.includeTransformNrInOutputFileName = false;
        this.includePartNrInOutputFileName = false;
        this.includeDateInOutputFileName = false;
        this.includeTimeInOutputFileName = false;
        this.specifyDateFormatOutputFileName = false;
        this.addOutputFileNameToResult = false;
        this.outputFileEncoding = Const.getEnvironmentVariable((String)CONST_FILE_ENCODING, (String)CONST_UTF_8);
        this.outputFileFormat = Const.isWindows() ? "DOS" : "UNIX";
        this.splitEvery = 0;
        this.tokenStartString = "${";
        this.tokenEndString = "}";
    }

    public String buildFilename(String fileName, IVariables variables, int transformnr, String partnr, int splitnr) {
        return this.buildFilename(fileName, variables, transformnr, partnr, splitnr, this);
    }

    public String buildFilename(String filename, IVariables variables, int transformnr, String partnr, int splitnr, TokenReplacementMeta meta) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String realFileName = variables.resolve(filename);
        String extension = "";
        Object retval = "";
        if (realFileName.contains(".")) {
            retval = realFileName.substring(0, realFileName.lastIndexOf("."));
            extension = realFileName.substring(realFileName.lastIndexOf(".") + 1);
        } else {
            retval = realFileName;
        }
        Date now = new Date();
        if (meta.isSpecifyDateFormatOutputFileName() && !Utils.isEmpty((CharSequence)meta.getDateFormatOutputFileName())) {
            daf.applyPattern(meta.getDateFormatOutputFileName());
            String dt = daf.format(now);
            retval = (String)retval + dt;
        } else {
            if (meta.isIncludeDateInOutputFileName()) {
                daf.applyPattern("yyyMMdd");
                String d = daf.format(now);
                retval = (String)retval + "_" + d;
            }
            if (meta.isIncludeTimeInOutputFileName()) {
                daf.applyPattern("HHmmss");
                String t = daf.format(now);
                retval = (String)retval + "_" + t;
            }
        }
        if (meta.isIncludeTransformNrInOutputFileName()) {
            retval = (String)retval + "_" + transformnr;
        }
        if (meta.isIncludePartNrInOutputFileName()) {
            retval = (String)retval + "_" + partnr;
        }
        if (meta.getSplitEvery() > 0) {
            retval = (String)retval + "_" + splitnr;
        }
        if (!Utils.isEmpty((CharSequence)extension)) {
            retval = (String)retval + "." + extension;
        }
        return retval;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (TokenReplacementField tokenReplacementField : this.tokenReplacementFields) {
                int idx = prev.indexOfValue(tokenReplacementField.getName());
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + tokenReplacementField.getName() + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.FieldsNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
        if (Utils.isEmpty((CharSequence)this.tokenStartString) || Utils.isEmpty((CharSequence)this.tokenEndString)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.ExpectedTokenReplacementError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.ExpectedTokenReplacementOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"TokenReplacementMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.outputType.equalsIgnoreCase(CONST_FIELD)) {
            ValueMetaString v = new ValueMetaString(variables.resolve(this.outputFieldName));
            v.setOrigin(name);
            row.addValueMeta((IValueMeta)v);
        }
    }

    public static final String getOutputFileFormatDescription(String code) {
        int index = Const.indexOfString((String)code, (String[])formatMapperLineTerminator);
        if (index < 0) {
            index = 3;
        }
        return formatMapperLineTerminatorDescriptions[index];
    }
}

