/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.gs.config;

import lombok.Generated;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.vfs.gs.config.GoogleCloudConfig;
import org.apache.hop.vfs.gs.config.GoogleCloudConfigSingleton;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="GoogleCloudStorageConfigPlugin", description="Configuration options for Google Cloud", category="config")
@GuiPlugin(description="i18n::GoogleCloudPlugin.GuiPlugin.Description")
public class GoogleCloudConfigPlugin
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_ACCOUNT_KEY_FILE = "10000-google-cloud-service-account-key-file";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_SCAN_FOLDERS_FOR_MODIF_DATE = "10010-google-cloud-service-scan-folders-for-modification-date";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_MAX_ATTEMPTS = "10100-google-cloud-service-max-attempts";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_INITIAL_RETRY_DELAY = "10200-google-cloud-service-initial-retry-delay";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_RETRY_DELAY_MULTIPLIER = "10300-google-cloud-service-retry-delay-multiplier";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_MAX_RETRY_DELAY = "10400-google-cloud-service-max-retry-delay";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_TOTAL_TIMEOUT = "10500-google-cloud-service-total-timeout";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_INITIAL_RPC_TIMEOUT = "10600-google-cloud-service-inital-rpc-timeout";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_RPC_TIMEOUT_MULTIPLIER = "10700-google-cloud-service-rpc-timeout-multiplier";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_MAX_RPC_TIMEOUT = "10800-google-cloud-service-max-rpc-timeout";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_CONNECT_TIMEOUT = "10900-google-cloud-service-connect-timeout";
    private static final String WIDGET_ID_GOOGLE_CLOUD_SERVICE_READ_TIMEOUT = "1100-google-cloud-service-read-timeout";
    @GuiWidgetElement(id="10000-google-cloud-service-account-key-file", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.FILENAME, variables=true, label="i18n::GoogleCloudPlugin.AccountKeyFile.Label", toolTip="i18n::GoogleCloudPlugin.AccountKeyFile.Description")
    @CommandLine.Option(names={"-gck", "--google-cloud-service-account-key-file"}, description={"Configure the path to a Google Cloud service account JSON key file"})
    private String serviceAccountKeyFile;
    @GuiWidgetElement(id="10010-google-cloud-service-scan-folders-for-modification-date", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, variables=false, label="i18n::GoogleCloudPlugin.ScanFolderForLastModificationDate.Label", toolTip="i18n::GoogleCloudPlugin.ScanFolderForLastModificationDate.Description")
    private Boolean scanFoldersForModificationDate;
    @GuiWidgetElement(id="10100-google-cloud-service-max-attempts", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.MaxAttempts.Label", toolTip="i18n::GoogleCloudPlugin.MaxAttempts.Description")
    private String maxAttempts;
    @GuiWidgetElement(id="10200-google-cloud-service-initial-retry-delay", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.InitialRetryDelay.Label", toolTip="i18n::GoogleCloudPlugin.InitialRetryDelay.Description")
    private String initialRetryDelay;
    @GuiWidgetElement(id="10300-google-cloud-service-retry-delay-multiplier", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.RetryDelayMultiplier.Label", toolTip="i18n::GoogleCloudPlugin.RetryDelayMultiplier.Description")
    private String retryDelayMultiplier;
    @GuiWidgetElement(id="10400-google-cloud-service-max-retry-delay", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.MaxRetryDelay.Label", toolTip="i18n::GoogleCloudPlugin.MaxRetryDelay.Description")
    private String maxRetryDelay;
    @GuiWidgetElement(id="10500-google-cloud-service-total-timeout", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.TotalTimeout.Label", toolTip="i18n::GoogleCloudPlugin.TotalTimeout.Description")
    private String totalTimeout;
    @GuiWidgetElement(id="10600-google-cloud-service-inital-rpc-timeout", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.InitialRpcTimeout.Label", toolTip="i18n::GoogleCloudPlugin.InitialRpcTimeout.Description")
    private String initialRpcTimeout;
    @GuiWidgetElement(id="10700-google-cloud-service-rpc-timeout-multiplier", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.RpcTimeoutMultiplier.Label", toolTip="i18n::GoogleCloudPlugin.RpcTimeoutMultiplier.Description")
    private String rpcTimeoutMultiplier;
    @GuiWidgetElement(id="10800-google-cloud-service-max-rpc-timeout", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.MaxRpcTimeout.Label", toolTip="i18n::GoogleCloudPlugin.MaxRpcTimeout.Description")
    private String maxRpcTimeout;
    @GuiWidgetElement(id="10900-google-cloud-service-connect-timeout", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.ConnectTimeout.Label", toolTip="i18n::GoogleCloudPlugin.ConnectTimeout.Description")
    private String connectTimeout;
    @GuiWidgetElement(id="1100-google-cloud-service-read-timeout", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.TEXT, variables=true, label="i18n::GoogleCloudPlugin.ReadTimeout.Label", toolTip="i18n::GoogleCloudPlugin.ReadTimeout.Description")
    private String readTimeout;

    public static GoogleCloudConfigPlugin getInstance() {
        GoogleCloudConfigPlugin instance = new GoogleCloudConfigPlugin();
        GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
        instance.serviceAccountKeyFile = config.getServiceAccountKeyFile();
        instance.scanFoldersForModificationDate = config.getScanFoldersForLastModifDate();
        instance.maxAttempts = config.getMaxAttempts();
        instance.initialRetryDelay = config.getInitialRetryDelay();
        instance.retryDelayMultiplier = config.getRetryDelayMultiplier();
        instance.maxRetryDelay = config.getMaxRetryDelay();
        instance.totalTimeout = config.getTotalTimeout();
        instance.initialRpcTimeout = config.getInitialRpcTimeout();
        instance.rpcTimeoutMultiplier = config.getRpcTimeoutMultiplier();
        instance.maxRpcTimeout = config.getMaxRpcTimeout();
        instance.connectTimeout = config.getConnectionTimeout();
        instance.readTimeout = config.getReadTimeout();
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        GoogleCloudConfig config = GoogleCloudConfigSingleton.getConfig();
        try {
            boolean changed = false;
            if (this.serviceAccountKeyFile != null) {
                config.setServiceAccountKeyFile(this.serviceAccountKeyFile);
                log.logBasic("The Google Cloud service account JSON jey file is set to '" + this.serviceAccountKeyFile + "'");
                changed = true;
            }
            if (this.scanFoldersForModificationDate != null && this.scanFoldersForModificationDate.equals(Boolean.TRUE)) {
                config.setScanFoldersForLastModifDate(this.scanFoldersForModificationDate);
                log.logBasic("Google Cloud Storage service will scan folders for the last file modification time.");
                changed = true;
            }
            if (this.maxAttempts != null) {
                config.setMaxAttempts(this.maxAttempts);
                log.logBasic("Google Cloud service max attempts set to " + this.maxAttempts);
                changed = true;
            }
            if (this.initialRetryDelay != null) {
                config.setInitialRetryDelay(this.initialRetryDelay);
                log.logBasic("Google Cloud service initialRetryDelay set to " + this.initialRetryDelay);
                changed = true;
            }
            if (this.retryDelayMultiplier != null) {
                config.setRetryDelayMultiplier(this.retryDelayMultiplier);
                log.logBasic("Google Cloud service retryDelayMultiplier set to " + this.retryDelayMultiplier);
                changed = true;
            }
            if (this.maxRetryDelay != null) {
                config.setMaxRetryDelay(this.maxRetryDelay);
                log.logBasic("Google Cloud service maxRetryDelay set to " + this.maxRetryDelay);
                changed = true;
            }
            if (this.totalTimeout != null) {
                config.setTotalTimeout(this.totalTimeout);
                log.logBasic("Google Cloud service totalTimeout set to " + this.totalTimeout);
                changed = true;
            }
            if (this.initialRpcTimeout != null) {
                config.setInitialRpcTimeout(this.initialRpcTimeout);
                log.logBasic("Google Cloud service initialRpcTimeout set to " + this.initialRpcTimeout);
                changed = true;
            }
            if (this.rpcTimeoutMultiplier != null) {
                config.setRpcTimeoutMultiplier(this.rpcTimeoutMultiplier);
                log.logBasic("Google Cloud service rpcTimeoutMultiplier set to " + this.rpcTimeoutMultiplier);
                changed = true;
            }
            if (this.maxRpcTimeout != null) {
                config.setMaxRpcTimeout(this.maxRpcTimeout);
                log.logBasic("Google Cloud service maxRpcTimeout set to " + this.maxRpcTimeout);
                changed = true;
            }
            if (this.connectTimeout != null) {
                config.setConnectionTimeout(this.connectTimeout);
                log.logBasic("Google Cloud service connectTimeout set to " + this.connectTimeout);
                changed = true;
            }
            if (this.readTimeout != null) {
                config.setReadTimeout(this.readTimeout);
                log.logBasic("Google Cloud service readTimeout set to " + this.readTimeout);
                changed = true;
            }
            if (changed) {
                GoogleCloudConfigSingleton.saveConfig();
            }
            return changed;
        }
        catch (Exception e) {
            throw new HopException("Error handling Google Cloud configuration options", (Throwable)e);
        }
    }

    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.persistContents(compositeWidgets);
    }

    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        for (String widgetId : compositeWidgets.getWidgetsMap().keySet()) {
            Control control = (Control)compositeWidgets.getWidgetsMap().get(widgetId);
            switch (widgetId) {
                case "10000-google-cloud-service-account-key-file": {
                    this.serviceAccountKeyFile = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setServiceAccountKeyFile(this.serviceAccountKeyFile);
                    break;
                }
                case "10010-google-cloud-service-scan-folders-for-modification-date": {
                    this.scanFoldersForModificationDate = ((Button)control).getSelection();
                    GoogleCloudConfigSingleton.getConfig().setScanFoldersForLastModifDate(this.scanFoldersForModificationDate);
                    break;
                }
                case "10100-google-cloud-service-max-attempts": {
                    this.maxAttempts = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setMaxAttempts(this.maxAttempts);
                    break;
                }
                case "10200-google-cloud-service-initial-retry-delay": {
                    this.initialRetryDelay = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setInitialRetryDelay(this.initialRetryDelay);
                    break;
                }
                case "10300-google-cloud-service-retry-delay-multiplier": {
                    this.retryDelayMultiplier = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setRetryDelayMultiplier(this.retryDelayMultiplier);
                    break;
                }
                case "10400-google-cloud-service-max-retry-delay": {
                    this.maxRetryDelay = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setMaxRetryDelay(this.maxRetryDelay);
                    break;
                }
                case "10500-google-cloud-service-total-timeout": {
                    this.totalTimeout = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setTotalTimeout(this.totalTimeout);
                    break;
                }
                case "10600-google-cloud-service-inital-rpc-timeout": {
                    this.initialRpcTimeout = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setInitialRpcTimeout(this.initialRpcTimeout);
                    break;
                }
                case "10700-google-cloud-service-rpc-timeout-multiplier": {
                    this.rpcTimeoutMultiplier = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setRpcTimeoutMultiplier(this.rpcTimeoutMultiplier);
                    break;
                }
                case "10800-google-cloud-service-max-rpc-timeout": {
                    this.maxRpcTimeout = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setMaxRpcTimeout(this.maxRpcTimeout);
                    break;
                }
                case "10900-google-cloud-service-connect-timeout": {
                    this.connectTimeout = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setConnectionTimeout(this.connectTimeout);
                    break;
                }
                case "1100-google-cloud-service-read-timeout": {
                    this.readTimeout = ((TextVar)control).getText();
                    GoogleCloudConfigSingleton.getConfig().setReadTimeout(this.readTimeout);
                    break;
                }
            }
        }
        try {
            GoogleCloudConfigSingleton.saveConfig();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error saving option", e);
        }
    }

    @Generated
    public void setServiceAccountKeyFile(String serviceAccountKeyFile) {
        this.serviceAccountKeyFile = serviceAccountKeyFile;
    }

    @Generated
    public void setScanFoldersForModificationDate(Boolean scanFoldersForModificationDate) {
        this.scanFoldersForModificationDate = scanFoldersForModificationDate;
    }

    @Generated
    public void setMaxAttempts(String maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    @Generated
    public void setInitialRetryDelay(String initialRetryDelay) {
        this.initialRetryDelay = initialRetryDelay;
    }

    @Generated
    public void setRetryDelayMultiplier(String retryDelayMultiplier) {
        this.retryDelayMultiplier = retryDelayMultiplier;
    }

    @Generated
    public void setMaxRetryDelay(String maxRetryDelay) {
        this.maxRetryDelay = maxRetryDelay;
    }

    @Generated
    public void setTotalTimeout(String totalTimeout) {
        this.totalTimeout = totalTimeout;
    }

    @Generated
    public void setInitialRpcTimeout(String initialRpcTimeout) {
        this.initialRpcTimeout = initialRpcTimeout;
    }

    @Generated
    public void setRpcTimeoutMultiplier(String rpcTimeoutMultiplier) {
        this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
    }

    @Generated
    public void setMaxRpcTimeout(String maxRpcTimeout) {
        this.maxRpcTimeout = maxRpcTimeout;
    }

    @Generated
    public void setConnectTimeout(String connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Generated
    public void setReadTimeout(String readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Generated
    public String getServiceAccountKeyFile() {
        return this.serviceAccountKeyFile;
    }

    @Generated
    public Boolean getScanFoldersForModificationDate() {
        return this.scanFoldersForModificationDate;
    }

    @Generated
    public String getMaxAttempts() {
        return this.maxAttempts;
    }

    @Generated
    public String getInitialRetryDelay() {
        return this.initialRetryDelay;
    }

    @Generated
    public String getRetryDelayMultiplier() {
        return this.retryDelayMultiplier;
    }

    @Generated
    public String getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    @Generated
    public String getTotalTimeout() {
        return this.totalTimeout;
    }

    @Generated
    public String getInitialRpcTimeout() {
        return this.initialRpcTimeout;
    }

    @Generated
    public String getRpcTimeoutMultiplier() {
        return this.rpcTimeoutMultiplier;
    }

    @Generated
    public String getMaxRpcTimeout() {
        return this.maxRpcTimeout;
    }

    @Generated
    public String getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public String getReadTimeout() {
        return this.readTimeout;
    }
}

