/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.org.apache.hc.core5.util;

import com.clickhouse.client.internal.org.apache.hc.core5.annotation.Internal;
import java.lang.reflect.Method;

@Internal
public final class ReflectionUtils {
    public static void callSetter(Object object, String setterName, Class<?> type, Object value) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getMethod("set" + setterName, type);
            method.setAccessible(true);
            method.invoke(object, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> T callGetter(Object object, String getterName, Class<T> resultType) {
        return ReflectionUtils.callGetter(object, getterName, null, null, resultType);
    }

    public static <T> T callGetter(Object object, String getterName, Object arg, Class<?> argType, Class<T> resultType) {
        try {
            Class<?> clazz = object.getClass();
            if (arg != null) {
                assert (argType != null);
                Method method = clazz.getMethod("get" + getterName, argType);
                method.setAccessible(true);
                return resultType.cast(method.invoke(object, arg));
            }
            assert (argType == null);
            Method method = clazz.getMethod("get" + getterName, new Class[0]);
            method.setAccessible(true);
            return resultType.cast(method.invoke(object, new Object[0]));
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public static int determineJRELevel() {
        String s = System.getProperty("java.version");
        String[] parts = s.split("\\.");
        if (parts.length > 0) {
            try {
                int majorVersion = Integer.parseInt(parts[0]);
                if (majorVersion > 1) {
                    return majorVersion;
                }
                if (majorVersion == 1 && parts.length > 1) {
                    return Integer.parseInt(parts[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }
}

