/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MessageBox
extends Dialog {
    private static final Class<?> PKG = MessageBox.class;
    private final PropsUi props;
    private final int style;
    private String text;
    private String message;
    private int returnValue;
    private Shell shell;

    public MessageBox(Shell parent) {
        this(parent, 65538);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, style);
        this.style = style;
        this.props = PropsUi.getInstance();
        this.returnValue = 0;
    }

    public int open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 0xCF0 | this.style);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHop());
        this.shell.setText(Const.NVL((String)this.text, (String)""));
        FormLayout layout = new FormLayout();
        layout.marginLeft = PropsUi.getFormMargin();
        layout.marginRight = PropsUi.getFormMargin();
        layout.marginTop = PropsUi.getFormMargin();
        layout.marginBottom = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)layout);
        int margin = PropsUi.getMargin();
        Image iconImage = null;
        if ((this.style & 2) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(2);
        } else if ((this.style & 1) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(1);
        } else if ((this.style & 4) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(4);
        } else if ((this.style & 8) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(8);
        } else if ((this.style & 0x100) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(256);
        } else if ((this.style & 0x200) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(512);
        } else if ((this.style & 0x10) != 0) {
            iconImage = this.shell.getDisplay().getSystemImage(16);
        }
        Label wImage = null;
        if (iconImage != null) {
            wImage = new Label((Composite)this.shell, 0);
            wImage.setImage(iconImage);
            FormData fdImage = new FormData();
            fdImage.right = new FormAttachment(100, -margin);
            fdImage.top = new FormAttachment(100, margin);
            wImage.setLayoutData((Object)fdImage);
        }
        Label wMessage = new Label((Composite)this.shell, 16448);
        PropsUi.setLook((Widget)wMessage);
        wMessage.setText(this.message);
        FormData fdMessage = new FormData();
        fdMessage.left = new FormAttachment(0, 0);
        fdMessage.right = wImage != null ? new FormAttachment((Control)wImage, -margin) : new FormAttachment(100, 0);
        fdMessage.top = new FormAttachment(0, 0);
        wMessage.setLayoutData((Object)fdMessage);
        ArrayList<Button> buttons = new ArrayList<Button>();
        if ((this.style & 0x40) != 0) {
            Button wYes = new Button((Composite)this.shell, 8);
            wYes.setText(BaseMessages.getString(PKG, (String)"System.Button.Yes", (String[])new String[0]));
            wYes.addListener(13, e -> this.yes());
            buttons.add(wYes);
        }
        if ((this.style & 0x80) != 0) {
            Button wNo = new Button((Composite)this.shell, 8);
            wNo.setText(BaseMessages.getString(PKG, (String)"System.Button.No", (String[])new String[0]));
            wNo.addListener(13, e -> this.no());
            buttons.add(wNo);
        }
        if ((this.style & 0x100) != 0) {
            Button wCancel = new Button((Composite)this.shell, 8);
            wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            wCancel.addListener(13, e -> this.cancel());
            buttons.add(wCancel);
        }
        if ((this.style & 0x20) != 0 || buttons.isEmpty()) {
            Button wOk = new Button((Composite)this.shell, 8);
            wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            wOk.addListener(13, e -> this.ok());
            buttons.add(0, wOk);
        }
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons.toArray(new Button[0]), margin, (Control)wMessage);
        this.shell.addListener(21, e -> this.cancel());
        BaseTransformDialog.setSize(this.shell);
        this.shell.pack();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.returnValue;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void ok() {
        this.returnValue = 32;
        this.dispose();
    }

    public void cancel() {
        this.returnValue = 256;
        this.dispose();
    }

    public void yes() {
        this.returnValue = 64;
        this.dispose();
    }

    public void no() {
        this.returnValue = 128;
        this.dispose();
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void setReturnValue(int returnValue) {
        this.returnValue = returnValue;
    }
}

