/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Shell;

public class AnalyseImpactProgressDialog {
    private static final Class<?> PKG = AnalyseImpactProgressDialog.class;
    private Shell shell;
    private final IVariables variables;
    private PipelineMeta pipelineMeta;
    private List<DatabaseImpact> impact;
    private boolean impactHasRun;

    public AnalyseImpactProgressDialog(Shell shell, IVariables variables, PipelineMeta pipelineMeta, List<DatabaseImpact> impact) {
        this.shell = shell;
        this.variables = variables;
        this.pipelineMeta = pipelineMeta;
        this.impact = impact;
    }

    public boolean open() {
        IRunnableWithProgress op = monitor -> {
            try {
                this.impact.clear();
                this.pipelineMeta.analyseImpact(this.variables, this.impact, (IProgressMonitor)new ProgressMonitorAdapter(monitor));
                this.impactHasRun = true;
            }
            catch (Exception e) {
                this.impact.clear();
                this.impactHasRun = false;
                throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.RuntimeError.UnableToAnalyzeImpact.Exception", (String[])new String[]{e.toString()}));
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, op);
        }
        catch (InterruptedException | InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Messages", (String[])new String[0]), e);
        }
        return this.impactHasRun;
    }
}

