/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.minio.BaseArgs;
import io.minio.messages.RetentionMode;
import io.minio.messages.Tags;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PutObjectFanOutEntry
extends BaseArgs {
    @JsonProperty(value="key")
    String key;
    @JsonProperty(value="metadata")
    Map<String, String> userMetadata;
    @JsonProperty(value="tags")
    Map<String, String> tags;
    @JsonProperty(value="contentType")
    String contentType;
    @JsonProperty(value="contentEncoding")
    String contentEncoding;
    @JsonProperty(value="contentDisposition")
    String contentDisposition;
    @JsonProperty(value="contentLanguage")
    String contentLanguage;
    @JsonProperty(value="cacheControl")
    String cacheControl;
    @JsonProperty(value="retention")
    RetentionMode retention;
    @JsonProperty(value="retainUntil")
    ZonedDateTime retainUntilDate;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PutObjectFanOutEntry)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutObjectFanOutEntry that = (PutObjectFanOutEntry)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.userMetadata, that.userMetadata) && Objects.equals(this.tags, that.tags) && Objects.equals(this.contentType, that.contentType) && Objects.equals(this.contentEncoding, that.contentEncoding) && Objects.equals(this.contentDisposition, that.contentDisposition) && Objects.equals(this.contentLanguage, that.contentLanguage) && Objects.equals(this.cacheControl, that.cacheControl) && Objects.equals((Object)this.retention, (Object)that.retention) && Objects.equals(this.retainUntilDate, that.retainUntilDate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.key, this.userMetadata, this.tags, this.contentType, this.contentEncoding, this.contentDisposition, this.contentLanguage, this.cacheControl, this.retention, this.retainUntilDate});
    }

    public static final class Builder
    extends BaseArgs.Builder<Builder, PutObjectFanOutEntry> {
        @Override
        protected void validate(PutObjectFanOutEntry args) {
            this.validateNotEmptyString(args.key, "key");
        }

        public Builder key(String key) {
            this.validateNotEmptyString(key, "key");
            this.operations.add(args -> {
                args.key = key;
            });
            return this;
        }

        public Builder userMetadata(Map<String, String> userMetadata) {
            HashMap<String, String> userMetadataCopy = new HashMap<String, String>();
            if (userMetadata != null) {
                for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                    String key = entry.getKey();
                    userMetadataCopy.put((key.toLowerCase(Locale.US).startsWith("x-amz-meta-") ? "" : "x-amz-meta-") + key, entry.getValue());
                }
            }
            this.operations.add(args -> {
                args.userMetadata = userMetadata == null ? null : userMetadataCopy;
            });
            return this;
        }

        public Builder tags(Map<String, String> map) {
            Tags.newObjectTags(map);
            this.operations.add(args -> {
                args.tags = map;
            });
            return this;
        }

        public Builder tags(Tags tags) {
            this.operations.add(args -> {
                args.tags = tags == null ? null : tags.get();
            });
            return this;
        }

        public Builder contentType(String contentType) {
            this.operations.add(args -> {
                args.contentType = contentType;
            });
            return this;
        }

        public Builder contentEncoding(String contentEncoding) {
            this.operations.add(args -> {
                args.contentEncoding = contentEncoding;
            });
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.operations.add(args -> {
                args.contentDisposition = contentDisposition;
            });
            return this;
        }

        public Builder contentLanguage(String contentLanguage) {
            this.operations.add(args -> {
                args.contentLanguage = contentLanguage;
            });
            return this;
        }

        public Builder cacheControl(String cacheControl) {
            this.operations.add(args -> {
                args.cacheControl = cacheControl;
            });
            return this;
        }

        public Builder retention(RetentionMode retention) {
            this.operations.add(args -> {
                args.retention = retention;
            });
            return this;
        }

        public Builder retainUntilDate(ZonedDateTime retainUntilDate) {
            this.operations.add(args -> {
                args.retainUntilDate = retainUntilDate;
            });
            return this;
        }
    }
}

