/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.xml.xmljoin;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.core.xml.XmlParserFactoryProducer;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoinData;
import org.apache.hop.pipeline.transforms.xml.xmljoin.XmlJoinMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlJoin
extends BaseTransform<XmlJoinMeta, XmlJoinData> {
    private static final Class<?> PKG = XmlJoinMeta.class;
    public static final String CONST_XML_JOIN_EXCEPTION_FIELD_NOT_FOUND = "XmlJoin.Exception.FieldNotFound";
    private Transformer transformer;

    public XmlJoin(TransformMeta transformMeta, XmlJoinMeta meta, XmlJoinData data, int copyNr, PipelineMeta pipelineMeta, Pipeline trans) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, trans);
    }

    public boolean processRow() throws HopException {
        String[] sourceFieldNames;
        Object[] rJoinSource;
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (this.first) {
            this.first = false;
            int targetFieldId = -1;
            String targetStreamTransformName = ((XmlJoinMeta)this.meta).getTargetXmlTransform();
            if (StringUtils.isEmpty((String)targetStreamTransformName)) {
                throw new HopException("Please specify which transform to read the XML target stream rows from");
            }
            String sourceStreamTransformName = ((XmlJoinMeta)this.meta).getSourceXmlTransform();
            if (StringUtils.isEmpty((String)sourceStreamTransformName)) {
                throw new HopException("Please specify which transform to read the XML source stream rows from");
            }
            ((XmlJoinData)this.data).targetRowSet = this.findInputRowSet(targetStreamTransformName);
            if (((XmlJoinData)this.data).targetRowSet == null) {
                throw new HopException("Unable to find the XML target stream transform '" + targetStreamTransformName + "' to read from");
            }
            ((XmlJoinData)this.data).sourceRowSet = this.findInputRowSet(sourceStreamTransformName);
            if (((XmlJoinData)this.data).sourceRowSet == null) {
                throw new HopException("Unable to find the XML join source stream '" + sourceStreamTransformName + "' to read from");
            }
            Object[] rTarget = this.getRowFrom(((XmlJoinData)this.data).targetRowSet);
            if (rTarget == null) {
                this.logBasic(BaseMessages.getString(PKG, (String)"XmlJoin.NoRowsFoundInTarget", (String[])new String[0]));
                this.setOutputDone();
                return false;
            }
            IRowMeta targetStreamRowMeta = ((XmlJoinData)this.data).targetRowSet.getRowMeta();
            String[] targetStreamFieldNames = targetStreamRowMeta.getFieldNames();
            for (int i = 0; i < targetStreamFieldNames.length; ++i) {
                if (!this.variables.resolve(((XmlJoinMeta)this.meta).getTargetXmlField()).equals(targetStreamFieldNames[i])) continue;
                targetFieldId = i;
            }
            if (targetFieldId == -1) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_XML_JOIN_EXCEPTION_FIELD_NOT_FOUND, (String[])new String[]{this.variables.resolve(((XmlJoinMeta)this.meta).getTargetXmlField())}));
            }
            IRowMeta sourceStreamRowMeta = this.getPipelineMeta().getTransformFields((IVariables)this, sourceStreamTransformName);
            ((XmlJoinData)this.data).outputRowMeta = ((XmlJoinData)this.data).targetRowSet.getRowMeta().clone();
            ((XmlJoinMeta)this.meta).getFields(((XmlJoinData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{targetStreamRowMeta, sourceStreamRowMeta}, null, this.variables, this.metadataProvider);
            ((XmlJoinData)this.data).outputRowData = (Object[])rTarget.clone();
            String strTarget = (String)rTarget[targetFieldId];
            InputSource inputSource = new InputSource(new StringReader(strTarget));
            ((XmlJoinData)this.data).xPathStatement = this.variables.resolve(((XmlJoinMeta)this.meta).getTargetXPath());
            try {
                DocumentBuilder builder = XmlParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder();
                ((XmlJoinData)this.data).targetDom = builder.parse(inputSource);
                if (!((XmlJoinMeta)this.meta).isComplexJoin()) {
                    ((XmlJoinData)this.data).targetNode = (Node)xpath.evaluate(((XmlJoinData)this.data).xPathStatement, ((XmlJoinData)this.data).targetDom, XPathConstants.NODE);
                    if (((XmlJoinData)this.data).targetNode == null) {
                        throw new HopXmlException("XPath statement returned no result [" + ((XmlJoinData)this.data).xPathStatement + "]");
                    }
                }
            }
            catch (Exception e) {
                throw new HopXmlException((Throwable)e);
            }
        }
        if ((rJoinSource = this.getRowFrom(((XmlJoinData)this.data).sourceRowSet)) == null) {
            try {
                if (((XmlJoinMeta)this.meta).isOmitNullValues()) {
                    this.removeEmptyNodes(((XmlJoinData)this.data).targetDom.getChildNodes());
                }
                StringWriter sw = new StringWriter();
                StreamResult resultXML = new StreamResult(sw);
                DOMSource source = new DOMSource(((XmlJoinData)this.data).targetDom);
                this.getTransformer().transform(source, resultXML);
                int outputIndex = ((XmlJoinData)this.data).outputRowMeta.size() - 1;
                this.putRow(((XmlJoinData)this.data).outputRowMeta, RowDataUtil.addValueData((Object[])((XmlJoinData)this.data).outputRowData, (int)outputIndex, (Object)sw.toString()));
                this.setOutputDone();
                return false;
            }
            catch (Exception e) {
                throw new HopException((Throwable)e);
            }
        }
        if (((XmlJoinData)this.data).iSourceXMLField == -1) {
            sourceFieldNames = ((XmlJoinData)this.data).sourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < sourceFieldNames.length; ++i) {
                if (!this.variables.resolve(((XmlJoinMeta)this.meta).getSourceXmlField()).equals(sourceFieldNames[i])) continue;
                ((XmlJoinData)this.data).iSourceXMLField = i;
            }
            if (((XmlJoinData)this.data).iSourceXMLField == -1) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_XML_JOIN_EXCEPTION_FIELD_NOT_FOUND, (String[])new String[]{this.variables.resolve(((XmlJoinMeta)this.meta).getSourceXmlField())}));
            }
        }
        if (((XmlJoinMeta)this.meta).isComplexJoin() && ((XmlJoinData)this.data).iCompareFieldID == -1) {
            sourceFieldNames = ((XmlJoinData)this.data).sourceRowSet.getRowMeta().getFieldNames();
            for (int i = 0; i < sourceFieldNames.length; ++i) {
                if (!this.variables.resolve(((XmlJoinMeta)this.meta).getJoinCompareField()).equals(sourceFieldNames[i])) continue;
                ((XmlJoinData)this.data).iCompareFieldID = i;
            }
            if (((XmlJoinData)this.data).iCompareFieldID == -1) {
                throw new HopException(BaseMessages.getString(PKG, (String)CONST_XML_JOIN_EXCEPTION_FIELD_NOT_FOUND, (String[])new String[]{this.variables.resolve(((XmlJoinMeta)this.meta).getJoinCompareField())}));
            }
        }
        String strJoinXML = (String)rJoinSource[((XmlJoinData)this.data).iSourceXMLField];
        try {
            DocumentBuilder builder = XmlParserFactoryProducer.createSecureDocBuilderFactory().newDocumentBuilder();
            Document joinDocument = builder.parse(new InputSource(new StringReader(strJoinXML)));
            Node node = ((XmlJoinData)this.data).targetDom.importNode(joinDocument.getDocumentElement(), true);
            if (((XmlJoinMeta)this.meta).isComplexJoin()) {
                String strCompareValue = rJoinSource[((XmlJoinData)this.data).iCompareFieldID].toString();
                String strXPathStatement = ((XmlJoinData)this.data).xPathStatement.replace("?", strCompareValue);
                ((XmlJoinData)this.data).targetNode = (Node)xpath.evaluate(strXPathStatement, ((XmlJoinData)this.data).targetDom, XPathConstants.NODE);
                if (((XmlJoinData)this.data).targetNode == null) {
                    throw new HopXmlException("XPath statement returned no result [" + strXPathStatement + "]");
                }
            }
            ((XmlJoinData)this.data).targetNode.appendChild(node);
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
        return true;
    }

    public boolean init() {
        if (!super.init()) {
            return false;
        }
        try {
            Transformer transformer = XmlHandler.createSecureTransformerFactory().newTransformer();
            if (((XmlJoinMeta)this.meta).getEncoding() != null) {
                transformer.setOutputProperty("encoding", ((XmlJoinMeta)this.meta).getEncoding());
            }
            if (((XmlJoinMeta)this.meta).isOmitXmlHeader()) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            transformer.setOutputProperty("indent", "no");
            this.setTransformer(transformer);
            this.swapFirstInputRowSetIfExists(((XmlJoinMeta)this.meta).getTargetXmlTransform());
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"XmlJoin.Error.Init", (String[])new String[0]), e);
            return false;
        }
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    private void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    private Transformer getTransformer() {
        return this.transformer;
    }

    private void removeEmptyNodes(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            boolean nodeIsEmpty;
            Node node = nodes.item(i);
            if (node.hasChildNodes()) {
                this.removeEmptyNodes(node.getChildNodes());
            }
            boolean bl = nodeIsEmpty = node.getNodeType() == 1 && !node.hasAttributes() && !node.hasChildNodes() && node.getTextContent().isEmpty();
            if (!nodeIsEmpty) continue;
            node.getParentNode().removeChild(node);
            --i;
        }
    }
}

