/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.audit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.apache.cassandra.audit.AuditLogOptions;
import org.apache.cassandra.config.ParameterizedClass;
import org.apache.cassandra.utils.Pair;

public class AuditLogOptionsCompositeData {
    private static final AuditLogOption[] options = new AuditLogOption[]{AuditLogOption.option("audit_logs_dir", "directory where audit data are stored", SimpleType.STRING, o -> o.audit_logs_dir, (opts, obj) -> {
        opts.audit_logs_dir = (String)obj;
    }), AuditLogOption.option("archive_command", "archive command for audit data", SimpleType.STRING, o -> o.archive_command, (opts, obj) -> {
        opts.archive_command = (String)obj;
    }), AuditLogOption.option("roll_cycle", "how often to roll BinLog segments so they can potentially be reclaimed", SimpleType.STRING, o -> o.roll_cycle, (opts, obj) -> {
        opts.roll_cycle = (String)obj;
    }), AuditLogOption.option("block", "indicates if the BinLog should block if it falls behind or should drop bin log records", SimpleType.BOOLEAN, o -> o.block, (opts, obj) -> {
        opts.block = (Boolean)obj;
    }), AuditLogOption.option("max_queue_weight", "maximum weight of in-memory queue for records waiting to be written to the binlog file before blocking or dropping the log records", SimpleType.INTEGER, o -> o.max_queue_weight, (opts, obj) -> {
        opts.max_queue_weight = (Integer)obj;
    }), AuditLogOption.option("max_log_size", "maximum size of the rolled files to retain on disk before deleting the oldest file", SimpleType.LONG, o -> o.max_log_size, (opts, obj) -> {
        opts.max_log_size = (Long)obj;
    }), AuditLogOption.option("max_archive_retries", "number of times to retry an archive command", SimpleType.INTEGER, o -> o.max_archive_retries, (opts, obj) -> {
        opts.max_archive_retries = (Integer)obj;
    }), AuditLogOption.option("enabled", "boolean telling if we are enabled or not", SimpleType.BOOLEAN, o -> o.enabled, (opts, obj) -> {
        opts.enabled = (Boolean)obj;
    }), AuditLogOption.option("included_keyspaces", "included keyspaces", SimpleType.STRING, o -> o.included_keyspaces, (opts, obj) -> {
        opts.included_keyspaces = (String)obj;
    }), AuditLogOption.option("excluded_keyspaces", "excluded keyspaces", SimpleType.STRING, o -> o.excluded_keyspaces, (opts, obj) -> {
        opts.excluded_keyspaces = (String)obj;
    }), AuditLogOption.option("included_categories", "included categories", SimpleType.STRING, o -> o.included_categories, (opts, obj) -> {
        opts.included_categories = (String)obj;
    }), AuditLogOption.option("excluded_categories", "excluded categories", SimpleType.STRING, o -> o.excluded_categories, (opts, obj) -> {
        opts.excluded_categories = (String)obj;
    }), AuditLogOption.option("included_users", "included users", SimpleType.STRING, o -> o.included_users, (opts, obj) -> {
        opts.included_users = (String)obj;
    }), AuditLogOption.option("excluded_users", "excluded users", SimpleType.STRING, o -> o.excluded_users, (opts, obj) -> {
        opts.excluded_users = (String)obj;
    }), AuditLogOption.option("logger", "audit logger implementation class name", SimpleType.STRING, o -> o.logger.class_name, (opts, obj) -> {
        opts.logger = new ParameterizedClass((String)obj, new HashMap<String, String>());
    })};
    public static final CompositeType COMPOSITE_TYPE;

    public static CompositeData toCompositeData(AuditLogOptions opts) {
        try {
            HashMap valueMap = new HashMap();
            for (Pair pair : Arrays.stream(options).map(o -> Pair.create(((AuditLogOption)o).name, ((AuditLogOption)o).toCompositeMapping)).collect(Collectors.toList())) {
                valueMap.put(pair.left, ((Function)pair.right).apply(opts));
            }
            return new CompositeDataSupport(COMPOSITE_TYPE, valueMap);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static AuditLogOptions fromCompositeData(CompositeData data) {
        assert (data.getCompositeType().equals(COMPOSITE_TYPE));
        Object[] values = data.getAll((String[])Arrays.stream(options).map(o -> ((AuditLogOption)o).name).toArray(String[]::new));
        AuditLogOptions opts = new AuditLogOptions();
        for (int i = 0; i < values.length; ++i) {
            options[i].fromCompositeMapping.accept(opts, values[i]);
        }
        return opts;
    }

    static {
        try {
            COMPOSITE_TYPE = new CompositeType(AuditLogOptions.class.getName(), "AuditLogOptions", (String[])Arrays.stream(options).map(o -> ((AuditLogOption)o).name).toArray(String[]::new), (String[])Arrays.stream(options).map(o -> ((AuditLogOption)o).description).toArray(String[]::new), (OpenType[])Arrays.stream(options).map(o -> ((AuditLogOption)o).type).toArray(OpenType[]::new));
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static class AuditLogOption {
        public static final String AUDIT_LOGS_DIR = "audit_logs_dir";
        public static final String ARCHIVE_COMMAND = "archive_command";
        public static final String ROLL_CYCLE = "roll_cycle";
        public static final String BLOCK = "block";
        public static final String MAX_QUEUE_WEIGHT = "max_queue_weight";
        public static final String MAX_LOG_SIZE = "max_log_size";
        public static final String MAX_ARCHIVE_RETRIES = "max_archive_retries";
        public static final String ENABLED = "enabled";
        public static final String INCLUDED_KEYSPACES = "included_keyspaces";
        public static final String EXCLUDED_KEYSPACES = "excluded_keyspaces";
        public static final String INCLUDED_CATEGORIES = "included_categories";
        public static final String EXCLUDED_CATEGORIES = "excluded_categories";
        public static final String INCLUDED_USERS = "included_users";
        public static final String EXCLUDED_USERS = "excluded_users";
        public static final String LOGGER = "logger";
        private final String name;
        private final String description;
        private final OpenType<?> type;
        private final Function<AuditLogOptions, Object> toCompositeMapping;
        private final BiConsumer<AuditLogOptions, Object> fromCompositeMapping;

        public AuditLogOption(String name, String description, OpenType<?> type, Function<AuditLogOptions, Object> toCompositeMapping, BiConsumer<AuditLogOptions, Object> fromCompositeMapping) {
            this.name = name;
            this.description = description;
            this.type = type;
            this.toCompositeMapping = toCompositeMapping;
            this.fromCompositeMapping = fromCompositeMapping;
        }

        public static AuditLogOption option(String name, String description, OpenType<?> type, Function<AuditLogOptions, Object> toCompositeMapping, BiConsumer<AuditLogOptions, Object> fromCompositeMapping) {
            return new AuditLogOption(name, description, type, toCompositeMapping, fromCompositeMapping);
        }
    }
}

