/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.concurrent.ExecutorBuilder;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.SequentialExecutorPlus;
import org.apache.cassandra.concurrent.SingleThreadExecutorPlus;
import org.apache.cassandra.concurrent.ThreadPoolExecutorJMXAdapter;
import org.apache.cassandra.concurrent.ThreadPoolExecutorPlus;
import org.apache.cassandra.utils.concurrent.BlockingQueues;

public class ThreadPoolExecutorBuilder<E extends ExecutorPlus>
extends NamedThreadFactory.MetaFactory
implements ExecutorBuilder<E> {
    private final Function<ThreadPoolExecutorBuilder<E>, E> constructor;
    private final String name;
    private final int threads;
    private int threadPriority = 5;
    private Integer queueLimit;
    private long keepAlive = 1L;
    private TimeUnit keepAliveUnits = TimeUnit.MINUTES;
    private boolean allowCoreThreadTimeouts = true;
    private RejectedExecutionHandler rejectedExecutionHandler = null;

    static <E extends SequentialExecutorPlus> ExecutorBuilder<E> sequential(Function<ThreadPoolExecutorBuilder<E>, E> constructor, ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String name) {
        ThreadPoolExecutorBuilder<E> result = new ThreadPoolExecutorBuilder<E>(constructor, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, 1);
        result.withKeepAlive();
        return result;
    }

    static <E extends SingleThreadExecutorPlus> ExecutorBuilder<E> sequentialJmx(Function<ThreadPoolExecutorBuilder<E>, E> constructor, ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String name, String jmxPath) {
        return new ThreadPoolExecutorJMXAdapter.Builder<E>(ThreadPoolExecutorBuilder.sequential(constructor, contextClassLoader, threadGroup, uncaughtExceptionHandler, name), jmxPath);
    }

    static <E extends ExecutorPlus> ExecutorBuilder<E> pooled(Function<ThreadPoolExecutorBuilder<E>, E> constructor, ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String name, int threads) {
        return new ThreadPoolExecutorBuilder<E>(constructor, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, threads);
    }

    static <E extends ThreadPoolExecutorPlus> ExecutorBuilder<E> pooledJmx(Function<ThreadPoolExecutorBuilder<E>, E> constructor, ClassLoader contextClassLoader, ThreadGroup threadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String name, int threads, String jmxPath) {
        return new ThreadPoolExecutorJMXAdapter.Builder<E>(ThreadPoolExecutorBuilder.pooled(constructor, contextClassLoader, threadGroup, uncaughtExceptionHandler, name, threads), jmxPath);
    }

    protected ThreadPoolExecutorBuilder(Function<ThreadPoolExecutorBuilder<E>, E> constructor, ClassLoader contextClassLoader, ThreadGroup overrideThreadGroup, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, String name, int threads) {
        super(contextClassLoader, overrideThreadGroup, uncaughtExceptionHandler);
        this.constructor = constructor;
        this.name = name;
        this.threads = threads;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withKeepAlive(long keepAlive, TimeUnit keepAliveUnits) {
        this.allowCoreThreadTimeouts = true;
        this.keepAlive = keepAlive;
        this.keepAliveUnits = keepAliveUnits;
        return this;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withKeepAlive() {
        this.allowCoreThreadTimeouts = false;
        return this;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withThreadPriority(int threadPriority) {
        this.threadPriority = threadPriority;
        return this;
    }

    @Override
    public ExecutorBuilder<E> withThreadGroup(ThreadGroup threadGroup) {
        ThreadGroup parent;
        ThreadGroup current = this.threadGroup;
        for (parent = threadGroup; parent != null && parent != current; parent = parent.getParent()) {
        }
        if (parent != current) {
            throw new IllegalArgumentException("threadGroup may only be overridden with a child of the default threadGroup");
        }
        this.threadGroup = threadGroup;
        return this;
    }

    @Override
    public ExecutorBuilder<E> withDefaultThreadGroup() {
        this.threadGroup = null;
        return this;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withQueueLimit(int queueLimit) {
        this.queueLimit = queueLimit;
        return this;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        return this;
    }

    @Override
    public ThreadPoolExecutorBuilder<E> withUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        return this;
    }

    @Override
    public E build() {
        return (E)((ExecutorPlus)this.constructor.apply(this));
    }

    NamedThreadFactory newThreadFactory() {
        return this.newThreadFactory(this.name, this.threadPriority);
    }

    BlockingQueue<Runnable> newQueue() {
        int size = this.queueLimit != null ? this.queueLimit : (this.threads == Integer.MAX_VALUE ? 0 : Integer.MAX_VALUE);
        return BlockingQueues.newBlockingQueue(size);
    }

    int coreThreads() {
        return this.queueLimit != null && this.queueLimit == 0 || this.threads == Integer.MAX_VALUE ? 0 : this.threads;
    }

    int maxThreads() {
        return this.threads;
    }

    RejectedExecutionHandler rejectedExecutionHandler(RejectedExecutionHandler ifNotSet) {
        return this.rejectedExecutionHandler == null ? ifNotSet : this.rejectedExecutionHandler;
    }

    long keepAlive() {
        return this.keepAlive;
    }

    TimeUnit keepAliveUnits() {
        return this.keepAliveUnits;
    }

    boolean allowCoreThreadTimeouts() {
        return this.allowCoreThreadTimeouts;
    }
}

