/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.lifecycle.ProjectLifecycle;
import org.apache.hop.projects.project.ProjectConfig;

@JsonIgnoreProperties(value={"openingLastProjectAtStartup"})
public class ProjectsConfig {
    public static final String HOP_CONFIG_PROJECTS_CONFIG_KEY = "projectsConfig";
    public static final String DEFAULT_PROJECT_CONFIG_FILENAME = "project-config.json";
    private boolean enabled = true;
    private boolean projectMandatory;
    private boolean environmentMandatory;
    private boolean environmentsForActiveProject;
    private String defaultProject;
    private String defaultEnvironment;
    private String standardParentProject;
    private String standardProjectsFolder;
    private String defaultProjectConfigFile = "project-config.json";
    private List<ProjectConfig> projectConfigurations = new ArrayList<ProjectConfig>();
    private List<LifecycleEnvironment> lifecycleEnvironments = new ArrayList<LifecycleEnvironment>();
    private List<ProjectLifecycle> projectLifecycles = new ArrayList<ProjectLifecycle>();

    public ProjectsConfig() {
    }

    public ProjectsConfig(ProjectsConfig config) {
        this();
        this.enabled = config.enabled;
        this.projectConfigurations = new ArrayList<ProjectConfig>(config.projectConfigurations);
        this.lifecycleEnvironments = new ArrayList<LifecycleEnvironment>(config.lifecycleEnvironments);
        this.projectLifecycles = new ArrayList<ProjectLifecycle>(config.projectLifecycles);
        this.projectMandatory = config.projectMandatory;
        this.environmentMandatory = config.environmentMandatory;
        this.defaultProject = config.defaultProject;
        this.defaultEnvironment = config.defaultEnvironment;
        this.standardParentProject = config.standardParentProject;
        this.standardProjectsFolder = config.standardProjectsFolder;
        this.defaultProjectConfigFile = config.defaultProjectConfigFile;
        this.environmentsForActiveProject = config.environmentsForActiveProject;
    }

    public ProjectConfig findProjectConfig(String projectName) {
        if (StringUtils.isEmpty((String)projectName)) {
            return null;
        }
        for (ProjectConfig projectConfig : this.projectConfigurations) {
            if (!projectConfig.getProjectName().equalsIgnoreCase(projectName)) continue;
            return projectConfig;
        }
        return null;
    }

    public List<LifecycleEnvironment> findEnvironmentsOfProject(String projectName) {
        ArrayList<LifecycleEnvironment> list = new ArrayList<LifecycleEnvironment>();
        this.lifecycleEnvironments.stream().forEach(e -> {
            if (e.getProjectName().equals(projectName)) {
                list.add((LifecycleEnvironment)e);
            }
        });
        return list;
    }

    public void addProjectConfig(ProjectConfig projectConfig) {
        ProjectConfig existing = this.findProjectConfig(projectConfig.getProjectName());
        if (existing == null) {
            this.projectConfigurations.add(projectConfig);
        } else {
            existing.setProjectName(projectConfig.getProjectName());
            existing.setProjectHome(projectConfig.getProjectHome());
            existing.setConfigFilename(projectConfig.getConfigFilename());
        }
    }

    public int indexOfProjectConfig(String projectName) {
        return this.projectConfigurations.indexOf(new ProjectConfig(projectName, null, null));
    }

    public ProjectConfig removeProjectConfig(String projectName) {
        int index = this.indexOfProjectConfig(projectName);
        if (index >= 0) {
            return this.projectConfigurations.remove(index);
        }
        return null;
    }

    public List<String> listProjectConfigNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.projectConfigurations.stream().forEach(config -> names.add(config.getProjectName()));
        Collections.sort(names);
        return names;
    }

    public LifecycleEnvironment findEnvironment(String environmentName) {
        if (StringUtils.isEmpty((String)environmentName)) {
            return null;
        }
        for (LifecycleEnvironment environment : this.lifecycleEnvironments) {
            if (!environment.getName().equals(environmentName)) continue;
            return environment;
        }
        return null;
    }

    public void addEnvironment(LifecycleEnvironment environment) {
        int index = this.lifecycleEnvironments.indexOf(environment);
        if (index < 0) {
            this.lifecycleEnvironments.add(environment);
        } else {
            this.lifecycleEnvironments.set(index, environment);
        }
    }

    public LifecycleEnvironment removeEnvironment(String environmentName) {
        LifecycleEnvironment environment = this.findEnvironment(environmentName);
        if (environment != null) {
            this.lifecycleEnvironments.remove(environment);
        }
        return environment;
    }

    public List<String> listEnvironmentNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.lifecycleEnvironments.stream().forEach(env -> names.add(env.getName()));
        Collections.sort(names);
        return names;
    }

    public List<String> listEnvironmentNamesForProject(String projectName) {
        ArrayList<String> names = new ArrayList<String>();
        this.lifecycleEnvironments.stream().forEach(env -> {
            if (env.getProjectName().equals(projectName)) {
                names.add(env.getName());
            }
        });
        Collections.sort(names);
        return names;
    }

    public int indexOfEnvironment(String environmentName) {
        return this.lifecycleEnvironments.indexOf(new LifecycleEnvironment(environmentName, null, null, Collections.emptyList()));
    }

    public ProjectLifecycle findLifecycle(String lifecycleName) {
        if (StringUtils.isEmpty((String)lifecycleName)) {
            return null;
        }
        for (ProjectLifecycle lifecycle : this.projectLifecycles) {
            if (!lifecycle.equals(lifecycleName)) continue;
            return lifecycle;
        }
        return null;
    }

    public void addLifecycle(ProjectLifecycle lifecycle) {
        int index = this.projectLifecycles.indexOf(lifecycle);
        if (index < 0) {
            this.projectLifecycles.add(lifecycle);
        } else {
            this.projectLifecycles.set(index, lifecycle);
        }
    }

    public ProjectLifecycle removeLifecycle(String lifecycleName) {
        ProjectLifecycle lifecycle = this.findLifecycle(lifecycleName);
        if (lifecycle != null) {
            this.lifecycleEnvironments.remove(lifecycle);
        }
        return lifecycle;
    }

    public List<String> listLifecycleNames() {
        ArrayList<String> names = new ArrayList<String>();
        this.projectLifecycles.stream().forEach(lifecycle -> names.add(lifecycle.getName()));
        Collections.sort(names);
        return names;
    }

    public int indexOfLifecycle(String lifecycleName) {
        return this.projectLifecycles.indexOf(new ProjectLifecycle(lifecycleName, Collections.emptyList(), Collections.emptyList()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<ProjectConfig> getProjectConfigurations() {
        return this.projectConfigurations;
    }

    public void setProjectConfigurations(List<ProjectConfig> projectConfigurations) {
        this.projectConfigurations = projectConfigurations;
    }

    public List<LifecycleEnvironment> getLifecycleEnvironments() {
        return this.lifecycleEnvironments;
    }

    public void setLifecycleEnvironments(List<LifecycleEnvironment> lifecycleEnvironments) {
        this.lifecycleEnvironments = lifecycleEnvironments;
    }

    public String getDefaultProject() {
        return this.defaultProject;
    }

    public void setDefaultProject(String defaultProject) {
        this.defaultProject = defaultProject;
    }

    public boolean isProjectMandatory() {
        return this.projectMandatory;
    }

    public void setProjectMandatory(boolean projectMandatory) {
        this.projectMandatory = projectMandatory;
    }

    public boolean isEnvironmentMandatory() {
        return this.environmentMandatory;
    }

    public void setEnvironmentMandatory(boolean environmentMandatory) {
        this.environmentMandatory = environmentMandatory;
    }

    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    public void setDefaultEnvironment(String defaultEnvironment) {
        this.defaultEnvironment = defaultEnvironment;
    }

    public String getStandardParentProject() {
        return this.standardParentProject;
    }

    public void setStandardParentProject(String standardParentProject) {
        this.standardParentProject = standardParentProject;
    }

    public List<ProjectLifecycle> getProjectLifecycles() {
        return this.projectLifecycles;
    }

    public void setProjectLifecycles(List<ProjectLifecycle> projectLifecycles) {
        this.projectLifecycles = projectLifecycles;
    }

    public String getStandardProjectsFolder() {
        return this.standardProjectsFolder;
    }

    public void setStandardProjectsFolder(String standardProjectsFolder) {
        this.standardProjectsFolder = standardProjectsFolder;
    }

    public String getDefaultProjectConfigFile() {
        return this.defaultProjectConfigFile;
    }

    public void setDefaultProjectConfigFile(String defaultProjectConfigFile) {
        this.defaultProjectConfigFile = defaultProjectConfigFile;
    }

    public boolean isEnvironmentsForActiveProject() {
        return this.environmentsForActiveProject;
    }

    public void setEnvironmentsForActiveProject(boolean environmentsForActiveProject) {
        this.environmentsForActiveProject = environmentsForActiveProject;
    }
}

