/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.xp;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.project.ProjectConfig;

@ExtensionPoint(id="ProjectHomeExtensionPoint", description="Calculates the home folder for a given project name", extensionPointId="ProjectHome")
public class ProjectHomeExtensionPoint
implements IExtensionPoint<Object[]> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, Object[] objects) throws HopException {
        String projectName = variables.resolve((String)objects[0]);
        ProjectConfig projectConfig = ProjectsConfigSingleton.getConfig().findProjectConfig(projectName);
        if (projectConfig == null) {
            throw new HopException("Unable to find the project configuration for '" + projectName + "'");
        }
        objects[1] = variables.resolve(projectConfig.getProjectHome());
    }
}

