/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class DurationCoder
extends AtomicCoder<ReadableDuration> {
    private static final @UnknownKeyFor @NonNull @Initialized DurationCoder INSTANCE = new DurationCoder();
    private static final @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized ReadableDuration> TYPE_DESCRIPTOR = new TypeDescriptor<ReadableDuration>(){};
    private static final @UnknownKeyFor @NonNull @Initialized VarLongCoder LONG_CODER = VarLongCoder.of();

    public static @UnknownKeyFor @NonNull @Initialized DurationCoder of() {
        return INSTANCE;
    }

    private DurationCoder() {
    }

    private @UnknownKeyFor @NonNull @Initialized Long toLong(@UnknownKeyFor @NonNull @Initialized ReadableDuration value) {
        return value.getMillis();
    }

    private @UnknownKeyFor @NonNull @Initialized ReadableDuration fromLong(@UnknownKeyFor @NonNull @Initialized Long decoded) {
        return Duration.millis((long)decoded);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized ReadableDuration value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null ReadableDuration");
        }
        LONG_CODER.encode(this.toLong(value), outStream);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized ReadableDuration decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized CoderException, @UnknownKeyFor @NonNull @Initialized IOException {
        return this.fromLong(LONG_CODER.decode(inStream));
    }

    @Override
    public void verifyDeterministic() {
        LONG_CODER.verifyDeterministic();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized ReadableDuration value) {
        return LONG_CODER.isRegisterByteSizeObserverCheap(this.toLong(value));
    }

    @Override
    public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized ReadableDuration value, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        LONG_CODER.registerByteSizeObserver(this.toLong(value), observer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized ReadableDuration> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

