/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tika;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tika.Tika;
import org.apache.hop.pipeline.transforms.tika.TikaData;
import org.apache.hop.pipeline.transforms.tika.TikaFile;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="Tika", image="tika.svg", name="i18n::Tika.Name", description="i18n::Tika.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/apache-tika.html", keywords={"i18n::Tika.Keywords"})
public class TikaMeta
extends BaseTransformMeta<Tika, TikaData> {
    private static final Class<?> PKG = TikaMeta.class;
    @HopMetadataProperty(groupKey="files", key="file", injectionGroupDescription="TikaMeta.Injection.Files", injectionKeyDescription="TikaMeta.Injection.File")
    private List<TikaFile> files = new ArrayList<TikaFile>();
    @HopMetadataProperty(key="include-filename-field", injectionKeyDescription="TikaMeta.Injection.FilenameField")
    private String filenameField = "filename";
    @HopMetadataProperty(key="include-row-number-field", injectionKeyDescription="TikaMeta.Injection.RowNumberField")
    private String rowNumberField;
    @HopMetadataProperty(key="row-limit", injectionKeyDescription="TikaMeta.Injection.RowLimit")
    private long rowLimit;
    @HopMetadataProperty(key="output-format", injectionKeyDescription="TikaMeta.Injection.OutputFormat")
    private String outputFormat = "Plain text";
    @HopMetadataProperty(injectionKeyDescription="TikaMeta.Injection.Encoding")
    private String encoding;
    @HopMetadataProperty(key="dynamic-filename-field", injectionKeyDescription="TikaMeta.Injection.DynamicFilenameField")
    private String dynamicFilenameField;
    @HopMetadataProperty(key="file-in-field", injectionKeyDescription="TikaMeta.Injection.FileInField")
    private boolean fileInField;
    @HopMetadataProperty(key="add-result-file", injectionKeyDescription="TikaMeta.Injection.AddResultFile")
    private boolean addingResultFile;
    @HopMetadataProperty(key="ignore-empty-file", injectionKeyDescription="TikaMeta.Injection.IgnoreEmptyFile")
    private boolean ignoreEmptyFile;
    @HopMetadataProperty(key="content-field", injectionKeyDescription="TikaMeta.Injection.ContentFieldName")
    private String contentFieldName = "content";
    @HopMetadataProperty(key="file-size-field", injectionKeyDescription="TikaMeta.Injection.FileSizeFieldName")
    private String fileSizeFieldName = "fileSize";
    @HopMetadataProperty(key="short-filename-field", injectionKeyDescription="TikaMeta.Injection.ShortFileFieldName")
    private String shortFileFieldName;
    @HopMetadataProperty(key="path-field", injectionKeyDescription="TikaMeta.Injection.PathFieldName")
    private String pathFieldName;
    @HopMetadataProperty(key="hidden-field", injectionKeyDescription="TikaMeta.Injection.HiddenFlagFieldName")
    private String hiddenFieldName;
    @HopMetadataProperty(key="last-modification-time-field", injectionKeyDescription="TikaMeta.Injection.LastModDateFieldName")
    private String lastModificationTimeFieldName;
    @HopMetadataProperty(key="uri-field", injectionKeyDescription="TikaMeta.Injection.UriFieldName")
    private String uriFieldName;
    @HopMetadataProperty(key="root-uri-field", injectionKeyDescription="TikaMeta.Injection.RootUriFieldName")
    private String rootUriNameFieldName;
    @HopMetadataProperty(key="extension-field", injectionKeyDescription="TikaMeta.Injection.ExtensionFieldName")
    private String extensionFieldName;
    @HopMetadataProperty(key="metadata-field", injectionKeyDescription="TikaMeta.Injection.MetadataFieldName")
    private String metadataFieldName = "metadata";

    public TikaMeta() {
    }

    public TikaMeta(TikaMeta meta) {
        this();
        for (TikaFile file : meta.files) {
            this.files.add(new TikaFile(file));
        }
        this.contentFieldName = meta.contentFieldName;
        this.fileSizeFieldName = meta.fileSizeFieldName;
        this.filenameField = meta.filenameField;
        this.rowNumberField = meta.rowNumberField;
        this.rowLimit = meta.rowLimit;
        this.outputFormat = meta.outputFormat;
        this.encoding = meta.encoding;
        this.dynamicFilenameField = meta.dynamicFilenameField;
        this.fileInField = meta.fileInField;
        this.addingResultFile = meta.addingResultFile;
        this.ignoreEmptyFile = meta.ignoreEmptyFile;
        this.shortFileFieldName = meta.shortFileFieldName;
        this.pathFieldName = meta.pathFieldName;
        this.hiddenFieldName = meta.hiddenFieldName;
        this.lastModificationTimeFieldName = meta.lastModificationTimeFieldName;
        this.uriFieldName = meta.uriFieldName;
        this.rootUriNameFieldName = meta.rootUriNameFieldName;
        this.extensionFieldName = meta.extensionFieldName;
        this.metadataFieldName = meta.metadataFieldName;
    }

    public TikaMeta clone() {
        return new TikaMeta(this);
    }

    public void getFields(IRowMeta rowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString v;
        if (!this.isFileInField()) {
            rowMeta.clear();
        }
        if (StringUtils.isNotEmpty((String)this.contentFieldName)) {
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString(this.contentFieldName));
        }
        if (StringUtils.isNotEmpty((String)this.fileSizeFieldName)) {
            rowMeta.addValueMeta((IValueMeta)new ValueMetaInteger(this.fileSizeFieldName));
        }
        if (StringUtils.isNotEmpty((String)this.metadataFieldName)) {
            rowMeta.addValueMeta((IValueMeta)new ValueMetaString(variables.resolve(this.metadataFieldName)));
        }
        if (StringUtils.isNotEmpty((String)this.filenameField)) {
            v = new ValueMetaString(variables.resolve(this.filenameField));
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.rowNumberField)) {
            v = new ValueMetaInteger(variables.resolve(this.rowNumberField));
            v.setLength(10, 0);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.shortFileFieldName)) {
            v = new ValueMetaString(variables.resolve(this.shortFileFieldName));
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.extensionFieldName)) {
            v = new ValueMetaString(variables.resolve(this.extensionFieldName));
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.pathFieldName)) {
            v = new ValueMetaString(variables.resolve(this.pathFieldName));
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.hiddenFieldName)) {
            v = new ValueMetaString(variables.resolve(this.hiddenFieldName));
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.lastModificationTimeFieldName)) {
            v = new ValueMetaString(variables.resolve(this.lastModificationTimeFieldName));
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.uriFieldName)) {
            v = new ValueMetaString(variables.resolve(this.uriFieldName));
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
        if (StringUtils.isNotEmpty((String)this.rootUriNameFieldName)) {
            v = new ValueMetaString(variables.resolve(this.rootUriNameFieldName));
            v.setLength(100, -1);
            v.setOrigin(name);
            rowMeta.addValueMeta((IValueMeta)v);
        }
    }

    private String[] getFileNames() {
        String[] fileNames = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            fileNames[i] = this.files.get(i).getName();
        }
        return fileNames;
    }

    private String[] getFileMasks() {
        String[] fileMasks = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            fileMasks[i] = this.files.get(i).getMask();
        }
        return fileMasks;
    }

    private String[] getExcludeFileMasks() {
        String[] excludeFileMasks = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            excludeFileMasks[i] = this.files.get(i).getExcludeMask();
        }
        return excludeFileMasks;
    }

    private String[] getFileRequired() {
        String[] required = new String[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            required[i] = this.files.get(i).isRequired() ? "Y" : "N";
        }
        return required;
    }

    private boolean[] getIncludeSubFolders() {
        boolean[] included = new boolean[this.files.size()];
        for (int i = 0; i < this.files.size(); ++i) {
            included[i] = this.files.get(i).isIncludingSubFolders();
        }
        return included;
    }

    public FileInputList getFiles(IVariables variables) {
        return FileInputList.createFileList((IVariables)variables, (String[])this.getFileNames(), (String[])this.getFileMasks(), (String[])this.getExcludeFileMasks(), (String[])this.getFileRequired(), (boolean[])this.getIncludeSubFolders());
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (input.length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.NoInputExpected", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.NoInput", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.isFileInField()) {
            if (StringUtils.isEmpty((String)this.getDynamicFilenameField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.NoField", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.FieldOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(variables);
            if (fileInputList == null || fileInputList.getFiles().isEmpty()) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.NoFiles", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"TikaMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            if (!this.fileInField) {
                for (TikaFile file : this.files) {
                    FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(file.getName()), (IVariables)variables);
                    file.setName(iResourceNaming.nameResource(fileObject, variables, StringUtils.isEmpty((String)file.getMask())));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public List<TikaFile> getFiles() {
        return this.files;
    }

    public void setFiles(List<TikaFile> files) {
        this.files = files;
    }

    public String getContentFieldName() {
        return this.contentFieldName;
    }

    public void setContentFieldName(String contentFieldName) {
        this.contentFieldName = contentFieldName;
    }

    public String getFileSizeFieldName() {
        return this.fileSizeFieldName;
    }

    public void setFileSizeFieldName(String fileSizeFieldName) {
        this.fileSizeFieldName = fileSizeFieldName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDynamicFilenameField() {
        return this.dynamicFilenameField;
    }

    public void setDynamicFilenameField(String dynamicFilenameField) {
        this.dynamicFilenameField = dynamicFilenameField;
    }

    public boolean isFileInField() {
        return this.fileInField;
    }

    public void setFileInField(boolean fileInField) {
        this.fileInField = fileInField;
    }

    public boolean isAddingResultFile() {
        return this.addingResultFile;
    }

    public void setAddingResultFile(boolean addingResultFile) {
        this.addingResultFile = addingResultFile;
    }

    public boolean isIgnoreEmptyFile() {
        return this.ignoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean ignoreEmptyFile) {
        this.ignoreEmptyFile = ignoreEmptyFile;
    }

    public String getShortFileFieldName() {
        return this.shortFileFieldName;
    }

    public void setShortFileFieldName(String shortFileFieldName) {
        this.shortFileFieldName = shortFileFieldName;
    }

    public String getPathFieldName() {
        return this.pathFieldName;
    }

    public void setPathFieldName(String pathFieldName) {
        this.pathFieldName = pathFieldName;
    }

    public String getHiddenFieldName() {
        return this.hiddenFieldName;
    }

    public void setHiddenFieldName(String hiddenFieldName) {
        this.hiddenFieldName = hiddenFieldName;
    }

    public String getLastModificationTimeFieldName() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationTimeFieldName(String lastModificationTimeFieldName) {
        this.lastModificationTimeFieldName = lastModificationTimeFieldName;
    }

    public String getUriFieldName() {
        return this.uriFieldName;
    }

    public void setUriFieldName(String uriFieldName) {
        this.uriFieldName = uriFieldName;
    }

    public String getRootUriNameFieldName() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriNameFieldName(String rootUriNameFieldName) {
        this.rootUriNameFieldName = rootUriNameFieldName;
    }

    public String getExtensionFieldName() {
        return this.extensionFieldName;
    }

    public void setExtensionFieldName(String extensionFieldName) {
        this.extensionFieldName = extensionFieldName;
    }

    public String getMetadataFieldName() {
        return this.metadataFieldName;
    }

    public void setMetadataFieldName(String metadataFieldName) {
        this.metadataFieldName = metadataFieldName;
    }
}

