/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.keys;

import com.trilead.ssh2.packets.TypesReader;
import com.trilead.ssh2.packets.TypesWriter;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;

public class Ed25519PrivateKey
implements PrivateKey {
    private static final byte[] ED25519_OID = new byte[]{43, 101, 112};
    private static final int KEY_BYTES_LENGTH = 32;
    private static final int ENCODED_SIZE = 48;
    private final byte[] seed;
    private boolean destroyed;

    public Ed25519PrivateKey(byte[] hash) {
        this.seed = hash;
    }

    public Ed25519PrivateKey(PKCS8EncodedKeySpec keySpec) throws InvalidKeySpecException {
        this.seed = Ed25519PrivateKey.decode(keySpec);
    }

    public int hashCode() {
        return Arrays.hashCode(this.seed);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Ed25519PrivateKey)) {
            return false;
        }
        Ed25519PrivateKey other = (Ed25519PrivateKey)o;
        if (this.seed == null || other.seed == null || this.seed.length != other.seed.length) {
            return false;
        }
        int difference = 0;
        for (int i = 0; i < this.seed.length; ++i) {
            difference |= this.seed[i] ^ other.seed[i];
        }
        return difference == 0;
    }

    @Override
    public String getAlgorithm() {
        return "EdDSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public byte[] getEncoded() {
        TypesWriter tw = new TypesWriter();
        tw.writeByte(48);
        tw.writeByte(11 + ED25519_OID.length + this.seed.length);
        tw.writeByte(2);
        tw.writeByte(1);
        tw.writeByte(0);
        tw.writeByte(48);
        tw.writeByte(ED25519_OID.length + 2);
        tw.writeByte(6);
        tw.writeByte(ED25519_OID.length);
        tw.writeBytes(ED25519_OID);
        tw.writeByte(4);
        tw.writeByte(2 + this.seed.length);
        tw.writeByte(4);
        tw.writeByte(this.seed.length);
        tw.writeBytes(this.seed);
        return tw.getBytes();
    }

    private static byte[] decode(PKCS8EncodedKeySpec keySpec) throws InvalidKeySpecException {
        byte[] encoded = keySpec.getEncoded();
        if (encoded.length != 48) {
            throw new InvalidKeySpecException("Key spec is of invalid size");
        }
        try {
            TypesReader tr = new TypesReader(keySpec.getEncoded());
            if (tr.readByte() != 48 || tr.readByte() != 46 || tr.readByte() != 2 || tr.readByte() != 1 || tr.readByte() != 0 || tr.readByte() != 48 || tr.readByte() != ED25519_OID.length + 2 || tr.readByte() != 6 || tr.readByte() != ED25519_OID.length) {
                throw new InvalidKeySpecException("Key was not encoded correctly");
            }
            byte[] oid = tr.readBytes(ED25519_OID.length);
            if (!Arrays.equals(ED25519_OID, oid) || tr.readByte() != 4 || tr.readByte() != 34 || tr.readByte() != 4 || tr.readByte() != 32) {
                throw new InvalidKeySpecException("Key was not encoded correctly");
            }
            return tr.readBytes(32);
        }
        catch (IOException e) {
            throw new InvalidKeySpecException("Key was not encoded correctly", e);
        }
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Arrays.fill(this.seed, (byte)0);
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

