/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.Collections;
import java.util.Set;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;

class ClientJCacheEntryListenerAdapter<K, V>
implements CacheEntryUpdatedListener<K, V> {
    private final CacheEntryCreatedListener<K, V> crtLsnr;
    private final CacheEntryUpdatedListener<K, V> updLsnr;
    private final CacheEntryRemovedListener<K, V> rmvLsnr;
    private final CacheEntryExpiredListener<K, V> expLsnr;

    ClientJCacheEntryListenerAdapter(CacheEntryListener<? super K, ? super V> impl2) {
        this.crtLsnr = impl2 instanceof CacheEntryCreatedListener ? (CacheEntryCreatedListener)impl2 : evts -> {};
        this.updLsnr = impl2 instanceof CacheEntryUpdatedListener ? (CacheEntryUpdatedListener)impl2 : evts -> {};
        this.rmvLsnr = impl2 instanceof CacheEntryRemovedListener ? (CacheEntryRemovedListener)impl2 : evts -> {};
        this.expLsnr = impl2 instanceof CacheEntryExpiredListener ? (CacheEntryExpiredListener)impl2 : evts -> {};
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> evts) {
        for (CacheEntryEvent<K, V> cacheEntryEvent : evts) {
            try {
                Set<CacheEntryEvent<K, V>> evtColl = Collections.singleton(cacheEntryEvent);
                switch (cacheEntryEvent.getEventType()) {
                    case CREATED: {
                        this.crtLsnr.onCreated(evtColl);
                        break;
                    }
                    case UPDATED: {
                        this.updLsnr.onUpdated(evtColl);
                        break;
                    }
                    case REMOVED: {
                        this.rmvLsnr.onRemoved(evtColl);
                        break;
                    }
                    case EXPIRED: {
                        this.expLsnr.onExpired(evtColl);
                    }
                }
            }
            catch (Exception exception) {}
        }
    }
}

