/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.optimizer.affinity;

import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionDataTypeUtils;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionParameterType;
import org.jetbrains.annotations.Nullable;

public class PartitionClientContext {
    private int parts;
    private int mask;

    public PartitionClientContext(int parts) {
        assert (parts <= 65000);
        assert (parts > 0);
        this.parts = parts;
        this.mask = RendezvousAffinityFunction.calculateMask(parts);
    }

    @Nullable
    public Integer partition(Object arg, @Nullable PartitionParameterType typ) {
        if (typ == null) {
            return null;
        }
        Object key = PartitionDataTypeUtils.convert(arg, typ);
        if (key == PartitionDataTypeUtils.CONVERTATION_FAILURE) {
            return null;
        }
        if (key == null) {
            return null;
        }
        return RendezvousAffinityFunction.calculatePartition(key, this.mask, this.parts);
    }
}

