/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table.distributed.message;

import org.apache.ignite.internal.table.distributed.TableMessagesFactory;
import org.apache.ignite.internal.table.distributed.message.HasDataRequest;
import org.apache.ignite.internal.table.distributed.message.HasDataRequestBuilder;
import org.apache.ignite.network.serialization.MessageDeserializer;
import org.apache.ignite.network.serialization.MessageMappingException;
import org.apache.ignite.network.serialization.MessageReader;

class HasDataRequestDeserializer
implements MessageDeserializer<HasDataRequest> {
    private final HasDataRequestBuilder msg;

    HasDataRequestDeserializer(TableMessagesFactory messageFactory) {
        this.msg = messageFactory.hasDataRequest();
    }

    public Class<HasDataRequest> klass() {
        return HasDataRequest.class;
    }

    public HasDataRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.msg.partitionId(reader.readInt("partitionId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.msg.tableId(reader.readUuid("tableId"));
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(HasDataRequest.class);
    }
}

