/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.SchemaExistsException;
import org.apache.ignite.internal.catalog.commands.CreateSchemaCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSystemViewDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.NewSchemaEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;

public class CreateSchemaCommand
implements CatalogCommand {
    private final String schemaName;
    private final boolean ifNotExists;

    private CreateSchemaCommand(String schemaName, boolean ifNotExists) {
        CatalogParamsValidationUtils.validateIdentifier(schemaName, "Name of the schema");
        this.schemaName = schemaName;
        this.ifNotExists = ifNotExists;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        int id = catalog.objectIdGenState();
        CatalogSchemaDescriptor schema = catalog.schema(this.schemaName);
        if (this.ifNotExists && schema != null) {
            return List.of();
        }
        if (schema != null) {
            throw new SchemaExistsException(IgniteStringFormatter.format((String)"Schema with name '{}' already exists.", (Object[])new Object[]{this.schemaName}));
        }
        CatalogSchemaDescriptor newSchema = new CatalogSchemaDescriptor(id, this.schemaName, new CatalogTableDescriptor[0], new CatalogIndexDescriptor[0], new CatalogSystemViewDescriptor[0], 0L);
        return List.of(new NewSchemaEntry(newSchema), new ObjectIdGenUpdateEntry(1));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements CreateSchemaCommandBuilder {
        private String name;
        private boolean ifNotExists;

        @Override
        public CreateSchemaCommandBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public CreateSchemaCommandBuilder ifNotExists(boolean value) {
            this.ifNotExists = value;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new CreateSchemaCommand(this.name, this.ifNotExists);
        }
    }
}

