/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.tx;

import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.internal.client.tx.ClientTransaction;
import org.apache.ignite.internal.client.tx.ClientTransactions;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.tx.Transaction;
import org.apache.ignite.tx.TransactionException;
import org.apache.ignite.tx.TransactionOptions;
import org.jetbrains.annotations.Nullable;

public class ClientLazyTransaction
implements Transaction {
    private final long observableTimestamp;
    @Nullable
    private final TransactionOptions options;
    private volatile CompletableFuture<ClientTransaction> tx;

    ClientLazyTransaction(long observableTimestamp, @Nullable TransactionOptions options) {
        this.observableTimestamp = observableTimestamp;
        this.options = options;
    }

    public void commit() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        tx0.join().commit();
    }

    public CompletableFuture<Void> commitAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFuture.completedFuture(null);
        }
        return tx0.thenCompose(ClientTransaction::commitAsync);
    }

    public void rollback() throws TransactionException {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return;
        }
        tx0.join().rollback();
    }

    public CompletableFuture<Void> rollbackAsync() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 == null) {
            return CompletableFuture.completedFuture(null);
        }
        return tx0.thenCompose(ClientTransaction::rollbackAsync);
    }

    public boolean isReadOnly() {
        return this.options != null && this.options.readOnly();
    }

    @Nullable
    public String nodeName() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        return tx0 != null ? tx0.join().channel().protocolContext().clusterNode().name() : null;
    }

    @Nullable
    public static ClientLazyTransaction get(@Nullable Transaction tx) {
        if (tx == null) {
            return null;
        }
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return (ClientLazyTransaction)tx;
    }

    public static CompletableFuture<ClientTransaction> ensureStarted(@Nullable Transaction tx, ReliableChannel ch, @Nullable String preferredNodeName) {
        if (tx == null) {
            return CompletableFutures.nullCompletedFuture();
        }
        if (!(tx instanceof ClientLazyTransaction)) {
            throw ClientTransaction.unsupportedTxTypeException(tx);
        }
        return ((ClientLazyTransaction)tx).ensureStarted(ch, preferredNodeName);
    }

    private synchronized CompletableFuture<ClientTransaction> ensureStarted(ReliableChannel ch, @Nullable String preferredNodeName) {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        if (tx0 != null) {
            return tx0;
        }
        this.tx = tx0 = ClientTransactions.beginAsync(ch, preferredNodeName, this.options, this.observableTimestamp);
        return tx0;
    }

    public ClientTransaction startedTx() {
        CompletableFuture<ClientTransaction> tx0 = this.tx;
        assert (tx0 != null) : "Transaction is not started";
        assert (tx0.isDone()) : "Transaction is starting";
        return tx0.join();
    }
}

