/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.distributionzones.causalitydatanodes;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite.internal.causality.IncrementalVersionedValue;
import org.apache.ignite.internal.causality.OutdatedTokenException;
import org.apache.ignite.internal.causality.RevisionListenerRegistry;
import org.apache.ignite.internal.causality.VersionedValue;
import org.apache.ignite.internal.distributionzones.DataNodesMapSerializer;
import org.apache.ignite.internal.distributionzones.DistributionZoneManager;
import org.apache.ignite.internal.distributionzones.DistributionZonesUtil;
import org.apache.ignite.internal.distributionzones.Node;
import org.apache.ignite.internal.distributionzones.NodeWithAttributes;
import org.apache.ignite.internal.distributionzones.exception.DistributionZoneNotFoundException;
import org.apache.ignite.internal.lang.ByteArray;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.MetaStorageManager;
import org.apache.ignite.internal.util.ByteUtils;
import org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;

public class CausalityDataNodesEngine {
    private final IgniteSpinBusyLock busyLock;
    private final MetaStorageManager msManager;
    private final DistributionZoneManager distributionZoneManager;
    private final CatalogManager catalogManager;
    private final Map<Integer, DistributionZoneManager.ZoneState> zonesState;
    private final ConcurrentHashMap<Integer, Long> zonesCreateRevision = new ConcurrentHashMap();
    private final VersionedValue<Void> zonesVv;

    public CausalityDataNodesEngine(IgniteSpinBusyLock busyLock, RevisionListenerRegistry registry, MetaStorageManager msManager, Map<Integer, DistributionZoneManager.ZoneState> zonesState, DistributionZoneManager distributionZoneManager, CatalogManager catalogManager) {
        this.busyLock = busyLock;
        this.msManager = msManager;
        this.zonesState = zonesState;
        this.distributionZoneManager = distributionZoneManager;
        this.catalogManager = catalogManager;
        this.zonesVv = new IncrementalVersionedValue(registry);
    }

    public CompletableFuture<Set<String>> dataNodes(long causalityToken, int catalogVersion, int zoneId) {
        if (causalityToken < 1L) {
            throw new IllegalArgumentException("causalityToken must be greater then zero [causalityToken=" + causalityToken + "\"");
        }
        if (catalogVersion < 0) {
            throw new IllegalArgumentException("catalogVersion must be greater or equal to zero [catalogVersion=" + catalogVersion + "\"");
        }
        if (zoneId < 0) {
            throw new IllegalArgumentException("zoneId cannot be a negative number [zoneId=" + zoneId + "\"");
        }
        return ((CompletableFuture)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            try {
                return this.zonesVv.get(causalityToken);
            }
            catch (OutdatedTokenException e) {
                return CompletableFutures.nullCompletedFuture();
            }
        })).thenApply(ignored -> (Set)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> {
            CatalogZoneDescriptor zoneDescriptor = this.catalogManager.catalog(catalogVersion).zone(zoneId);
            if (zoneDescriptor == null) {
                throw new DistributionZoneNotFoundException(zoneId);
            }
            Long createRevision = this.zonesCreateRevision.get(zoneId);
            long descLastUpdateRevision = zoneDescriptor.updateToken();
            long lastScaleUpRevision = this.getRevisionsOfLastScaleUpEvent(causalityToken, catalogVersion, zoneId);
            long lastScaleDownRevision = this.getRevisionsOfLastScaleDownEvent(causalityToken, catalogVersion, zoneId);
            Entry dataNodes = this.msManager.getLocally(DistributionZonesUtil.zoneDataNodesKey(zoneId), causalityToken);
            if (createRevision != null && createRevision.equals(descLastUpdateRevision) && descLastUpdateRevision >= lastScaleUpRevision && descLastUpdateRevision >= lastScaleDownRevision && dataNodes.empty()) {
                Entry topologyEntry = this.msManager.getLocally(DistributionZonesUtil.zonesLogicalTopologyKey(), createRevision.longValue());
                if (topologyEntry.empty()) {
                    return Collections.emptySet();
                }
                Set<NodeWithAttributes> logicalTopology = DistributionZonesUtil.deserializeLogicalTopologySet(topologyEntry.value());
                Set<Node> logicalTopologyNodes = logicalTopology.stream().map(n -> n.node()).collect(Collectors.toSet());
                return DistributionZonesUtil.filterDataNodes(logicalTopologyNodes, zoneDescriptor, this.distributionZoneManager.nodesAttributes());
            }
            DistributionZoneManager.ZoneState zoneState = this.zonesState.get(zoneId);
            ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation> subAugmentationMap = null;
            if (zoneState != null) {
                subAugmentationMap = new ConcurrentSkipListMap<Long, DistributionZoneManager.Augmentation>(zoneState.topologyAugmentationMap().headMap((Object)causalityToken, true));
            }
            long scaleUpDataNodesRevision = this.searchTriggerKey(lastScaleUpRevision, zoneId, DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId));
            long scaleDownDataNodesRevision = this.searchTriggerKey(lastScaleDownRevision, zoneId, DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId));
            long dataNodesRevision = Math.max(causalityToken, Math.max(scaleUpDataNodesRevision, scaleDownDataNodesRevision));
            Entry dataNodesEntry = this.msManager.getLocally(DistributionZonesUtil.zoneDataNodesKey(zoneId), dataNodesRevision);
            Entry scaleUpChangeTriggerKey = this.msManager.getLocally(DistributionZonesUtil.zoneScaleUpChangeTriggerKey(zoneId), dataNodesRevision);
            Entry scaleDownChangeTriggerKey = this.msManager.getLocally(DistributionZonesUtil.zoneScaleDownChangeTriggerKey(zoneId), dataNodesRevision);
            if (dataNodesEntry.value() == null) {
                return Collections.emptySet();
            }
            Set<Node> baseDataNodes = DistributionZonesUtil.dataNodes(DataNodesMapSerializer.deserialize(dataNodesEntry.value()));
            long scaleUpTriggerRevision = ByteUtils.bytesToLongKeepingOrder((byte[])scaleUpChangeTriggerKey.value());
            long scaleDownTriggerRevision = ByteUtils.bytesToLongKeepingOrder((byte[])scaleDownChangeTriggerKey.value());
            HashSet<Node> finalDataNodes = new HashSet<Node>(baseDataNodes);
            if (subAugmentationMap != null) {
                subAugmentationMap.forEach((rev, augmentation) -> {
                    if (augmentation.addition() && rev > scaleUpTriggerRevision && rev <= lastScaleUpRevision) {
                        finalDataNodes.addAll(augmentation.nodes());
                    }
                    if (!augmentation.addition() && rev > scaleDownTriggerRevision && rev <= lastScaleDownRevision) {
                        finalDataNodes.removeAll(augmentation.nodes());
                    }
                });
            }
            return DistributionZonesUtil.filterDataNodes(finalDataNodes, zoneDescriptor, this.distributionZoneManager.nodesAttributes());
        }));
    }

    private long getRevisionsOfLastScaleUpEvent(long causalityToken, int catalogVersion, int zoneId) {
        return Math.max(this.getLastScaleUpConfigRevision(catalogVersion, zoneId), this.getLastScaleUpTopologyRevisions(causalityToken, catalogVersion, zoneId));
    }

    private long getRevisionsOfLastScaleDownEvent(long causalityToken, int catalogVersion, int zoneId) {
        return Math.max(this.getLastScaleDownConfigRevision(catalogVersion, zoneId), this.getLastScaleDownTopologyRevisions(causalityToken, catalogVersion, zoneId));
    }

    private long getLastScaleUpConfigRevision(int catalogVersion, int zoneId) {
        return this.getLastConfigRevision(catalogVersion, zoneId, true);
    }

    private long getLastScaleDownConfigRevision(int catalogVersion, int zoneId) {
        return this.getLastConfigRevision(catalogVersion, zoneId, false);
    }

    private long getLastConfigRevision(int catalogVersion, int zoneId, boolean isScaleUp) {
        CatalogZoneDescriptor entryOlderCfg;
        CatalogZoneDescriptor entryNewerCfg = null;
        for (int i = catalogVersion; i >= this.catalogManager.earliestCatalogVersion() && (entryOlderCfg = this.catalogManager.zone(zoneId, i)) != null; --i) {
            if (entryNewerCfg != null && (isScaleUp ? CausalityDataNodesEngine.isScaleUpConfigRevision(entryOlderCfg, entryNewerCfg) : CausalityDataNodesEngine.isScaleDownConfigRevision(entryOlderCfg, entryNewerCfg))) {
                return entryNewerCfg.updateToken();
            }
            entryNewerCfg = entryOlderCfg;
        }
        assert (entryNewerCfg != null) : "At least one zone configuration must be present .";
        return entryNewerCfg.updateToken();
    }

    private static boolean isScaleUpConfigRevision(CatalogZoneDescriptor olderCfg, CatalogZoneDescriptor newerCfg) {
        return olderCfg.dataNodesAutoAdjustScaleUp() != newerCfg.dataNodesAutoAdjustScaleUp() && newerCfg.dataNodesAutoAdjustScaleUp() == 0 || !olderCfg.filter().equals(newerCfg.filter());
    }

    private static boolean isScaleDownConfigRevision(CatalogZoneDescriptor olderCfg, CatalogZoneDescriptor newerCfg) {
        return olderCfg.dataNodesAutoAdjustScaleDown() != newerCfg.dataNodesAutoAdjustScaleDown() && newerCfg.dataNodesAutoAdjustScaleDown() == 0;
    }

    private long getLastScaleUpTopologyRevisions(long causalityToken, int catalogVersion, int zoneId) {
        return this.getLastTopologyRevisions(causalityToken, zoneId, catalogVersion, true);
    }

    private long getLastScaleDownTopologyRevisions(long causalityToken, int catalogVersion, int zoneId) {
        return this.getLastTopologyRevisions(causalityToken, zoneId, catalogVersion, false);
    }

    private long getLastTopologyRevisions(long causalityToken, int zoneId, int catalogVersion, boolean isScaleUp) {
        block4: {
            Entry topologyEntry = this.msManager.getLocally(DistributionZonesUtil.zonesLogicalTopologyKey(), causalityToken);
            if (topologyEntry.empty()) break block4;
            byte[] newerLogicalTopologyBytes = topologyEntry.value();
            Set<NodeWithAttributes> newerLogicalTopology = DistributionZonesUtil.deserializeLogicalTopologySet(newerLogicalTopologyBytes);
            long newerTopologyRevision = topologyEntry.revision();
            do {
                Set<NodeWithAttributes> olderLogicalTopology;
                if ((topologyEntry = this.msManager.getLocally(DistributionZonesUtil.zonesLogicalTopologyKey(), newerTopologyRevision - 1L)).empty()) {
                    olderLogicalTopology = Collections.emptySet();
                } else {
                    byte[] olderLogicalTopologyBytes = topologyEntry.value();
                    olderLogicalTopology = DistributionZonesUtil.deserializeLogicalTopologySet(olderLogicalTopologyBytes);
                }
                CatalogZoneDescriptor zoneDescriptor = this.catalogManager.catalog(catalogVersion).zone(zoneId);
                if (zoneDescriptor == null) break;
                if (isScaleUp ? CausalityDataNodesEngine.isScaleUpTopologyRevision(olderLogicalTopology, newerLogicalTopology, zoneDescriptor) : CausalityDataNodesEngine.isScaleDownTopologyRevision(olderLogicalTopology, newerLogicalTopology, zoneDescriptor)) {
                    return newerTopologyRevision;
                }
                newerLogicalTopology = olderLogicalTopology;
                newerTopologyRevision = topologyEntry.revision();
            } while (!topologyEntry.empty());
        }
        return 0L;
    }

    private static boolean isScaleUpTopologyRevision(Set<NodeWithAttributes> olderLogicalTopology, Set<NodeWithAttributes> newerLogicalTopology, CatalogZoneDescriptor zoneDescriptor) {
        return newerLogicalTopology.stream().anyMatch(node -> !olderLogicalTopology.contains(node)) && zoneDescriptor.dataNodesAutoAdjustScaleUp() == 0;
    }

    private static boolean isScaleDownTopologyRevision(Set<NodeWithAttributes> olderLogicalTopology, Set<NodeWithAttributes> newerLogicalTopology, CatalogZoneDescriptor zoneDescriptor) {
        return olderLogicalTopology.stream().anyMatch(node -> !newerLogicalTopology.contains(node)) && zoneDescriptor.dataNodesAutoAdjustScaleDown() == 0;
    }

    private long searchTriggerKey(Long scaleRevision, int zoneId, ByteArray triggerKey) {
        Entry lastEntry = this.msManager.getLocally(triggerKey, Long.MAX_VALUE);
        long upperRevision = Math.max(lastEntry.revision(), scaleRevision);
        List entryList = this.msManager.getLocally(triggerKey.bytes(), scaleRevision.longValue(), upperRevision);
        for (Entry entry : entryList) {
            if (entry.value() == null) {
                return entry.revision();
            }
            long entryScaleRevision = ByteUtils.bytesToLongKeepingOrder((byte[])entry.value());
            if (entryScaleRevision < scaleRevision) continue;
            return entry.revision();
        }
        return 0L;
    }

    public void onCreateZoneState(long revision, CatalogZoneDescriptor zone) {
        int zoneId = zone.id();
        this.zonesCreateRevision.put(zoneId, revision);
    }

    public void onDelete(long revision, int zoneId) {
    }
}

