/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.snapshot.local;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.ignite.raft.jraft.entity.LocalFileMetaOutter;
import org.apache.ignite.raft.jraft.error.RetryAgainException;
import org.apache.ignite.raft.jraft.storage.SnapshotThrottle;
import org.apache.ignite.raft.jraft.storage.io.LocalDirReader;
import org.apache.ignite.raft.jraft.storage.snapshot.local.LocalSnapshotMetaTable;
import org.apache.ignite.raft.jraft.util.ByteBufferCollector;

public class SnapshotFileReader
extends LocalDirReader {
    private final SnapshotThrottle snapshotThrottle;
    private LocalSnapshotMetaTable metaTable;

    public SnapshotFileReader(String path, SnapshotThrottle snapshotThrottle) {
        super(path);
        this.snapshotThrottle = snapshotThrottle;
    }

    public LocalSnapshotMetaTable getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(LocalSnapshotMetaTable metaTable) {
        this.metaTable = metaTable;
    }

    public boolean open() {
        File file = new File(this.getPath());
        return file.exists();
    }

    @Override
    public int readFile(ByteBufferCollector metaBufferCollector, String fileName, long offset, long maxCount) throws IOException, RetryAgainException {
        if (fileName.equals("__raft_snapshot_meta")) {
            ByteBuffer metaBuf = this.metaTable.saveToByteBufferAsRemote();
            metaBuf.position(metaBuf.limit());
            metaBufferCollector.setBuffer(metaBuf);
            return -1;
        }
        LocalFileMetaOutter.LocalFileMeta fileMeta = this.metaTable.getFileMeta(fileName);
        if (fileMeta == null) {
            throw new FileNotFoundException("LocalFileMeta not found for " + fileName);
        }
        long newMaxCount = maxCount;
        if (this.snapshotThrottle != null && (newMaxCount = this.snapshotThrottle.throttledByThroughput(maxCount)) < maxCount && newMaxCount == 0L) {
            throw new RetryAgainException("readFile throttled by throughput");
        }
        return this.readFileWithMeta(metaBufferCollector, fileName, fileMeta, offset, newMaxCount);
    }
}

