/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.deployunit.DeploymentUnitAccessor;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;

class DeploymentUnitAcquiredWaiter {
    private static final IgniteLogger LOG = Loggers.forClass(DeploymentUnitAcquiredWaiter.class);
    private final Queue<DeploymentUnit> queue = new ConcurrentLinkedDeque<DeploymentUnit>();
    private final DeploymentUnitAccessor deploymentUnitAccessor;
    private final ScheduledExecutorService executor;
    private final Consumer<DeploymentUnit> action;

    DeploymentUnitAcquiredWaiter(String nodeName, DeploymentUnitAccessor deploymentUnitAccessor, Consumer<DeploymentUnit> action) {
        this.deploymentUnitAccessor = deploymentUnitAccessor;
        this.executor = Executors.newScheduledThreadPool(1, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"deployment-unit-acquired-waiter", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
        this.action = action;
    }

    public void start(long delay, TimeUnit unit) {
        this.executor.scheduleWithFixedDelay(this::processQueue, 0L, delay, unit);
    }

    public void stop() {
        this.executor.shutdown();
    }

    private void processQueue() {
        int size = this.queue.size();
        for (int i = 0; i < size; ++i) {
            this.submitToAcquireRelease(this.queue.remove());
        }
    }

    public void submitToAcquireRelease(DeploymentUnit unit) {
        if (!this.deploymentUnitAccessor.computeIfNotAcquired(unit, this.action)) {
            this.queue.offer(unit);
        }
    }
}

