/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization.marshal;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.io.IOException;
import java.io.NotActiveException;
import java.util.Objects;
import org.apache.ignite3.internal.network.serialization.ClassDescriptor;
import org.apache.ignite3.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite3.internal.network.serialization.marshal.FlaggedObjectIds;
import org.apache.ignite3.internal.network.serialization.marshal.TypedValueWriter;
import org.apache.ignite3.internal.network.serialization.marshal.UosObjectOutputStream;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;

class MarshallingContext {
    private final IntSet usedDescriptorIds = new IntOpenHashSet();
    private final Object2IntMap<Object> objectsToIds = new Object2IntOpenCustomHashMap((Hash.Strategy)new IdentityHashStrategy());
    private int nextObjectId = 0;
    private Object objectCurrentlyWrittenWithWriteObject;
    private ClassDescriptor descriptorOfObjectCurrentlyWrittenWithWriteObject;
    private UosObjectOutputStream objectOutputStream;

    MarshallingContext() {
    }

    public void addUsedDescriptor(ClassDescriptor descriptor) {
        this.usedDescriptorIds.add(descriptor.descriptorId());
    }

    public IntSet usedDescriptorIds() {
        return this.usedDescriptorIds;
    }

    public long memorizeObject(Object object, boolean unshared) {
        Objects.requireNonNull(object);
        if (unshared) {
            int newId = this.nextId();
            return FlaggedObjectIds.freshObjectId(newId);
        }
        if (this.objectsToIds.containsKey(object)) {
            return FlaggedObjectIds.alreadySeenObjectId(this.objectsToIds.getInt(object));
        }
        int newId = this.nextId();
        this.objectsToIds.put(object, newId);
        return FlaggedObjectIds.freshObjectId(newId);
    }

    private int nextId() {
        return this.nextObjectId++;
    }

    public Object objectCurrentlyWrittenWithWriteObject() throws NotActiveException {
        if (this.objectCurrentlyWrittenWithWriteObject == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        return this.objectCurrentlyWrittenWithWriteObject;
    }

    public ClassDescriptor descriptorOfObjectCurrentlyWrittenWithWriteObject() {
        if (this.descriptorOfObjectCurrentlyWrittenWithWriteObject == null) {
            throw new IllegalStateException("No object is currently being written");
        }
        return this.descriptorOfObjectCurrentlyWrittenWithWriteObject;
    }

    public void startWritingWithWriteObject(Object object, ClassDescriptor descriptor) {
        this.objectCurrentlyWrittenWithWriteObject = object;
        this.descriptorOfObjectCurrentlyWrittenWithWriteObject = descriptor;
    }

    public void endWritingWithWriteObject() {
        this.objectCurrentlyWrittenWithWriteObject = null;
        this.descriptorOfObjectCurrentlyWrittenWithWriteObject = null;
    }

    UosObjectOutputStream objectOutputStream(IgniteDataOutput output, TypedValueWriter valueWriter, TypedValueWriter unsharedWriter, DefaultFieldsReaderWriter defaultFieldsReaderWriter) throws IOException {
        if (this.objectOutputStream == null) {
            this.objectOutputStream = new UosObjectOutputStream(output, valueWriter, unsharedWriter, defaultFieldsReaderWriter, this);
        }
        return this.objectOutputStream;
    }

    private static class IdentityHashStrategy
    implements Hash.Strategy<Object> {
        private IdentityHashStrategy() {
        }

        public int hashCode(Object o) {
            return System.identityHashCode(o);
        }

        public boolean equals(Object a, Object b) {
            return a == b;
        }
    }
}

