/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite3.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite3.internal.util.CollectionUtils;

public class FilterNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final Predicate<RowT> pred;
    private final Deque<RowT> inBuf;
    private int requested;
    private int waiting;
    private boolean inLoop;

    public FilterNode(ExecutionContext<RowT> ctx, Predicate<RowT> pred) {
        super(ctx);
        this.inBuf = new ArrayDeque<RowT>(this.inBufSize);
        this.pred = pred;
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        this.requested = rowsCnt;
        if (!this.inLoop) {
            this.execute(this::filter);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        --this.waiting;
        if (this.pred.test(row)) {
            this.inBuf.add(row);
        }
        this.filter();
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.waiting = -1;
        this.filter();
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.inBuf.clear();
    }

    private void filter() throws Exception {
        this.inLoop = true;
        try {
            int processed = 0;
            while (this.requested > 0 && !this.inBuf.isEmpty()) {
                --this.requested;
                this.downstream().push(this.inBuf.remove());
                if (processed++ < this.inBufSize) continue;
                this.execute(this::filter);
                break;
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.inBuf.isEmpty() && this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        }
        if (this.waiting == -1 && this.requested > 0) {
            assert (this.inBuf.isEmpty());
            this.requested = 0;
            this.downstream().end();
        }
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting);
    }
}

