/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.zip.GZIPInputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.JsonEncoding;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.JsonFactory;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.JsonGenerator;
import org.apache.flink.shaded.hadoop2.org.codehaus.jackson.util.MinimalPrettyPrinter;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AvroFSInput;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIsDirectoryException;
import org.apache.hadoop.fs.shell.CommandFactory;
import org.apache.hadoop.fs.shell.CommandFormat;
import org.apache.hadoop.fs.shell.FsCommand;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class Display
extends FsCommand {
    Display() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Cat.class, "-cat");
        factory.addClass(Text.class, "-text");
        factory.addClass(Checksum.class, "-checksum");
    }

    protected static class AvroFileInputStream
    extends InputStream {
        private int pos = 0;
        private byte[] buffer = new byte[0];
        private ByteArrayOutputStream output;
        private FileReader<?> fileReader;
        private DatumWriter<Object> writer;
        private JsonEncoder encoder;

        public AvroFileInputStream(FileStatus status) throws IOException {
            GenericDatumReader reader = new GenericDatumReader();
            FileContext fc = FileContext.getFileContext(new Configuration());
            this.fileReader = DataFileReader.openReader(new AvroFSInput(fc, status.getPath()), reader);
            Schema schema = this.fileReader.getSchema();
            this.writer = new GenericDatumWriter<Object>(schema);
            this.output = new ByteArrayOutputStream();
            JsonGenerator generator = new JsonFactory().createJsonGenerator(this.output, JsonEncoding.UTF8);
            MinimalPrettyPrinter prettyPrinter = new MinimalPrettyPrinter();
            prettyPrinter.setRootValueSeparator(System.getProperty("line.separator"));
            generator.setPrettyPrinter(prettyPrinter);
            this.encoder = EncoderFactory.get().jsonEncoder(schema, generator);
        }

        @Override
        public int read() throws IOException {
            if (this.pos < this.buffer.length) {
                return this.buffer[this.pos++];
            }
            if (!this.fileReader.hasNext()) {
                return -1;
            }
            this.writer.write(this.fileReader.next(), this.encoder);
            this.encoder.flush();
            if (!this.fileReader.hasNext()) {
                this.output.write(System.getProperty("line.separator").getBytes(StandardCharsets.UTF_8));
                this.output.flush();
            }
            this.pos = 0;
            this.buffer = this.output.toByteArray();
            this.output.reset();
            return this.read();
        }

        @Override
        public void close() throws IOException {
            this.fileReader.close();
            this.output.close();
            super.close();
        }
    }

    protected class TextRecordInputStream
    extends InputStream {
        SequenceFile.Reader r;
        WritableComparable<?> key;
        Writable val;
        DataInputBuffer inbuf;
        DataOutputBuffer outbuf;

        public TextRecordInputStream(FileStatus f) throws IOException {
            Path fpath = f.getPath();
            Configuration lconf = Display.this.getConf();
            this.r = new SequenceFile.Reader(lconf, SequenceFile.Reader.file(fpath));
            this.key = ReflectionUtils.newInstance(this.r.getKeyClass().asSubclass(WritableComparable.class), lconf);
            this.val = ReflectionUtils.newInstance(this.r.getValueClass().asSubclass(Writable.class), lconf);
            this.inbuf = new DataInputBuffer();
            this.outbuf = new DataOutputBuffer();
        }

        @Override
        public int read() throws IOException {
            int ret;
            if (null == this.inbuf || -1 == (ret = this.inbuf.read())) {
                if (!this.r.next(this.key, this.val)) {
                    return -1;
                }
                byte[] tmp = this.key.toString().getBytes(StandardCharsets.UTF_8);
                this.outbuf.write(tmp, 0, tmp.length);
                this.outbuf.write(9);
                tmp = this.val.toString().getBytes(StandardCharsets.UTF_8);
                this.outbuf.write(tmp, 0, tmp.length);
                this.outbuf.write(10);
                this.inbuf.reset(this.outbuf.getData(), this.outbuf.getLength());
                this.outbuf.reset();
                ret = this.inbuf.read();
            }
            return ret;
        }

        @Override
        public void close() throws IOException {
            this.r.close();
            super.close();
        }
    }

    public static class Checksum
    extends Display {
        public static final String NAME = "checksum";
        public static final String USAGE = "<src> ...";
        public static final String DESCRIPTION = "Dump checksum information for files that match the file pattern <src> to stdout. Note that this requires a round-trip to a datanode storing each block of the file, and thus is not efficient to run on a large number of files. The checksum of a file depends on its content, block size and the checksum algorithm and parameters used for creating the file.";

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            FileChecksum checksum = item.fs.getFileChecksum(item.path);
            if (checksum == null) {
                this.out.printf("%s\tNONE\t%n", item.toString());
            } else {
                String checksumString = StringUtils.byteToHexString(checksum.getBytes(), 0, checksum.getLength());
                this.out.printf("%s\t%s\t%s%n", item.toString(), checksum.getAlgorithmName(), checksumString);
            }
        }
    }

    public static class Text
    extends Cat {
        public static final String NAME = "text";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Takes a source file and outputs the file in text format.\nThe allowed formats are zip and TextRecordInputStream and Avro.";

        @Override
        protected InputStream getInputStream(PathData item) throws IOException {
            short leadBytes;
            FSDataInputStream i = (FSDataInputStream)super.getInputStream(item);
            try {
                leadBytes = i.readShort();
            }
            catch (EOFException e) {
                i.seek(0L);
                return i;
            }
            switch (leadBytes) {
                case 8075: {
                    i.seek(0L);
                    return new GZIPInputStream(i);
                }
                case 21317: {
                    if (i.readByte() == 81) {
                        i.close();
                        return new TextRecordInputStream(item.stat);
                    }
                }
                default: {
                    CompressionCodecFactory cf = new CompressionCodecFactory(this.getConf());
                    CompressionCodec codec = cf.getCodec(item.path);
                    if (codec == null) break;
                    i.seek(0L);
                    return codec.createInputStream(i);
                }
                case 20322: {
                    if (i.readByte() != 106) break;
                    i.close();
                    return new AvroFileInputStream(item.stat);
                }
            }
            i.seek(0L);
            return i;
        }
    }

    public static class Cat
    extends Display {
        public static final String NAME = "cat";
        public static final String USAGE = "[-ignoreCrc] <src> ...";
        public static final String DESCRIPTION = "Fetch all files that match the file pattern <src> and display their content on stdout.\n";
        private boolean verifyChecksum = true;

        @Override
        protected void processOptions(LinkedList<String> args) throws IOException {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, "ignoreCrc");
            cf.parse(args);
            this.verifyChecksum = !cf.getOpt("ignoreCrc");
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            item.fs.setVerifyChecksum(this.verifyChecksum);
            this.printToStdout(this.getInputStream(item));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printToStdout(InputStream in) throws IOException {
            try {
                IOUtils.copyBytes(in, (OutputStream)this.out, this.getConf(), false);
            }
            finally {
                in.close();
            }
        }

        protected InputStream getInputStream(PathData item) throws IOException {
            return item.fs.open(item.path);
        }
    }
}

