/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.fluss.flink.tiering.source;

import org.apache.fluss.flink.tiering.source.state.TieringSplitState;
import org.apache.fluss.lake.committer.LakeCommitter;

import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;

/** The emitter to emit {@link TableBucketWriteResult} to downstream {@link LakeCommitter}. */
public class TableBucketWriteResultEmitter<WriteResult>
        implements RecordEmitter<
                TableBucketWriteResult<WriteResult>,
                TableBucketWriteResult<WriteResult>,
                TieringSplitState> {
    @Override
    public void emitRecord(
            TableBucketWriteResult<WriteResult> writeResult,
            SourceOutput<TableBucketWriteResult<WriteResult>> sourceOutput,
            TieringSplitState splitState) {
        sourceOutput.collect(writeResult);
    }
}
