/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.hive.converter;

import java.time.Instant;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.gravitino.connector.BaseColumn;
import org.apache.gravitino.hive.converter.HiveDataTypeConverter;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.distributions.Distributions;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveTableConverter {
    public static AuditInfo getAuditInfo(Table table) {
        AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
        Optional.ofNullable(table.getOwner()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
        if (table.isSetCreateTime()) {
            auditInfoBuilder.withCreateTime(Instant.ofEpochSecond(table.getCreateTime()));
        }
        return auditInfoBuilder.build();
    }

    public static Distribution getDistribution(Table table) {
        StorageDescriptor sd = table.getSd();
        Distribution distribution = Distributions.NONE;
        if (sd.getBucketCols() != null && !sd.getBucketCols().isEmpty()) {
            distribution = Distributions.hash((int)sd.getNumBuckets(), (Expression[])((Expression[])sd.getBucketCols().stream().map(NamedReference::field).toArray(Expression[]::new)));
        }
        return distribution;
    }

    public static SortOrder[] getSortOrders(Table table) {
        SortOrder[] sortOrders = SortOrders.NONE;
        StorageDescriptor sd = table.getSd();
        if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
            sortOrders = (SortOrder[])sd.getSortCols().stream().map(f -> SortOrders.of((Expression)NamedReference.field((String)f.getCol()), (SortDirection)(f.getOrder() == 1 ? SortDirection.ASCENDING : SortDirection.DESCENDING))).toArray(SortOrder[]::new);
        }
        return sortOrders;
    }

    public static Transform[] getPartitioning(Table table) {
        return (Transform[])table.getPartitionKeys().stream().map(p -> Transforms.identity((String)p.getName())).toArray(Transform[]::new);
    }

    public static <BUILDER extends BaseColumn.BaseColumnBuilder<BUILDER, COLUMN>, COLUMN extends BaseColumn> Column[] getColumns(Table table, BUILDER columnBuilder) {
        StorageDescriptor sd = table.getSd();
        return (Column[])Stream.concat(sd.getCols().stream().map(f -> ((BaseColumn.BaseColumnBuilder)((BaseColumn.BaseColumnBuilder)((BaseColumn.BaseColumnBuilder)columnBuilder.withName(f.getName())).withType(HiveDataTypeConverter.CONVERTER.toGravitino(f.getType()))).withComment(f.getComment())).build()), table.getPartitionKeys().stream().map(p -> ((BaseColumn.BaseColumnBuilder)((BaseColumn.BaseColumnBuilder)((BaseColumn.BaseColumnBuilder)columnBuilder.withName(p.getName())).withType(HiveDataTypeConverter.CONVERTER.toGravitino(p.getType()))).withComment(p.getComment())).build())).toArray(Column[]::new);
    }
}

