/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.writer;

import java.io.IOException;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.format.FormatWriter;
import org.apache.paimon.format.orc.writer.Vectorizer;
import org.apache.paimon.fs.PositionOutputStream;
import org.apache.paimon.shade.org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.paimon.shade.org.apache.orc.Writer;
import org.apache.paimon.utils.Preconditions;

public class OrcBulkWriter
implements FormatWriter {
    private final Writer writer;
    private final Vectorizer<InternalRow> vectorizer;
    private final VectorizedRowBatch rowBatch;
    private final PositionOutputStream underlyingStream;

    public OrcBulkWriter(Vectorizer<InternalRow> vectorizer, Writer writer, PositionOutputStream underlyingStream, int batchSize) {
        this.vectorizer = (Vectorizer)Preconditions.checkNotNull(vectorizer);
        this.writer = (Writer)Preconditions.checkNotNull((Object)writer);
        this.rowBatch = vectorizer.getSchema().createRowBatch(batchSize);
        this.underlyingStream = underlyingStream;
    }

    public void addElement(InternalRow element) throws IOException {
        this.vectorizer.vectorize(element, this.rowBatch);
        if (this.rowBatch.size == this.rowBatch.getMaxSize()) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    public void flush() throws IOException {
        if (this.rowBatch.size != 0) {
            this.writer.addRowBatch(this.rowBatch);
            this.rowBatch.reset();
        }
    }

    public void finish() throws IOException {
        this.flush();
        this.writer.close();
    }

    public boolean reachTargetSize(boolean suggestedCheck, long targetSize) throws IOException {
        return this.rowBatch.size == 0 && this.length() >= targetSize;
    }

    private long length() throws IOException {
        long estimateMemory = this.writer.estimateMemory();
        long fileLength = this.underlyingStream.getPos();
        return (long)Math.ceil((double)fileLength + (double)estimateMemory * 0.2);
    }

    @VisibleForTesting
    VectorizedRowBatch getRowBatch() {
        return this.rowBatch;
    }
}

