/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.ManifestCacheFilter;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.manifest.SimpleFileEntry;
import org.apache.paimon.operation.FileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.operation.metrics.ScanMetrics;
import org.apache.paimon.operation.metrics.ScanStats;
import org.apache.paimon.partition.PartitionPredicate;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.table.source.ScanMode;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.ScanParallelExecutor;
import org.apache.paimon.utils.SnapshotManager;

public abstract class AbstractFileStoreScan
implements FileStoreScan {
    private final RowType partitionType;
    private final SnapshotManager snapshotManager;
    private final ManifestFile.Factory manifestFileFactory;
    private final ManifestList manifestList;
    private final int numOfBuckets;
    private final boolean checkNumOfBuckets;
    private final Integer scanManifestParallelism;
    private final ConcurrentMap<Long, TableSchema> tableSchemas;
    private final SchemaManager schemaManager;
    private final TableSchema schema;
    protected final ScanBucketFilter bucketKeyFilter;
    private final String branchName;
    private PartitionPredicate partitionFilter;
    private Snapshot specifiedSnapshot = null;
    private Filter<Integer> bucketFilter = null;
    private List<ManifestFileMeta> specifiedManifests = null;
    private ScanMode scanMode = ScanMode.ALL;
    private Filter<Integer> levelFilter = null;
    private Long dataFileTimeMills = null;
    private ManifestCacheFilter manifestCacheFilter = null;
    private ScanMetrics scanMetrics = null;

    public AbstractFileStoreScan(RowType partitionType, ScanBucketFilter bucketKeyFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism, String branchName) {
        this.partitionType = partitionType;
        this.bucketKeyFilter = bucketKeyFilter;
        this.snapshotManager = snapshotManager;
        this.schemaManager = schemaManager;
        this.schema = schema;
        this.manifestFileFactory = manifestFileFactory;
        this.manifestList = manifestListFactory.create();
        this.numOfBuckets = numOfBuckets;
        this.checkNumOfBuckets = checkNumOfBuckets;
        this.tableSchemas = new ConcurrentHashMap<Long, TableSchema>();
        this.scanManifestParallelism = scanManifestParallelism;
        this.branchName = branchName;
    }

    @Override
    public FileStoreScan withPartitionFilter(Predicate predicate) {
        this.partitionFilter = PartitionPredicate.fromPredicate(this.partitionType, predicate);
        return this;
    }

    @Override
    public FileStoreScan withPartitionFilter(List<BinaryRow> partitions) {
        this.partitionFilter = PartitionPredicate.fromMultiple(this.partitionType, partitions);
        return this;
    }

    @Override
    public FileStoreScan withPartitionFilter(PartitionPredicate predicate) {
        this.partitionFilter = predicate;
        return this;
    }

    @Override
    public FileStoreScan withBucket(int bucket) {
        this.bucketFilter = i -> i == bucket;
        return this;
    }

    @Override
    public FileStoreScan withBucketFilter(Filter<Integer> bucketFilter) {
        this.bucketFilter = bucketFilter;
        return this;
    }

    @Override
    public FileStoreScan withPartitionBucket(BinaryRow partition, int bucket) {
        if (this.manifestCacheFilter != null) {
            Preconditions.checkArgument((boolean)this.manifestCacheFilter.test(partition, bucket), (Object)String.format("This is a bug! The partition %s and bucket %s is filtered!", partition, bucket));
        }
        this.withPartitionFilter(Collections.singletonList(partition));
        this.withBucket(bucket);
        return this;
    }

    @Override
    public FileStoreScan withSnapshot(long snapshotId) {
        Preconditions.checkState((this.specifiedManifests == null ? 1 : 0) != 0, (Object)"Cannot set both snapshot and manifests.");
        this.specifiedSnapshot = this.snapshotManager.snapshot(snapshotId);
        return this;
    }

    @Override
    public FileStoreScan withSnapshot(Snapshot snapshot) {
        Preconditions.checkState((this.specifiedManifests == null ? 1 : 0) != 0, (Object)"Cannot set both snapshot and manifests.");
        this.specifiedSnapshot = snapshot;
        return this;
    }

    @Override
    public FileStoreScan withManifestList(List<ManifestFileMeta> manifests) {
        Preconditions.checkState((this.specifiedSnapshot == null ? 1 : 0) != 0, (Object)"Cannot set both snapshot and manifests.");
        this.specifiedManifests = manifests;
        return this;
    }

    @Override
    public FileStoreScan withKind(ScanMode scanMode) {
        this.scanMode = scanMode;
        return this;
    }

    @Override
    public FileStoreScan withLevelFilter(Filter<Integer> levelFilter) {
        this.levelFilter = levelFilter;
        return this;
    }

    @Override
    public FileStoreScan withDataFileTimeMills(long dataFileTimeMills) {
        this.dataFileTimeMills = dataFileTimeMills;
        return this;
    }

    @Override
    public FileStoreScan withManifestCacheFilter(ManifestCacheFilter manifestFilter) {
        this.manifestCacheFilter = manifestFilter;
        return this;
    }

    @Override
    public FileStoreScan withMetrics(ScanMetrics metrics) {
        this.scanMetrics = metrics;
        return this;
    }

    @Override
    public FileStoreScan.Plan plan() {
        Pair<Snapshot, List<ManifestEntry>> planResult = this.doPlan();
        final Snapshot readSnapshot = (Snapshot)planResult.getLeft();
        final List files = (List)planResult.getRight();
        return new FileStoreScan.Plan(){

            @Override
            @Nullable
            public Long watermark() {
                return readSnapshot == null ? null : readSnapshot.watermark();
            }

            @Override
            @Nullable
            public Long snapshotId() {
                return readSnapshot == null ? null : Long.valueOf(readSnapshot.id());
            }

            @Override
            public ScanMode scanMode() {
                return AbstractFileStoreScan.this.scanMode;
            }

            @Override
            public List<ManifestEntry> files() {
                return files;
            }
        };
    }

    @Override
    public List<SimpleFileEntry> readSimpleEntries() {
        List manifests = (List)this.readManifests().getRight();
        Collection mergedEntries = this.readAndMergeFileEntries(manifests, this::readSimpleEntries, Filter.alwaysTrue(), new AtomicLong());
        return new ArrayList<SimpleFileEntry>(mergedEntries);
    }

    @Override
    public List<PartitionEntry> readPartitionEntries() {
        List manifests = (List)this.readManifests().getRight();
        ConcurrentHashMap partitions = new ConcurrentHashMap();
        ForkJoinPool executePool = ScanParallelExecutor.getExecutePool(this.scanManifestParallelism);
        ArrayList<Future> tasks = new ArrayList<Future>();
        for (ManifestFileMeta manifestFileMeta : manifests) {
            Future task = executePool.submit(() -> PartitionEntry.merge(PartitionEntry.merge(this.readManifestFileMeta(manifest)), partitions));
            tasks.add(task);
        }
        for (ForkJoinTask forkJoinTask : tasks) {
            forkJoinTask.join();
        }
        return partitions.values().stream().filter(p -> p.fileCount() > 0L).collect(Collectors.toList());
    }

    private Pair<Snapshot, List<ManifestEntry>> doPlan() {
        long started = System.nanoTime();
        Pair<Snapshot, List<ManifestFileMeta>> snapshotListPair = this.readManifests();
        Snapshot snapshot = (Snapshot)snapshotListPair.getLeft();
        List manifests = (List)snapshotListPair.getRight();
        long startDataFiles = manifests.stream().mapToLong(f -> f.numAddedFiles() + f.numDeletedFiles()).sum();
        AtomicLong cntEntries = new AtomicLong(0L);
        Collection mergedEntries = this.readAndMergeFileEntries(manifests, this::readManifestFileMeta, this::filterUnmergedManifestEntry, cntEntries);
        List<Object> files = new ArrayList<ManifestEntry>();
        long skippedByPartitionAndStats = startDataFiles - cntEntries.get();
        for (ManifestEntry file2 : mergedEntries) {
            if (this.checkNumOfBuckets && file2.totalBuckets() != this.numOfBuckets) {
                String partInfo = this.partitionType.getFieldCount() > 0 ? "partition " + FileStorePathFactory.getPartitionComputer(this.partitionType, (String)CoreOptions.PARTITION_DEFAULT_NAME.defaultValue()).generatePartValues((InternalRow)file2.partition()) : "table";
                throw new RuntimeException(String.format("Try to write %s with a new bucket num %d, but the previous bucket num is %d. Please switch to batch mode, and perform INSERT OVERWRITE to rescale current data layout first.", partInfo, this.numOfBuckets, file2.totalBuckets()));
            }
            if (!this.filterMergedManifestEntry(file2)) continue;
            files.add(file2);
        }
        long afterBucketFilter = files.size();
        long skippedByBucketAndLevelFilter = mergedEntries.size() - files.size();
        files = files.stream().collect(Collectors.groupingBy(file -> Pair.of((Object)file.partition(), (Object)file.bucket()), LinkedHashMap::new, Collectors.toList())).values().stream().map(this::filterWholeBucketByStats).flatMap(Collection::stream).collect(Collectors.toList());
        long skippedByWholeBucketFiles = afterBucketFilter - (long)files.size();
        long scanDuration = (System.nanoTime() - started) / 1000000L;
        if (this.scanMetrics != null) {
            this.scanMetrics.reportScan(new ScanStats(scanDuration, manifests.size(), skippedByPartitionAndStats, skippedByBucketAndLevelFilter, skippedByWholeBucketFiles, files.size()));
        }
        return Pair.of((Object)snapshot, files);
    }

    public <T extends FileEntry> Collection<T> readAndMergeFileEntries(List<ManifestFileMeta> manifests, Function<ManifestFileMeta, List<T>> manifestReader, @Nullable Filter<T> filterUnmergedEntry, @Nullable AtomicLong readEntries) {
        Iterable entries = ScanParallelExecutor.parallelismBatchIterable(files -> {
            Stream<Object> stream = files.parallelStream().filter(this::filterManifestFileMeta).flatMap(m -> ((List)manifestReader.apply((ManifestFileMeta)m)).stream());
            if (filterUnmergedEntry != null) {
                stream = stream.filter(arg_0 -> ((Filter)filterUnmergedEntry).test(arg_0));
            }
            List entryList = stream.collect(Collectors.toList());
            if (readEntries != null) {
                readEntries.getAndAdd(entryList.size());
            }
            return entryList;
        }, manifests, this.scanManifestParallelism);
        return FileEntry.mergeEntries(entries);
    }

    private Pair<Snapshot, List<ManifestFileMeta>> readManifests() {
        List<ManifestFileMeta> manifests = this.specifiedManifests;
        Snapshot snapshot = null;
        if (manifests == null) {
            snapshot = this.specifiedSnapshot == null ? this.snapshotManager.latestSnapshot(this.branchName) : this.specifiedSnapshot;
            manifests = snapshot == null ? Collections.emptyList() : this.readManifests(snapshot);
        }
        return Pair.of(snapshot, manifests);
    }

    private List<ManifestFileMeta> readManifests(Snapshot snapshot) {
        switch (this.scanMode) {
            case ALL: {
                return snapshot.dataManifests(this.manifestList);
            }
            case DELTA: {
                return snapshot.deltaManifests(this.manifestList);
            }
            case CHANGELOG: {
                if (snapshot.version() > 1) {
                    return snapshot.changelogManifests(this.manifestList);
                }
                if (snapshot.commitKind() == Snapshot.CommitKind.APPEND) {
                    return snapshot.deltaManifests(this.manifestList);
                }
                throw new IllegalStateException(String.format("Incremental scan does not accept %s snapshot", new Object[]{snapshot.commitKind()}));
            }
        }
        throw new UnsupportedOperationException("Unknown scan kind " + this.scanMode.name());
    }

    protected TableSchema scanTableSchema(long id) {
        return this.tableSchemas.computeIfAbsent(id, key -> key.longValue() == this.schema.id() ? this.schema : this.schemaManager.schema(id));
    }

    private boolean filterManifestFileMeta(ManifestFileMeta manifest) {
        if (this.partitionFilter == null) {
            return true;
        }
        BinaryTableStats stats = manifest.partitionStats();
        return this.partitionFilter == null || this.partitionFilter.test(manifest.numAddedFiles() + manifest.numDeletedFiles(), (InternalRow)stats.minValues(), (InternalRow)stats.maxValues(), (InternalArray)stats.nullCounts());
    }

    private boolean filterUnmergedManifestEntry(ManifestEntry entry) {
        if (this.dataFileTimeMills != null && entry.file().creationTimeEpochMillis() < this.dataFileTimeMills) {
            return false;
        }
        return this.filterByStats(entry);
    }

    protected abstract boolean filterByStats(ManifestEntry var1);

    private boolean filterMergedManifestEntry(ManifestEntry entry) {
        return !(this.bucketFilter != null && !this.bucketFilter.test((Object)entry.bucket()) || !this.bucketKeyFilter.select(entry.bucket(), entry.totalBuckets()) || this.levelFilter != null && !this.levelFilter.test((Object)entry.file().level()));
    }

    protected abstract List<ManifestEntry> filterWholeBucketByStats(List<ManifestEntry> var1);

    private List<ManifestEntry> readManifestFileMeta(ManifestFileMeta manifest) {
        return this.manifestFileFactory.create().read(manifest.fileName(), manifest.fileSize(), ManifestEntry.createCacheRowFilter(this.manifestCacheFilter, this.numOfBuckets), ManifestEntry.createEntryRowFilter(this.partitionFilter, this.bucketFilter, this.numOfBuckets));
    }

    private List<SimpleFileEntry> readSimpleEntries(ManifestFileMeta manifest) {
        return this.manifestFileFactory.createSimpleFileEntryReader().read(manifest.fileName(), manifest.fileSize(), ManifestEntry.createCacheRowFilter(this.manifestCacheFilter, this.numOfBuckets), ManifestEntry.createEntryRowFilter(this.partitionFilter, this.bucketFilter, this.numOfBuckets));
    }
}

