/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.util.HashMap;
import java.util.Map;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryArray;
import org.apache.paimon.data.BinarySection;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.memory.MemorySegmentUtils;
import org.apache.paimon.types.DataType;
import org.apache.paimon.utils.Preconditions;

@Public
public final class BinaryMap
extends BinarySection
implements InternalMap {
    private static final long serialVersionUID = 1L;
    private transient BinaryArray keys = new BinaryArray();
    private transient BinaryArray values = new BinaryArray();

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public void pointTo(MemorySegment[] segments, int offset, int sizeInBytes) {
        int keyArrayBytes = MemorySegmentUtils.getInt(segments, offset);
        assert (keyArrayBytes >= 0) : "keyArraySize (" + keyArrayBytes + ") should >= 0";
        int valueArrayBytes = sizeInBytes - keyArrayBytes - 4;
        assert (valueArrayBytes >= 0) : "valueArraySize (" + valueArrayBytes + ") should >= 0";
        if (this.keys == null) {
            this.keys = new BinaryArray();
        }
        this.keys.pointTo(segments, offset + 4, keyArrayBytes);
        if (this.values == null) {
            this.values = new BinaryArray();
        }
        this.values.pointTo(segments, offset + 4 + keyArrayBytes, valueArrayBytes);
        assert (this.keys.size() == this.values.size());
        this.segments = segments;
        this.offset = offset;
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public BinaryArray keyArray() {
        return this.keys;
    }

    @Override
    public BinaryArray valueArray() {
        return this.values;
    }

    public Map<?, ?> toJavaMap(DataType keyType, DataType valueType) {
        T[] keyArray = this.keys.toObjectArray(keyType);
        T[] valueArray = this.values.toObjectArray(valueType);
        HashMap map = new HashMap();
        for (int i = 0; i < keyArray.length; ++i) {
            map.put(keyArray[i], valueArray[i]);
        }
        return map;
    }

    public BinaryMap copy() {
        return this.copy(new BinaryMap());
    }

    public BinaryMap copy(BinaryMap reuse) {
        byte[] bytes = MemorySegmentUtils.copyToBytes(this.segments, this.offset, this.sizeInBytes);
        reuse.pointTo(MemorySegment.wrap(bytes), 0, this.sizeInBytes);
        return reuse;
    }

    @Override
    public int hashCode() {
        return MemorySegmentUtils.hashByWords(this.segments, this.offset, this.sizeInBytes);
    }

    public static BinaryMap valueOf(BinaryArray key, BinaryArray value) {
        Preconditions.checkArgument(key.segments.length == 1 && value.getSegments().length == 1);
        byte[] bytes = new byte[4 + key.sizeInBytes + value.sizeInBytes];
        MemorySegment segment = MemorySegment.wrap(bytes);
        segment.putInt(0, key.sizeInBytes);
        key.getSegments()[0].copyTo(key.getOffset(), segment, 4, key.sizeInBytes);
        value.getSegments()[0].copyTo(value.getOffset(), segment, 4 + key.sizeInBytes, value.sizeInBytes);
        BinaryMap map = new BinaryMap();
        map.pointTo(segment, 0, bytes.length);
        return map;
    }
}

