/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.task;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.task.TasksWithPage;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.Task;
import org.apache.hugegraph.util.E;

public class ComputerDisAPI
extends API {
    private static final String PATH = "graphspaces/%s/graphs/%s/jobs/computerdis";
    private final String graphSpace;
    private final String graph;
    public static final String TASKS = "tasks";
    public static final String TASK_ID = "task_id";

    public ComputerDisAPI(RestClient client, String graphSpace, String graph) {
        super(client);
        this.graphSpace = graphSpace;
        this.graph = graph;
        this.path(String.format(PATH, this.graphSpace, this.graph));
    }

    @Override
    protected String type() {
        return "computerdis";
    }

    public long create(String algorithm, long worker, Map<String, Object> params) {
        LinkedHashMap<String, Object> innerParams = new LinkedHashMap<String, Object>();
        innerParams.put("algorithm", algorithm);
        innerParams.put("worker", worker);
        innerParams.put("params", params);
        RestResult result = this.client.post(this.path(), innerParams);
        Map task = (Map)result.readObject(Map.class);
        return ComputerDisAPI.parseTaskId(task);
    }

    public void delete(long id) {
        this.client.delete(this.path(), String.valueOf(id));
    }

    public Task cancel(long id) {
        RestResult result = this.client.put(this.path(), String.valueOf(id), ImmutableMap.of());
        return (Task)result.readObject(Task.class);
    }

    public List<Task> list(long limit) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return result.readList(TASKS, Task.class);
    }

    public TasksWithPage list(String page, long limit) {
        E.checkArgument((page != null ? 1 : 0) != 0, (String)"The page can not be null", (Object[])new Object[0]);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("limit", limit);
        params.put("page", page);
        RestResult result = this.client.get(this.path(), params);
        return (TasksWithPage)result.readObject(TasksWithPage.class);
    }

    public Task get(long id) {
        RestResult result = this.client.get(this.path(), String.valueOf(id));
        return (Task)result.readObject(Task.class);
    }

    public static long parseTaskId(Map<String, Object> task) {
        E.checkState((task.size() == 1 && task.containsKey(TASK_ID) ? 1 : 0) != 0, (String)"Task must be formatted to {\"%s\" : id}, but got %s", (Object[])new Object[]{TASK_ID, task});
        Object taskId = task.get(TASK_ID);
        E.checkState((boolean)(taskId instanceof Number), (String)"Task id must be number, but got '%s'", (Object[])new Object[]{taskId});
        return ((Number)taskId).longValue();
    }
}

