/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.JaccardSimilarity;
import org.apache.hugegraph.structure.traverser.SingleSourceJaccardSimilarityRequest;
import org.apache.hugegraph.util.E;

public class JaccardSimilarityAPI
extends TraversersAPI {
    private static final String JACCARD_SIMILARITY = "jaccard_similarity";

    public JaccardSimilarityAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "jaccardsimilarity";
    }

    private static JaccardSimilarity deserializeJaccardSimilarity(RestResult result) {
        if (result.content().contains("similarsMap")) {
            JaccardSimilarity jaccard = (JaccardSimilarity)result.readObject(JaccardSimilarity.class);
            E.checkState((jaccard.similarsMap() != null ? 1 : 0) != 0, (String)"The result doesn't have key '%s'", (Object[])new Object[]{JACCARD_SIMILARITY});
            return jaccard;
        }
        JaccardSimilarity jaccard = new JaccardSimilarity();
        Map map = (Map)result.readObject(Map.class);
        jaccard.setSimilarsMap(map);
        return jaccard;
    }

    public JaccardSimilarity get(Object vertexId, Object otherId, Direction direction, String label, long degree) {
        this.client.checkApiVersion("0.51", "jaccard similarity");
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        JaccardSimilarityAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        RestResult result = this.client.get(this.path(), params);
        JaccardSimilarity jaccard = JaccardSimilarityAPI.deserializeJaccardSimilarity(result);
        E.checkState((jaccard.similarsMap() != null ? 1 : 0) != 0, (String)"The result doesn't have key '%s'", (Object[])new Object[]{JACCARD_SIMILARITY});
        return jaccard;
    }

    public JaccardSimilarity post(SingleSourceJaccardSimilarityRequest request) {
        this.client.checkApiVersion("0.58", "jaccard similar");
        RestResult result = this.client.post(this.path(), request);
        return JaccardSimilarityAPI.deserializeJaccardSimilarity(result);
    }
}

