/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.PathWithMeasure;

public class RaysAPI
extends TraversersAPI {
    public RaysAPI(RestClient client, String graphSpace, String graph) {
        super(client, graphSpace, graph);
    }

    @Override
    protected String type() {
        return "rays";
    }

    public PathWithMeasure get(Object sourceId, Direction direction, String label, int depth, long degree, long capacity, long limit) {
        String source = GraphAPI.formatVertexId(sourceId, false);
        RaysAPI.checkPositive(depth, "Max depth of path");
        RaysAPI.checkDegree(degree);
        RaysAPI.checkCapacity(capacity);
        RaysAPI.checkLimit(limit);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("source", source);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_depth", depth);
        params.put("max_degree", degree);
        params.put("capacity", capacity);
        params.put("limit", limit);
        RestResult result = this.client.get(this.path(), params);
        return (PathWithMeasure)result.readObject(PathWithMeasure.class);
    }
}

