/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.space.ConfigAPI;
import org.apache.hugegraph.api.space.ServiceAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.structure.space.OLTPService;

public class ServiceManager {
    private final ServiceAPI serviceAPI;
    private final ConfigAPI configAPI;

    public ServiceManager(RestClient client, String graphSpace) {
        this.serviceAPI = new ServiceAPI(client, graphSpace);
        this.configAPI = new ConfigAPI(client, graphSpace);
    }

    public List<String> listService() {
        return this.serviceAPI.list();
    }

    public OLTPService getService(String name) {
        OLTPService service = this.serviceAPI.get(name);
        Map<String, Object> config = this.configAPI.get(name);
        service.setConfigs(config);
        return service;
    }

    public OLTPService addService(OLTPService service) {
        this.configAPI.add(service.getName(), service.getConfigs());
        OLTPService.OLTPServiceReq req = OLTPService.OLTPServiceReq.fromBase(service);
        this.serviceAPI.add(req);
        return this.getService(service.getName());
    }

    public void delService(String name, String message) {
        this.configAPI.delete(name);
        this.serviceAPI.delete(name, message);
    }

    public OLTPService updateService(OLTPService service) {
        if (service.checkIsK8s()) {
            this.configAPI.update(service.getName(), service.getConfigs());
            this.delService(service.getName(), "I'm sure to delete the service");
            return this.addService(service);
        }
        this.delService(service.getName(), "I'm sure to delete the service");
        return this.addService(service);
    }

    public void startService(String name) {
        this.serviceAPI.startService(name);
    }

    public void stopService(String name) {
        this.serviceAPI.stopService(name);
    }

    public boolean checkIfReloadK8sService(OLTPService service) {
        OLTPService curService = this.getService(service.getName());
        return service.getCount() != curService.getCount() || service.getCpuLimit() != curService.getCpuLimit() || service.getMemoryLimit() != curService.getMemoryLimit();
    }

    public List<String> configOptinList() {
        return this.configAPI.listConfigOptions();
    }
}

