/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.load;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.annotation.MergeProperty;
import org.apache.hugegraph.common.Mergeable;
import org.apache.hugegraph.entity.load.FieldMappingItem;
import org.apache.hugegraph.entity.load.NullValues;
import org.apache.hugegraph.entity.load.ValueMappingItem;

public abstract class ElementMapping
implements Mergeable {
    @MergeProperty(useNew=false)
    @JsonProperty(value="id")
    private String id;
    @MergeProperty
    @JsonProperty(value="label")
    private String label;
    @MergeProperty
    @JsonProperty(value="field_mapping")
    private List<FieldMappingItem> fieldMappings;
    @MergeProperty
    @JsonProperty(value="value_mapping")
    private List<ValueMappingItem> valueMappings;
    @MergeProperty
    @JsonProperty(value="null_values")
    private NullValues nullValues;

    public Map<String, String> fieldMappingToMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (this.fieldMappings == null) {
            return map;
        }
        for (FieldMappingItem item : this.fieldMappings) {
            map.put(item.getColumnName(), item.getMappedName());
        }
        return map;
    }

    public Map<String, Map<String, Object>> valueMappingToMap() {
        LinkedHashMap<String, Map<String, Object>> map = new LinkedHashMap<String, Map<String, Object>>();
        if (this.valueMappings == null) {
            return map;
        }
        for (ValueMappingItem item : this.valueMappings) {
            String columnName = item.getColumnName();
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            List<ValueMappingItem.ValueItem> values = item.getValues();
            for (ValueMappingItem.ValueItem valueItem : values) {
                valueMap.put(valueItem.getColumnValue(), valueItem.getMappedValue());
            }
            map.put(columnName, valueMap);
        }
        return map;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<FieldMappingItem> getFieldMappings() {
        return this.fieldMappings;
    }

    public List<ValueMappingItem> getValueMappings() {
        return this.valueMappings;
    }

    public NullValues getNullValues() {
        return this.nullValues;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="label")
    public void setLabel(String label) {
        this.label = label;
    }

    @JsonProperty(value="field_mapping")
    public void setFieldMappings(List<FieldMappingItem> fieldMappings) {
        this.fieldMappings = fieldMappings;
    }

    @JsonProperty(value="value_mapping")
    public void setValueMappings(List<ValueMappingItem> valueMappings) {
        this.valueMappings = valueMappings;
    }

    @JsonProperty(value="null_values")
    public void setNullValues(NullValues nullValues) {
        this.nullValues = nullValues;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementMapping)) {
            return false;
        }
        ElementMapping other = (ElementMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<FieldMappingItem> this$fieldMappings = this.getFieldMappings();
        List<FieldMappingItem> other$fieldMappings = other.getFieldMappings();
        if (this$fieldMappings == null ? other$fieldMappings != null : !((Object)this$fieldMappings).equals(other$fieldMappings)) {
            return false;
        }
        List<ValueMappingItem> this$valueMappings = this.getValueMappings();
        List<ValueMappingItem> other$valueMappings = other.getValueMappings();
        if (this$valueMappings == null ? other$valueMappings != null : !((Object)this$valueMappings).equals(other$valueMappings)) {
            return false;
        }
        NullValues this$nullValues = this.getNullValues();
        NullValues other$nullValues = other.getNullValues();
        return !(this$nullValues == null ? other$nullValues != null : !((Object)this$nullValues).equals(other$nullValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElementMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<FieldMappingItem> $fieldMappings = this.getFieldMappings();
        result = result * 59 + ($fieldMappings == null ? 43 : ((Object)$fieldMappings).hashCode());
        List<ValueMappingItem> $valueMappings = this.getValueMappings();
        result = result * 59 + ($valueMappings == null ? 43 : ((Object)$valueMappings).hashCode());
        NullValues $nullValues = this.getNullValues();
        result = result * 59 + ($nullValues == null ? 43 : ((Object)$nullValues).hashCode());
        return result;
    }

    public String toString() {
        return "ElementMapping(id=" + this.getId() + ", label=" + this.getLabel() + ", fieldMappings=" + this.getFieldMappings() + ", valueMappings=" + this.getValueMappings() + ", nullValues=" + this.getNullValues() + ")";
    }

    public ElementMapping() {
    }

    public ElementMapping(String id, String label, List<FieldMappingItem> fieldMappings, List<ValueMappingItem> valueMappings, NullValues nullValues) {
        this.id = id;
        this.label = label;
        this.fieldMappings = fieldMappings;
        this.valueMappings = valueMappings;
        this.nullValues = nullValues;
    }
}

