/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.query;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Vertex;

public class AdjacentQuery {
    @JsonProperty(value="vertex_id")
    private String vertexId;
    @JsonProperty(value="vertex_label")
    private String vertexLabel;
    @JsonProperty(value="edge_label")
    private String edgeLabel;
    @JsonProperty(value="direction")
    private Direction direction;
    @JsonProperty(value="conditions")
    private List<Condition> conditions;
    @JsonProperty(value="adjacent_vertices")
    private Set<String> adjacentVertices;
    @JsonProperty(value="adjacent_edges")
    private Set<String> adjacentEdges;

    public boolean retainVertex(Vertex vertex) {
        if (this.adjacentVertices == null) {
            return true;
        }
        return !this.adjacentVertices.contains(vertex.id().toString());
    }

    public boolean retainEdge(Edge edge) {
        if (this.adjacentEdges == null) {
            return true;
        }
        return !this.adjacentEdges.contains(edge.id());
    }

    public static AdjacentQueryBuilder builder() {
        return new AdjacentQueryBuilder();
    }

    public String getVertexId() {
        return this.vertexId;
    }

    public String getVertexLabel() {
        return this.vertexLabel;
    }

    public String getEdgeLabel() {
        return this.edgeLabel;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Set<String> getAdjacentVertices() {
        return this.adjacentVertices;
    }

    public Set<String> getAdjacentEdges() {
        return this.adjacentEdges;
    }

    @JsonProperty(value="vertex_id")
    public void setVertexId(String vertexId) {
        this.vertexId = vertexId;
    }

    @JsonProperty(value="vertex_label")
    public void setVertexLabel(String vertexLabel) {
        this.vertexLabel = vertexLabel;
    }

    @JsonProperty(value="edge_label")
    public void setEdgeLabel(String edgeLabel) {
        this.edgeLabel = edgeLabel;
    }

    @JsonProperty(value="direction")
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @JsonProperty(value="conditions")
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @JsonProperty(value="adjacent_vertices")
    public void setAdjacentVertices(Set<String> adjacentVertices) {
        this.adjacentVertices = adjacentVertices;
    }

    @JsonProperty(value="adjacent_edges")
    public void setAdjacentEdges(Set<String> adjacentEdges) {
        this.adjacentEdges = adjacentEdges;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdjacentQuery)) {
            return false;
        }
        AdjacentQuery other = (AdjacentQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$vertexId = this.getVertexId();
        String other$vertexId = other.getVertexId();
        if (this$vertexId == null ? other$vertexId != null : !this$vertexId.equals(other$vertexId)) {
            return false;
        }
        String this$vertexLabel = this.getVertexLabel();
        String other$vertexLabel = other.getVertexLabel();
        if (this$vertexLabel == null ? other$vertexLabel != null : !this$vertexLabel.equals(other$vertexLabel)) {
            return false;
        }
        String this$edgeLabel = this.getEdgeLabel();
        String other$edgeLabel = other.getEdgeLabel();
        if (this$edgeLabel == null ? other$edgeLabel != null : !this$edgeLabel.equals(other$edgeLabel)) {
            return false;
        }
        Direction this$direction = this.getDirection();
        Direction other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        List<Condition> this$conditions = this.getConditions();
        List<Condition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Set<String> this$adjacentVertices = this.getAdjacentVertices();
        Set<String> other$adjacentVertices = other.getAdjacentVertices();
        if (this$adjacentVertices == null ? other$adjacentVertices != null : !((Object)this$adjacentVertices).equals(other$adjacentVertices)) {
            return false;
        }
        Set<String> this$adjacentEdges = this.getAdjacentEdges();
        Set<String> other$adjacentEdges = other.getAdjacentEdges();
        return !(this$adjacentEdges == null ? other$adjacentEdges != null : !((Object)this$adjacentEdges).equals(other$adjacentEdges));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdjacentQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $vertexId = this.getVertexId();
        result = result * 59 + ($vertexId == null ? 43 : $vertexId.hashCode());
        String $vertexLabel = this.getVertexLabel();
        result = result * 59 + ($vertexLabel == null ? 43 : $vertexLabel.hashCode());
        String $edgeLabel = this.getEdgeLabel();
        result = result * 59 + ($edgeLabel == null ? 43 : $edgeLabel.hashCode());
        Direction $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        List<Condition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Set<String> $adjacentVertices = this.getAdjacentVertices();
        result = result * 59 + ($adjacentVertices == null ? 43 : ((Object)$adjacentVertices).hashCode());
        Set<String> $adjacentEdges = this.getAdjacentEdges();
        result = result * 59 + ($adjacentEdges == null ? 43 : ((Object)$adjacentEdges).hashCode());
        return result;
    }

    public String toString() {
        return "AdjacentQuery(vertexId=" + this.getVertexId() + ", vertexLabel=" + this.getVertexLabel() + ", edgeLabel=" + this.getEdgeLabel() + ", direction=" + this.getDirection() + ", conditions=" + this.getConditions() + ", adjacentVertices=" + this.getAdjacentVertices() + ", adjacentEdges=" + this.getAdjacentEdges() + ")";
    }

    public AdjacentQuery() {
    }

    public AdjacentQuery(String vertexId, String vertexLabel, String edgeLabel, Direction direction, List<Condition> conditions, Set<String> adjacentVertices, Set<String> adjacentEdges) {
        this.vertexId = vertexId;
        this.vertexLabel = vertexLabel;
        this.edgeLabel = edgeLabel;
        this.direction = direction;
        this.conditions = conditions;
        this.adjacentVertices = adjacentVertices;
        this.adjacentEdges = adjacentEdges;
    }

    public static class AdjacentQueryBuilder {
        private String vertexId;
        private String vertexLabel;
        private String edgeLabel;
        private Direction direction;
        private List<Condition> conditions;
        private Set<String> adjacentVertices;
        private Set<String> adjacentEdges;

        AdjacentQueryBuilder() {
        }

        @JsonProperty(value="vertex_id")
        public AdjacentQueryBuilder vertexId(String vertexId) {
            this.vertexId = vertexId;
            return this;
        }

        @JsonProperty(value="vertex_label")
        public AdjacentQueryBuilder vertexLabel(String vertexLabel) {
            this.vertexLabel = vertexLabel;
            return this;
        }

        @JsonProperty(value="edge_label")
        public AdjacentQueryBuilder edgeLabel(String edgeLabel) {
            this.edgeLabel = edgeLabel;
            return this;
        }

        @JsonProperty(value="direction")
        public AdjacentQueryBuilder direction(Direction direction) {
            this.direction = direction;
            return this;
        }

        @JsonProperty(value="conditions")
        public AdjacentQueryBuilder conditions(List<Condition> conditions) {
            this.conditions = conditions;
            return this;
        }

        @JsonProperty(value="adjacent_vertices")
        public AdjacentQueryBuilder adjacentVertices(Set<String> adjacentVertices) {
            this.adjacentVertices = adjacentVertices;
            return this;
        }

        @JsonProperty(value="adjacent_edges")
        public AdjacentQueryBuilder adjacentEdges(Set<String> adjacentEdges) {
            this.adjacentEdges = adjacentEdges;
            return this;
        }

        public AdjacentQuery build() {
            return new AdjacentQuery(this.vertexId, this.vertexLabel, this.edgeLabel, this.direction, this.conditions, this.adjacentVertices, this.adjacentEdges);
        }

        public String toString() {
            return "AdjacentQuery.AdjacentQueryBuilder(vertexId=" + this.vertexId + ", vertexLabel=" + this.vertexLabel + ", edgeLabel=" + this.edgeLabel + ", direction=" + this.direction + ", conditions=" + this.conditions + ", adjacentVertices=" + this.adjacentVertices + ", adjacentEdges=" + this.adjacentEdges + ")";
        }
    }

    public static class Condition {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="operator")
        private String operator;
        @JsonProperty(value="value")
        private Object value;

        public static ConditionBuilder builder() {
            return new ConditionBuilder();
        }

        public String getKey() {
            return this.key;
        }

        public String getOperator() {
            return this.operator;
        }

        public Object getValue() {
            return this.value;
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="operator")
        public void setOperator(String operator) {
            this.operator = operator;
        }

        @JsonProperty(value="value")
        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Condition)) {
                return false;
            }
            Condition other = (Condition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$operator = this.getOperator();
            String other$operator = other.getOperator();
            if (this$operator == null ? other$operator != null : !this$operator.equals(other$operator)) {
                return false;
            }
            Object this$value = this.getValue();
            Object other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Condition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $operator = this.getOperator();
            result = result * 59 + ($operator == null ? 43 : $operator.hashCode());
            Object $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AdjacentQuery.Condition(key=" + this.getKey() + ", operator=" + this.getOperator() + ", value=" + this.getValue() + ")";
        }

        public Condition() {
        }

        public Condition(String key, String operator, Object value) {
            this.key = key;
            this.operator = operator;
            this.value = value;
        }

        public static class ConditionBuilder {
            private String key;
            private String operator;
            private Object value;

            ConditionBuilder() {
            }

            @JsonProperty(value="key")
            public ConditionBuilder key(String key) {
                this.key = key;
                return this;
            }

            @JsonProperty(value="operator")
            public ConditionBuilder operator(String operator) {
                this.operator = operator;
                return this;
            }

            @JsonProperty(value="value")
            public ConditionBuilder value(Object value) {
                this.value = value;
                return this;
            }

            public Condition build() {
                return new Condition(this.key, this.operator, this.value);
            }

            public String toString() {
                return "AdjacentQuery.Condition.ConditionBuilder(key=" + this.key + ", operator=" + this.operator + ", value=" + this.value + ")";
            }
        }
    }
}

