/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.entity.schema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.entity.schema.EdgeLabelStyle;
import org.apache.hugegraph.entity.schema.Property;
import org.apache.hugegraph.entity.schema.PropertyIndex;
import org.apache.hugegraph.entity.schema.SchemaLabelEntity;
import org.apache.hugegraph.entity.schema.SchemaType;
import org.apache.hugegraph.entity.schema.Timefiable;
import org.apache.hugegraph.util.HubbleUtil;

public class EdgeLabelEntity
implements SchemaLabelEntity,
Timefiable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="source_label")
    private String sourceLabel;
    @JsonProperty(value="target_label")
    private String targetLabel;
    @JsonProperty(value="link_multi_times")
    private boolean linkMultiTimes;
    @JsonProperty(value="properties")
    private Set<Property> properties;
    @JsonProperty(value="sort_keys")
    private List<String> sortKeys;
    @JsonProperty(value="property_indexes")
    private List<PropertyIndex> propertyIndexes;
    @JsonProperty(value="open_label_index")
    private boolean openLabelIndex;
    @JsonProperty(value="style")
    private EdgeLabelStyle style;
    @JsonProperty(value="create_time")
    private Date createTime;

    @Override
    public SchemaType getSchemaType() {
        return SchemaType.EDGE_LABEL;
    }

    @JsonIgnore
    public Set<String> getLinkLabels() {
        return ImmutableSet.of((Object)this.sourceLabel, (Object)this.targetLabel);
    }

    public boolean equals(Object object) {
        if (!(object instanceof EdgeLabelEntity)) {
            return false;
        }
        EdgeLabelEntity other = (EdgeLabelEntity)object;
        return this.name.equals(other.name) && this.sourceLabel.equals(other.sourceLabel) && this.targetLabel.equals(other.targetLabel) && this.linkMultiTimes == other.linkMultiTimes && HubbleUtil.equalCollection(this.properties, other.properties) && HubbleUtil.equalCollection(this.sortKeys, other.sortKeys) && HubbleUtil.equalCollection(this.propertyIndexes, other.propertyIndexes) && this.openLabelIndex == other.openLabelIndex;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static EdgeLabelEntityBuilder builder() {
        return new EdgeLabelEntityBuilder();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public boolean isLinkMultiTimes() {
        return this.linkMultiTimes;
    }

    @Override
    public Set<Property> getProperties() {
        return this.properties;
    }

    public List<String> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public List<PropertyIndex> getPropertyIndexes() {
        return this.propertyIndexes;
    }

    @Override
    public boolean isOpenLabelIndex() {
        return this.openLabelIndex;
    }

    @Override
    public EdgeLabelStyle getStyle() {
        return this.style;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="source_label")
    public void setSourceLabel(String sourceLabel) {
        this.sourceLabel = sourceLabel;
    }

    @JsonProperty(value="target_label")
    public void setTargetLabel(String targetLabel) {
        this.targetLabel = targetLabel;
    }

    @JsonProperty(value="link_multi_times")
    public void setLinkMultiTimes(boolean linkMultiTimes) {
        this.linkMultiTimes = linkMultiTimes;
    }

    @JsonProperty(value="properties")
    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    @JsonProperty(value="sort_keys")
    public void setSortKeys(List<String> sortKeys) {
        this.sortKeys = sortKeys;
    }

    @JsonProperty(value="property_indexes")
    public void setPropertyIndexes(List<PropertyIndex> propertyIndexes) {
        this.propertyIndexes = propertyIndexes;
    }

    @JsonProperty(value="open_label_index")
    public void setOpenLabelIndex(boolean openLabelIndex) {
        this.openLabelIndex = openLabelIndex;
    }

    @JsonProperty(value="style")
    public void setStyle(EdgeLabelStyle style) {
        this.style = style;
    }

    @JsonProperty(value="create_time")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        return "EdgeLabelEntity(name=" + this.getName() + ", sourceLabel=" + this.getSourceLabel() + ", targetLabel=" + this.getTargetLabel() + ", linkMultiTimes=" + this.isLinkMultiTimes() + ", properties=" + this.getProperties() + ", sortKeys=" + this.getSortKeys() + ", propertyIndexes=" + this.getPropertyIndexes() + ", openLabelIndex=" + this.isOpenLabelIndex() + ", style=" + this.getStyle() + ", createTime=" + this.getCreateTime() + ")";
    }

    public EdgeLabelEntity() {
    }

    public EdgeLabelEntity(String name, String sourceLabel, String targetLabel, boolean linkMultiTimes, Set<Property> properties, List<String> sortKeys, List<PropertyIndex> propertyIndexes, boolean openLabelIndex, EdgeLabelStyle style, Date createTime) {
        this.name = name;
        this.sourceLabel = sourceLabel;
        this.targetLabel = targetLabel;
        this.linkMultiTimes = linkMultiTimes;
        this.properties = properties;
        this.sortKeys = sortKeys;
        this.propertyIndexes = propertyIndexes;
        this.openLabelIndex = openLabelIndex;
        this.style = style;
        this.createTime = createTime;
    }

    public static class EdgeLabelEntityBuilder {
        private String name;
        private String sourceLabel;
        private String targetLabel;
        private boolean linkMultiTimes;
        private Set<Property> properties;
        private List<String> sortKeys;
        private List<PropertyIndex> propertyIndexes;
        private boolean openLabelIndex;
        private EdgeLabelStyle style;
        private Date createTime;

        EdgeLabelEntityBuilder() {
        }

        @JsonProperty(value="name")
        public EdgeLabelEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="source_label")
        public EdgeLabelEntityBuilder sourceLabel(String sourceLabel) {
            this.sourceLabel = sourceLabel;
            return this;
        }

        @JsonProperty(value="target_label")
        public EdgeLabelEntityBuilder targetLabel(String targetLabel) {
            this.targetLabel = targetLabel;
            return this;
        }

        @JsonProperty(value="link_multi_times")
        public EdgeLabelEntityBuilder linkMultiTimes(boolean linkMultiTimes) {
            this.linkMultiTimes = linkMultiTimes;
            return this;
        }

        @JsonProperty(value="properties")
        public EdgeLabelEntityBuilder properties(Set<Property> properties) {
            this.properties = properties;
            return this;
        }

        @JsonProperty(value="sort_keys")
        public EdgeLabelEntityBuilder sortKeys(List<String> sortKeys) {
            this.sortKeys = sortKeys;
            return this;
        }

        @JsonProperty(value="property_indexes")
        public EdgeLabelEntityBuilder propertyIndexes(List<PropertyIndex> propertyIndexes) {
            this.propertyIndexes = propertyIndexes;
            return this;
        }

        @JsonProperty(value="open_label_index")
        public EdgeLabelEntityBuilder openLabelIndex(boolean openLabelIndex) {
            this.openLabelIndex = openLabelIndex;
            return this;
        }

        @JsonProperty(value="style")
        public EdgeLabelEntityBuilder style(EdgeLabelStyle style) {
            this.style = style;
            return this;
        }

        @JsonProperty(value="create_time")
        public EdgeLabelEntityBuilder createTime(Date createTime) {
            this.createTime = createTime;
            return this;
        }

        public EdgeLabelEntity build() {
            return new EdgeLabelEntity(this.name, this.sourceLabel, this.targetLabel, this.linkMultiTimes, this.properties, this.sortKeys, this.propertyIndexes, this.openLabelIndex, this.style, this.createTime);
        }

        public String toString() {
            return "EdgeLabelEntity.EdgeLabelEntityBuilder(name=" + this.name + ", sourceLabel=" + this.sourceLabel + ", targetLabel=" + this.targetLabel + ", linkMultiTimes=" + this.linkMultiTimes + ", properties=" + this.properties + ", sortKeys=" + this.sortKeys + ", propertyIndexes=" + this.propertyIndexes + ", openLabelIndex=" + this.openLabelIndex + ", style=" + this.style + ", createTime=" + this.createTime + ")";
        }
    }
}

