/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.load;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.entity.GraphConnection;
import org.apache.hugegraph.entity.enums.LoadStatus;
import org.apache.hugegraph.entity.load.FileMapping;
import org.apache.hugegraph.entity.load.FileSetting;
import org.apache.hugegraph.entity.load.LoadParameter;
import org.apache.hugegraph.entity.load.LoadTask;
import org.apache.hugegraph.entity.load.VertexMapping;
import org.apache.hugegraph.entity.schema.EdgeLabelEntity;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.handler.LoadTaskExecutor;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.LoadMapping;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.FileFormat;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.file.ListFormat;
import org.apache.hugegraph.loader.util.MappingUtil;
import org.apache.hugegraph.mapper.load.LoadTaskMapper;
import org.apache.hugegraph.service.SettingSSLService;
import org.apache.hugegraph.service.schema.EdgeLabelService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.util.Ex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoadTaskService {
    private static final Logger log = LogManager.getLogger(LoadTaskService.class);
    @Autowired
    private LoadTaskMapper mapper;
    @Autowired
    private VertexLabelService vlService;
    @Autowired
    private EdgeLabelService elService;
    @Autowired
    private LoadTaskExecutor taskExecutor;
    @Autowired
    private SettingSSLService sslService;
    @Autowired
    private HugeConfig config;
    private Map<Integer, LoadTask> runningTaskContainer = new ConcurrentHashMap<Integer, LoadTask>();

    public LoadTask get(int id) {
        return (LoadTask)this.mapper.selectById(Integer.valueOf(id));
    }

    public List<LoadTask> listAll() {
        return this.mapper.selectList(null);
    }

    public IPage<LoadTask> list(int connId, int jobId, int pageNo, int pageSize) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"conn_id", (Object)connId);
        query.eq((Object)"job_id", (Object)jobId);
        query.orderByDesc((Object)"create_time");
        Page page = new Page((long)pageNo, (long)pageSize);
        return this.mapper.selectPage((IPage)page, (Wrapper)query);
    }

    public List<LoadTask> list(int connId, List<Integer> taskIds) {
        return this.mapper.selectBatchIds(taskIds);
    }

    public int count() {
        return this.mapper.selectCount(null);
    }

    public int taskCountByJob(int jobId) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"job_id", (Object)jobId);
        return this.mapper.selectCount((Wrapper)query);
    }

    public List<LoadTask> taskListByJob(int jobId) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"job_id", (Object)jobId);
        return this.mapper.selectList((Wrapper)query);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(LoadTask entity) {
        if (this.mapper.insert(entity) != 1) {
            throw new InternalException("entity.insert.failed", entity);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(LoadTask entity) {
        if (this.mapper.updateById(entity) != 1) {
            throw new InternalException("entity.update.failed", entity);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int id) {
        this.runningTaskContainer.remove(id);
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", id);
        }
    }

    public List<LoadTask> batchTasks(int jobId) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"job_id", (Object)jobId);
        return this.mapper.selectList((Wrapper)query);
    }

    public LoadTask start(GraphConnection connection, FileMapping fileMapping) {
        this.sslService.configSSL(this.config, connection);
        LoadTask task = this.buildLoadTask(connection, fileMapping);
        this.save(task);
        this.taskExecutor.execute(task, () -> this.update(task));
        this.runningTaskContainer.put(task.getId(), task);
        return task;
    }

    public LoadTask pause(int taskId) {
        LoadTask task = this.runningTaskContainer.get(taskId);
        Ex.check(task.getStatus() == LoadStatus.RUNNING, "Can only pause the RUNNING task", new Object[0]);
        task.setStatus(LoadStatus.PAUSED);
        task.stop();
        task.lock();
        try {
            this.update(task);
            this.runningTaskContainer.remove(taskId);
        }
        finally {
            task.unlock();
        }
        return task;
    }

    public LoadTask resume(int taskId) {
        LoadTask task = this.get(taskId);
        Ex.check(task.getStatus() == LoadStatus.PAUSED || task.getStatus() == LoadStatus.FAILED, "Can only resume the PAUSED or FAILED task", new Object[0]);
        task.lock();
        try {
            task.getOptions().incrementalMode = true;
            task.setStatus(LoadStatus.RUNNING);
            this.update(task);
            this.taskExecutor.execute(task, () -> this.update(task));
            this.runningTaskContainer.put(taskId, task);
        }
        finally {
            task.unlock();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadTask stop(int taskId) {
        LoadStatus status;
        LoadTask task = this.runningTaskContainer.get(taskId);
        if (task == null) {
            task = this.get(taskId);
        }
        Ex.check((status = task.getStatus()) == LoadStatus.RUNNING || status == LoadStatus.PAUSED, "Can only stop the RUNNING or PAUSED task", new Object[0]);
        task.setStatus(LoadStatus.STOPPED);
        if (status == LoadStatus.RUNNING) {
            task.stop();
        }
        task.lock();
        try {
            this.update(task);
            this.runningTaskContainer.remove(taskId);
        }
        finally {
            task.unlock();
        }
        return task;
    }

    public LoadTask retry(int taskId) {
        LoadTask task = this.get(taskId);
        Ex.check(task.getStatus() == LoadStatus.FAILED || task.getStatus() == LoadStatus.STOPPED, "Can only retry the FAILED or STOPPED task", new Object[0]);
        task.lock();
        try {
            task.getOptions().incrementalMode = false;
            task.setStatus(LoadStatus.RUNNING);
            task.setLastDuration(0L);
            task.setCurrDuration(0L);
            this.update(task);
            this.taskExecutor.execute(task, () -> this.update(task));
            this.runningTaskContainer.put(taskId, task);
        }
        finally {
            task.unlock();
        }
        return task;
    }

    public String readLoadFailedReason(FileMapping mapping) {
        String path = mapping.getPath();
        File parentDir = FileUtils.getFile((String[])new String[]{path}).getParentFile();
        File failureDataDir = FileUtils.getFile((File)parentDir, (String[])new String[]{"mapping", "failure-data"});
        File[] errorFiles = failureDataDir.listFiles((dir, name) -> name.endsWith("error"));
        if (errorFiles == null) {
            return "For some reason, the error file was not generated. Please check the log for details";
        }
        Ex.check(errorFiles.length == 1, "There should exist only one error file, actual is %s", errorFiles.length);
        File errorFile = errorFiles[0];
        try {
            return FileUtils.readFileToString((File)errorFile);
        }
        catch (IOException e) {
            throw new InternalException("Failed to read error file %s", (Throwable)e, errorFile);
        }
    }

    public void pauseAllTasks() {
        List<LoadTask> tasks = this.listAll();
        for (LoadTask task : tasks) {
            if (!task.getStatus().inRunning()) continue;
            this.pause(task.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async
    @Scheduled(fixedDelay=1000L)
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void updateLoadTaskProgress() {
        for (LoadTask task : this.runningTaskContainer.values()) {
            if (!task.getStatus().inRunning()) continue;
            task.lock();
            try {
                if (!task.getStatus().inRunning()) continue;
                LoadContext context = task.context();
                long readLines = context.newProgress().totalInputRead();
                if (readLines == 0L) {
                    readLines = context.oldProgress().totalInputRead();
                }
                task.setFileReadLines(readLines);
                task.setCurrDuration(context.summary().totalTime());
                this.update(task);
            }
            finally {
                task.unlock();
            }
        }
    }

    private LoadTask buildLoadTask(GraphConnection connection, FileMapping fileMapping) {
        try {
            LoadOptions options = this.buildLoadOptions(connection, fileMapping);
            LoadMapping mapping = this.buildLoadMapping(connection, fileMapping);
            this.bindMappingToOptions(options, mapping, fileMapping.getPath());
            return new LoadTask(options, connection, fileMapping);
        }
        catch (Exception e) {
            Throwable rootCause = Ex.rootCause(e);
            throw new ExternalException("load.build-task.failed", rootCause, new Object[0]);
        }
    }

    private void bindMappingToOptions(LoadOptions options, LoadMapping mapping, String fileMappingPath) {
        String parentDir = new File(fileMappingPath).getParentFile().getAbsolutePath();
        String mappingPath = Paths.get(parentDir, "mapping.json").toString();
        MappingUtil.write((LoadMapping)mapping, (String)mappingPath);
        log.info("Convert mapping file successfuly, stored at {}", (Object)mappingPath);
        options.file = mappingPath;
    }

    private LoadOptions buildLoadOptions(GraphConnection connection, FileMapping fileMapping) {
        LoadOptions options = new LoadOptions();
        options.file = fileMapping.getPath();
        options.host = connection.getHost();
        options.port = connection.getPort();
        options.graph = connection.getGraph();
        options.username = connection.getUsername();
        options.token = connection.getPassword();
        options.protocol = connection.getProtocol();
        options.trustStoreFile = connection.getTrustStoreFile();
        options.trustStoreToken = connection.getTrustStorePassword();
        LoadParameter parameter = fileMapping.getLoadParameter();
        options.checkVertex = parameter.isCheckVertex();
        options.timeout = parameter.getInsertTimeout();
        options.maxReadErrors = parameter.getMaxParseErrors();
        options.maxParseErrors = parameter.getMaxParseErrors();
        options.maxInsertErrors = parameter.getMaxInsertErrors();
        options.retryTimes = parameter.getRetryTimes();
        options.retryInterval = parameter.getRetryInterval();
        options.batchInsertThreads = 4;
        options.singleInsertThreads = 4;
        options.batchSize = 100;
        return options;
    }

    private LoadMapping buildLoadMapping(GraphConnection connection, FileMapping fileMapping) {
        FileSource source = this.buildFileSource(fileMapping);
        List<org.apache.hugegraph.loader.mapping.VertexMapping> vMappings = this.buildVertexMappings(connection, fileMapping);
        List<EdgeMapping> eMappings = this.buildEdgeMappings(connection, fileMapping);
        InputStruct inputStruct = new InputStruct(vMappings, eMappings);
        inputStruct.id("1");
        inputStruct.input((InputSource)source);
        return new LoadMapping((List)ImmutableList.of((Object)inputStruct));
    }

    private FileSource buildFileSource(FileMapping fileMapping) {
        FileSource source = new FileSource();
        source.path(fileMapping.getPath());
        FileSetting setting = fileMapping.getFileSetting();
        Ex.check(setting.getColumnNames() != null, "Must do file setting firstly", new Object[0]);
        source.header(setting.getColumnNames().toArray(new String[0]));
        source.format(FileFormat.valueOf((String)setting.getFormat()));
        source.delimiter(setting.getDelimiter());
        source.charset(setting.getCharset());
        source.dateFormat(setting.getDateFormat());
        source.timeZone(setting.getTimeZone());
        source.skippedLine().regex(setting.getSkippedLine());
        source.listFormat(new ListFormat());
        org.apache.hugegraph.entity.load.ListFormat listFormat = setting.getListFormat();
        source.listFormat().startSymbol(listFormat.getStartSymbol());
        source.listFormat().endSymbol(listFormat.getEndSymbol());
        source.listFormat().elemDelimiter(listFormat.getElemDelimiter());
        return source;
    }

    private List<org.apache.hugegraph.loader.mapping.VertexMapping> buildVertexMappings(GraphConnection connection, FileMapping fileMapping) {
        int connId = connection.getId();
        ArrayList<org.apache.hugegraph.loader.mapping.VertexMapping> vMappings = new ArrayList<org.apache.hugegraph.loader.mapping.VertexMapping>();
        for (VertexMapping mapping : fileMapping.getVertexMappings()) {
            org.apache.hugegraph.loader.mapping.VertexMapping vMapping;
            VertexLabelEntity vl = this.vlService.get(mapping.getLabel(), connId);
            List<String> idFields = mapping.getIdFields();
            Map<String, String> fieldMappings = mapping.fieldMappingToMap();
            if (vl.getIdStrategy().isCustomize()) {
                Ex.check(idFields.size() == 1, "When the ID strategy is CUSTOMIZED, you must select a column in the file as the id", new Object[0]);
                vMapping = new org.apache.hugegraph.loader.mapping.VertexMapping(idFields.get(0), true);
            } else {
                assert (vl.getIdStrategy().isPrimaryKey());
                List<String> primaryKeys = vl.getPrimaryKeys();
                Ex.check(idFields.size() >= 1 && idFields.size() == primaryKeys.size(), "When the ID strategy is PRIMARY_KEY, you must select at least one column in the file as the primary keys", new Object[0]);
                boolean unfold = idFields.size() == 1;
                vMapping = new org.apache.hugegraph.loader.mapping.VertexMapping(null, unfold);
                for (int i = 0; i < primaryKeys.size(); ++i) {
                    fieldMappings.put(idFields.get(i), primaryKeys.get(i));
                }
            }
            vMapping.label(mapping.getLabel());
            vMapping.mappingFields(fieldMappings);
            vMapping.mappingValues(mapping.valueMappingToMap());
            vMapping.selectedFields().addAll(idFields);
            vMapping.selectedFields().addAll(fieldMappings.keySet());
            HashSet<Object> nullValues = new HashSet<Object>();
            nullValues.addAll(mapping.getNullValues().getChecked());
            nullValues.addAll(mapping.getNullValues().getCustomized());
            vMapping.nullValues(nullValues);
            vMappings.add(vMapping);
        }
        return vMappings;
    }

    private List<EdgeMapping> buildEdgeMappings(GraphConnection connection, FileMapping fileMapping) {
        int connId = connection.getId();
        ArrayList<EdgeMapping> eMappings = new ArrayList<EdgeMapping>();
        for (org.apache.hugegraph.entity.load.EdgeMapping mapping : fileMapping.getEdgeMappings()) {
            List<String> sourceFields = mapping.getSourceFields();
            List<String> targetFields = mapping.getTargetFields();
            EdgeLabelEntity el = this.elService.get(mapping.getLabel(), connId);
            VertexLabelEntity svl = this.vlService.get(el.getSourceLabel(), connId);
            VertexLabelEntity tvl = this.vlService.get(el.getTargetLabel(), connId);
            Map<String, String> fieldMappings = mapping.fieldMappingToMap();
            boolean unfoldSource = true;
            if (svl.getIdStrategy().isPrimaryKey()) {
                List<String> primaryKeys = svl.getPrimaryKeys();
                Ex.check(sourceFields.size() >= 1 && sourceFields.size() == primaryKeys.size(), "When the source vertex ID strategy is CUSTOMIZED, you must select at least one column in the file as the id", new Object[0]);
                for (int i = 0; i < primaryKeys.size(); ++i) {
                    fieldMappings.put(sourceFields.get(i), primaryKeys.get(i));
                }
                if (sourceFields.size() > 1) {
                    unfoldSource = false;
                }
            }
            boolean unfoldTarget = true;
            if (tvl.getIdStrategy().isPrimaryKey()) {
                List<String> primaryKeys = tvl.getPrimaryKeys();
                Ex.check(targetFields.size() >= 1 && targetFields.size() == primaryKeys.size(), "When the target vertex ID strategy is CUSTOMIZED, you must select at least one column in the file as the id", new Object[0]);
                for (int i = 0; i < primaryKeys.size(); ++i) {
                    fieldMappings.put(targetFields.get(i), primaryKeys.get(i));
                }
                if (targetFields.size() > 1) {
                    unfoldTarget = false;
                }
            }
            EdgeMapping eMapping = new EdgeMapping(sourceFields, unfoldSource, targetFields, unfoldTarget);
            eMapping.label(mapping.getLabel());
            eMapping.mappingFields(fieldMappings);
            eMapping.mappingValues(mapping.valueMappingToMap());
            eMapping.selectedFields().addAll(sourceFields);
            eMapping.selectedFields().addAll(targetFields);
            eMapping.selectedFields().addAll(fieldMappings.keySet());
            HashSet<Object> nullValues = new HashSet<Object>();
            nullValues.addAll(mapping.getNullValues().getChecked());
            nullValues.addAll(mapping.getNullValues().getCustomized());
            eMapping.nullValues(nullValues);
            eMappings.add(eMapping);
        }
        return eMappings;
    }
}

