/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.api.gremlin.GremlinRequest;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.entity.query.AdjacentQuery;
import org.apache.hugegraph.entity.query.GraphView;
import org.apache.hugegraph.entity.query.GremlinQuery;
import org.apache.hugegraph.entity.query.GremlinResult;
import org.apache.hugegraph.entity.query.JsonView;
import org.apache.hugegraph.entity.query.TableView;
import org.apache.hugegraph.entity.query.TypedResult;
import org.apache.hugegraph.entity.schema.VertexLabelEntity;
import org.apache.hugegraph.exception.ExternalException;
import org.apache.hugegraph.exception.IllegalGremlinException;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.options.HubbleOptions;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.service.HugeClientPoolService;
import org.apache.hugegraph.service.schema.VertexLabelService;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.constant.IdStrategy;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.graph.Path;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.gremlin.Result;
import org.apache.hugegraph.structure.gremlin.ResultSet;
import org.apache.hugegraph.util.Ex;
import org.apache.hugegraph.util.GremlinUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GremlinQueryService {
    private static final Logger log = LogManager.getLogger(GremlinQueryService.class);
    private static final Set<String> ILLEGAL_GREMLIN_EXCEPTIONS = ImmutableSet.of((Object)"groovy.lang.MissingPropertyException", (Object)"groovy.lang.MissingMethodException", (Object)"groovy.lang.MissingFieldException", (Object)"groovy.lang.MissingClassException", (Object)"groovy.lang.IncorrectClosureArgumentsException", (Object)"org.codehaus.groovy.control.CompilationFailedException", (Object[])new String[]{"org.codehaus.groovy.control.MultipleCompilationErrorsException", "org.codehaus.groovy.runtime.metaclass.MethodSelectionException"});
    private static final String TIMEOUT_EXCEPTION = "java.net.SocketTimeoutException";
    private static final String CONN_REFUSED_MSG = "Connection refused";
    @Autowired
    private HugeConfig config;
    @Autowired
    private HugeClientPoolService poolService;
    @Autowired
    private VertexLabelService vlService;

    private HugeClient getClient(int connId) {
        return this.poolService.getOrCreate(connId);
    }

    public GremlinResult executeQuery(int connId, GremlinQuery query) {
        HugeClient client = this.getClient(connId);
        log.debug("The original gremlin ==> {}", (Object)query.getContent());
        String gremlin = this.optimize(query.getContent());
        log.debug("The optimized gremlin ==> {}", (Object)gremlin);
        ResultSet resultSet = this.executeGremlin(gremlin, client);
        TypedResult typedResult = this.parseResults(resultSet);
        JsonView jsonView = new JsonView(typedResult.getData());
        TableView tableView = this.buildTableView(typedResult);
        GraphView graphView = this.buildGraphView(typedResult, client);
        return GremlinResult.builder().type(typedResult.getType()).jsonView(jsonView).tableView(tableView).graphView(graphView).build();
    }

    public Long executeAsyncTask(int connId, GremlinQuery query) {
        HugeClient client = this.getClient(connId);
        log.debug("The async gremlin ==> {}", (Object)query.getContent());
        GremlinRequest request = new GremlinRequest(query.getContent());
        return client.gremlin().executeAsTask(request);
    }

    public GremlinResult expandVertex(int connId, AdjacentQuery query) {
        HugeClient client = this.getClient(connId);
        String gremlin = this.buildGremlinQuery(connId, query);
        log.debug("expand vertex gremlin ==> {}", (Object)gremlin);
        ResultSet resultSet = this.executeGremlin(gremlin, client);
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(resultSet.size());
        ArrayList<Edge> edges = new ArrayList<Edge>(resultSet.size());
        Iterator iter = resultSet.iterator();
        while (iter.hasNext()) {
            Path path = ((Result)iter.next()).getPath();
            List objects = path.objects();
            assert (objects.size() == 3);
            Edge edge = (Edge)objects.get(1);
            Vertex vertex = (Vertex)objects.get(2);
            if (query.retainEdge(edge)) {
                edges.add(edge);
            }
            if (!query.retainVertex(vertex)) continue;
            vertices.add(vertex);
        }
        GraphView graphView = new GraphView(vertices, edges);
        return GremlinResult.builder().type(GremlinResult.Type.PATH).graphView(graphView).build();
    }

    private String optimize(String content) {
        int limit = (Integer)this.config.get(HubbleOptions.GREMLIN_SUFFIX_LIMIT);
        String[] originalParts = StringUtils.split((String)content, (String)";");
        Object[] optimizeParts = new String[originalParts.length];
        for (int i = 0; i < originalParts.length; ++i) {
            String part = originalParts[i];
            optimizeParts[i] = GremlinUtil.optimizeLimit(part, limit);
        }
        return StringUtils.join((Object[])optimizeParts, (String)";");
    }

    private ResultSet executeGremlin(String gremlin, HugeClient client) {
        try {
            return client.gremlin().gremlin(gremlin).execute();
        }
        catch (ServerException e) {
            String exception = e.exception();
            log.error("Gremlin execute failed: {}", (Object)exception);
            if (ILLEGAL_GREMLIN_EXCEPTIONS.contains(exception)) {
                throw new IllegalGremlinException("gremlin.illegal-statemnt", (Throwable)e, e.message());
            }
            throw new ExternalException("gremlin.execute.failed", (Throwable)e, e.message());
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                String message = cause.getMessage();
                if (message != null && message.startsWith(TIMEOUT_EXCEPTION)) {
                    throw new InternalException("gremlin.execute.timeout", (Throwable)e, message);
                }
                if (message != null && message.contains(CONN_REFUSED_MSG)) {
                    throw new InternalException("gremlin.connection.refused", (Throwable)e, message);
                }
            }
            throw e;
        }
        catch (Exception e) {
            log.error("Gremlin execute failed", (Throwable)e);
            throw new ExternalException("gremlin.execute.failed", (Throwable)e, e.getMessage());
        }
    }

    private TypedResult parseResults(ResultSet resultSet) {
        if (resultSet == null) {
            return new TypedResult(GremlinResult.Type.EMPTY, null);
        }
        Iterator iter = resultSet.iterator();
        if (!iter.hasNext()) {
            return new TypedResult(GremlinResult.Type.EMPTY, null);
        }
        HashMap<GremlinResult.Type, Integer> typeVotes = new HashMap<GremlinResult.Type, Integer>();
        ArrayList<Object> typedData = new ArrayList<Object>(resultSet.size());
        while (iter.hasNext()) {
            Result result = (Result)iter.next();
            if (result == null) continue;
            Object object = result.getObject();
            GremlinResult.Type type = object instanceof Vertex ? GremlinResult.Type.VERTEX : (object instanceof Edge ? GremlinResult.Type.EDGE : (object instanceof Path ? GremlinResult.Type.PATH : GremlinResult.Type.GENERAL));
            typeVotes.compute(type, (k, v) -> v == null ? 1 : v + 1);
            typedData.add(object);
        }
        GremlinResult.Type type = typeVotes.isEmpty() ? GremlinResult.Type.EMPTY : (GremlinResult.Type)((Object)Collections.max(typeVotes.entrySet(), Comparator.comparingInt(Map.Entry::getValue)).getKey());
        return new TypedResult(type, typedData);
    }

    private TableView buildTableView(TypedResult typedResult) {
        List<Object> data = typedResult.getData();
        if (CollectionUtils.isEmpty(data)) {
            return TableView.EMPTY;
        }
        switch (typedResult.getType()) {
            case EMPTY: {
                return TableView.EMPTY;
            }
            case GENERAL: {
                ArrayList<Object> results = new ArrayList<Object>(data.size());
                data.forEach(object -> results.add(ImmutableMap.of((Object)"result", (Object)object)));
                return new TableView(TableView.GENERAL_HEADER, results);
            }
            case VERTEX: {
                ArrayList<Object> vertices = new ArrayList<Object>(data.size());
                data.forEach(object -> {
                    if (object instanceof Vertex) {
                        vertices.add(object);
                    }
                });
                return new TableView(TableView.VERTEX_HEADER, vertices);
            }
            case EDGE: {
                ArrayList<Object> edges = new ArrayList<Object>(data.size());
                data.forEach(object -> {
                    if (object instanceof Edge) {
                        edges.add(object);
                    }
                });
                return new TableView(TableView.EDGE_HEADER, edges);
            }
            case PATH: {
                ArrayList<Object> paths = new ArrayList<Object>(data.size());
                data.forEach(object -> {
                    if (object instanceof Path) {
                        Path path = (Path)object;
                        ArrayList ids = new ArrayList();
                        path.objects().forEach(element -> {
                            if (element instanceof Vertex) {
                                ids.add(((Vertex)element).id());
                            } else if (element instanceof Edge) {
                                ids.add(((Edge)element).id());
                            } else {
                                ids.add(element);
                            }
                        });
                        paths.add(ImmutableMap.of((Object)"path", ids));
                    }
                });
                return new TableView(TableView.PATH_HEADER, paths);
            }
        }
        throw new AssertionError((Object)String.format("Unknown result type '%s'", new Object[]{typedResult.getType()}));
    }

    private GraphView buildGraphView(TypedResult result, HugeClient client) {
        List<Object> data = result.getData();
        if (!result.getType().isGraph() || CollectionUtils.isEmpty(data)) {
            return GraphView.EMPTY;
        }
        Map<Object, Vertex> vertices = new HashMap<Object, Vertex>();
        Map<String, Edge> edges = new HashMap<String, Edge>();
        for (Object object : data) {
            if (object instanceof Vertex) {
                Vertex vertex = (Vertex)object;
                vertices.put(vertex.id(), vertex);
                continue;
            }
            if (object instanceof Edge) {
                Edge edge = (Edge)object;
                edges.put(edge.id(), edge);
                continue;
            }
            if (!(object instanceof Path)) continue;
            List elements = ((Path)object).objects();
            for (Object element : elements) {
                if (element instanceof Vertex) {
                    Vertex vertex = (Vertex)element;
                    vertices.put(vertex.id(), vertex);
                    continue;
                }
                if (element instanceof Edge) {
                    Edge edge = (Edge)element;
                    edges.put(edge.id(), edge);
                    continue;
                }
                return GraphView.EMPTY;
            }
        }
        if (!edges.isEmpty()) {
            if (vertices.isEmpty()) {
                vertices = this.verticesOfEdge(result, edges, client);
            } else {
                vertices.putAll(this.verticesOfEdge(result, edges, client));
            }
        } else if (!vertices.isEmpty()) {
            edges = this.edgesOfVertex(result, vertices, client);
        }
        if (!edges.isEmpty()) {
            Ex.check(!vertices.isEmpty(), "gremlin.edges.linked-vertex.not-exist", new Object[0]);
        }
        return new GraphView(vertices.values(), edges.values());
    }

    private String buildGremlinQuery(int connId, AdjacentQuery query) {
        int degreeLimit = (Integer)this.config.get(HubbleOptions.GREMLIN_VERTEX_DEGREE_LIMIT);
        Object id = this.getRealVertexId(connId, query);
        StringBuilder sb = new StringBuilder("g.V(");
        sb.append(GremlinUtil.escapeId(id)).append(")");
        String direction = query.getDirection() != null ? query.getDirection().name() : Direction.BOTH.name();
        sb.append(".toE(").append(direction);
        if (query.getEdgeLabel() != null) {
            sb.append(", '").append(query.getEdgeLabel()).append("')");
        } else {
            sb.append(")");
        }
        if (query.getConditions() != null) {
            for (AdjacentQuery.Condition condition : query.getConditions()) {
                sb.append(".has('").append(condition.getKey()).append("', ");
                sb.append(condition.getOperator()).append("(").append(GremlinUtil.escape(condition.getValue())).append(")");
                sb.append(")");
            }
        }
        sb.append(".limit(").append(degreeLimit).append(")");
        sb.append(".otherV().path()");
        return sb.toString();
    }

    private Object getRealVertexId(int connId, AdjacentQuery query) {
        VertexLabelEntity entity = this.vlService.get(query.getVertexLabel(), connId);
        IdStrategy idStrategy = entity.getIdStrategy();
        String rawVertexId = query.getVertexId();
        try {
            if (idStrategy == IdStrategy.AUTOMATIC || idStrategy == IdStrategy.CUSTOMIZE_NUMBER) {
                return Long.parseLong(rawVertexId);
            }
            if (idStrategy == IdStrategy.CUSTOMIZE_UUID) {
                return UUID.fromString(rawVertexId);
            }
        }
        catch (Exception e) {
            throw new ExternalException("gremlin.convert-vertex-id.failed", (Throwable)e, rawVertexId, idStrategy);
        }
        assert (idStrategy == IdStrategy.PRIMARY_KEY || idStrategy == IdStrategy.CUSTOMIZE_STRING);
        return rawVertexId;
    }

    private Map<String, Edge> edgesOfVertex(TypedResult result, Map<Object, Vertex> vertices, HugeClient client) {
        HugeConfig config = this.config;
        int batchSize = (Integer)config.get(HubbleOptions.GREMLIN_BATCH_QUERY_IDS);
        int edgeLimit = (Integer)config.get(HubbleOptions.GREMLIN_EDGES_TOTAL_LIMIT);
        int degreeLimit = (Integer)config.get(HubbleOptions.GREMLIN_VERTEX_DEGREE_LIMIT);
        Set<Object> vertexIds = vertices.keySet();
        HashMap<String, Edge> edges = new HashMap<String, Edge>(vertexIds.size());
        Iterables.partition(vertexIds, (int)batchSize).forEach(batch -> {
            List escapedIds = batch.stream().map(GremlinUtil::escapeId).collect(Collectors.toList());
            String ids = StringUtils.join(escapedIds, (String)",");
            String gremlin = result.getType().isPath() ? String.format("g.V(%s).bothE().local(limit(%s)).dedup()", ids, degreeLimit) : String.format("g.V(%s).bothE().dedup().limit(%s)", ids, edgeLimit);
            ResultSet resultSet = client.gremlin().gremlin(gremlin).execute();
            HashMap<Object, Integer> degrees = new HashMap<Object, Integer>(resultSet.size());
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                int deg;
                Edge edge = ((Result)iter.next()).getEdge();
                Object source = edge.sourceId();
                Object target = edge.targetId();
                if (!vertexIds.contains(source) || !vertexIds.contains(target)) continue;
                edges.put(edge.id(), edge);
                if (edges.size() < edgeLimit && (deg = degrees.compute(source, (k, v) -> v == null ? 1 : v + 1).intValue()) < degreeLimit && (deg = degrees.compute(target, (k, v) -> v == null ? 1 : v + 1).intValue()) < degreeLimit) continue;
                break;
            }
        });
        return edges;
    }

    private Map<Object, Vertex> verticesOfEdge(TypedResult result, Map<String, Edge> edges, HugeClient client) {
        int batchSize = (Integer)this.config.get(HubbleOptions.GREMLIN_BATCH_QUERY_IDS);
        HashSet vertexIds = new HashSet(edges.size() * 2);
        edges.values().forEach(edge -> {
            vertexIds.add(edge.sourceId());
            vertexIds.add(edge.targetId());
        });
        HashMap<Object, Vertex> vertices = new HashMap<Object, Vertex>(vertexIds.size());
        Iterables.partition(vertexIds, (int)batchSize).forEach(batch -> {
            List escapedIds = batch.stream().map(GremlinUtil::escapeId).collect(Collectors.toList());
            String ids = StringUtils.join(escapedIds, (String)",");
            String gremlin = String.format("g.V(%s)", ids);
            ResultSet resultSet = client.gremlin().gremlin(gremlin).execute();
            Iterator iter = resultSet.iterator();
            while (iter.hasNext()) {
                Vertex vertex = ((Result)iter.next()).getVertex();
                vertices.put(vertex.id(), vertex);
            }
        });
        return vertices;
    }
}

