/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RemovePeerProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(RemovePeerProcedure.class);
    private ReplicationPeerConfig peerConfig;

    public RemovePeerProcedure() {
    }

    public RemovePeerProcedure(String peerId) {
        super(peerId);
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.REMOVE;
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preRemoveReplicationPeer(this.peerId);
        }
        this.peerConfig = env.getReplicationPeerManager().preRemovePeer(this.peerId);
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().removePeer(this.peerId);
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
        env.getReplicationPeerManager().removeAllQueuesAndHFileRefs(this.peerId);
        if (this.peerConfig.isSerial()) {
            env.getReplicationPeerManager().removeAllLastPushedSeqIds(this.peerId);
        }
        LOG.info("Successfully removed peer {}", (Object)this.peerId);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRemoveReplicationPeer(this.peerId);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.RemovePeerStateData.Builder builder = MasterProcedureProtos.RemovePeerStateData.newBuilder();
        if (this.peerConfig != null) {
            builder.setPeerConfig(ReplicationPeerConfigUtil.convert((ReplicationPeerConfig)this.peerConfig));
        }
        serializer.serialize((Message)builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.RemovePeerStateData data = (MasterProcedureProtos.RemovePeerStateData)serializer.deserialize(MasterProcedureProtos.RemovePeerStateData.class);
        if (data.hasPeerConfig()) {
            this.peerConfig = ReplicationPeerConfigUtil.convert((ReplicationProtos.ReplicationPeer)data.getPeerConfig());
        }
    }
}

