/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.date;

import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class SafeDateFormat {
    private static final int ONE_HOUR_MS = 3600000;
    private final String pattern;
    private DateTimeFormatter formatter;

    public SafeDateFormat(String pattern) {
        this.pattern = pattern;
        this.formatter = DateTimeFormat.forPattern((String)pattern);
    }

    public synchronized void setTimeZone(String zoneId) {
        int hoursOffset = TimeZone.getTimeZone(zoneId).getRawOffset() / 3600000;
        DateTimeZone zone = DateTimeZone.forOffsetHours((int)hoursOffset);
        this.formatter = this.formatter.withZone(zone);
    }

    public TimeZone getTimeZone() {
        return this.formatter.getZone().toTimeZone();
    }

    public Date parse(String source) {
        return this.formatter.parseDateTime(source).toDate();
    }

    public String format(Date date) {
        return this.formatter.print(date.getTime());
    }

    public Object toPattern() {
        return this.pattern;
    }
}

