/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.base;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hugegraph.base.Directory;
import org.apache.hugegraph.exception.ToolsException;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.E;

public class HdfsDirectory
extends Directory {
    public static final String HDFS_FS_DEFAULT_NAME = "fs.default.name";
    private final Map<String, String> conf;

    public HdfsDirectory(String directory, Map<String, String> conf) {
        super(directory);
        this.conf = conf;
    }

    private FileSystem fileSystem() {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : this.conf.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
        try {
            return FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            throw new ClientException("Failed to access HDFS with configuration %s", new Object[]{this.conf, e});
        }
    }

    @Override
    public List<String> files() {
        FileStatus[] statuses;
        FileSystem fs = this.fileSystem();
        try {
            statuses = fs.listStatus(new Path(this.directory()));
        }
        catch (IOException e) {
            throw new ToolsException("Failed to get file list in directory '%s'", (Throwable)e, this.directory());
        }
        ArrayList<String> files = new ArrayList<String>();
        for (FileStatus status : statuses) {
            if (!status.isFile()) continue;
            files.add(status.getPath().getName());
        }
        return files;
    }

    @Override
    public void ensureDirectoryExist(boolean create) {
        FileSystem fs = this.fileSystem();
        Path path = new Path(this.directory());
        try {
            if (fs.exists(path)) {
                E.checkState((boolean)fs.getFileStatus(path).isDirectory(), (String)"Can't use directory '%s' because a file with same name exists.", (Object[])new Object[]{this.directory()});
            } else if (create) {
                E.checkState((boolean)fs.mkdirs(path), (String)"The directory does not exist and created failed: '%s'", (Object[])new Object[]{path.toString()});
            } else {
                E.checkState((boolean)false, (String)"The directory does not exist: '%s'", (Object[])new Object[]{path.toString()});
            }
        }
        catch (IOException e) {
            throw new ToolsException("Invalid directory '%s'", (Throwable)e, this.directory());
        }
    }

    @Override
    public void removeDirectory() {
        FileSystem fs = this.fileSystem();
        Path path = new Path(this.directory());
        try {
            E.checkState((fs.exists(path) && fs.getFileStatus(path).isDirectory() ? 1 : 0) != 0, (String)"The directory does not exist: '%s'", (Object[])new Object[]{this.directory()});
            fs.delete(path, true);
        }
        catch (IOException e) {
            throw new ToolsException("Failed to delete directory '%s'", path);
        }
    }

    @Override
    public String suffix(boolean compress) {
        return compress ? ".zip" : "";
    }

    @Override
    public InputStream inputStream(String file) {
        ZipInputStream zis;
        String path = this.path(file);
        FileSystem fs = this.fileSystem();
        FSDataInputStream is = null;
        Path source = new Path(path);
        try {
            is = fs.open(source);
            zis = new ZipInputStream((InputStream)is);
            E.checkState((zis.getNextEntry() != null ? 1 : 0) != 0, (String)"Invalid zip file '%s'", (Object[])new Object[]{file});
        }
        catch (IOException e) {
            HdfsDirectory.closeAndIgnoreException((Closeable)is);
            throw new ClientException("Failed to read from %s", (Throwable)e, new Object[]{path});
        }
        return zis;
    }

    @Override
    public OutputStream outputStream(String file, boolean compress, boolean override) {
        String path = this.path(file + this.suffix(compress));
        FileSystem fs = this.fileSystem();
        FSDataOutputStream os = null;
        ZipOutputStream zos = null;
        Path dest = new Path(path);
        try {
            os = override ? fs.create(dest, true) : fs.append(dest);
            if (!compress) {
                return os;
            }
            zos = new ZipOutputStream((OutputStream)os);
            ZipEntry entry = new ZipEntry(file);
            zos.putNextEntry(entry);
        }
        catch (IOException e) {
            HdfsDirectory.closeAndIgnoreException(zos);
            HdfsDirectory.closeAndIgnoreException((Closeable)os);
            throw new ClientException("Failed to write to %s", (Throwable)e, new Object[]{path});
        }
        return zos;
    }

    public static HdfsDirectory constructDir(String directory, String graph, Map<String, String> hdfsConf) {
        String hdfsFs = hdfsConf.get(HDFS_FS_DEFAULT_NAME);
        E.checkArgument((hdfsFs != null && !hdfsFs.isEmpty() ? 1 : 0) != 0, (String)"'%s' can not be null or empty when try to backup to HDFS", (Object[])new Object[]{HDFS_FS_DEFAULT_NAME});
        if (directory == null || directory.isEmpty()) {
            directory = hdfsFs.endsWith("/") ? hdfsFs + graph : hdfsFs + "/" + graph;
        }
        return new HdfsDirectory(directory, hdfsConf);
    }

    private String path(String file) {
        if (this.directory().endsWith("/")) {
            return this.directory() + file;
        }
        return this.directory() + "/" + file;
    }
}

