/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.stats.OperatorStats;

public final class RuntimeStatsMap {
    @JsonProperty
    private List<OpTreeSignature> sigs;
    @JsonProperty
    private List<OperatorStats> ss;

    RuntimeStatsMap() {
    }

    public RuntimeStatsMap(Map<OpTreeSignature, OperatorStats> input) {
        this.sigs = new ArrayList<OpTreeSignature>(input.size());
        this.ss = new ArrayList<OperatorStats>(input.size());
        for (Map.Entry<OpTreeSignature, OperatorStats> ent : input.entrySet()) {
            this.sigs.add(ent.getKey());
            this.ss.add(ent.getValue());
        }
    }

    public Map<OpTreeSignature, OperatorStats> toMap() throws IOException {
        if (this.sigs.size() != this.ss.size()) {
            throw new IOException("constraint validation");
        }
        HashMap<OpTreeSignature, OperatorStats> ret = new HashMap<OpTreeSignature, OperatorStats>();
        for (int i = 0; i < this.sigs.size(); ++i) {
            ret.put(this.sigs.get(i), this.ss.get(i));
        }
        return ret;
    }

    public int hashCode() {
        return Objects.hashCode(this.sigs, this.ss);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != RuntimeStatsMap.class) {
            return false;
        }
        RuntimeStatsMap o = (RuntimeStatsMap)obj;
        return Objects.equal(this.sigs, o.sigs) && Objects.equal(this.ss, o.ss);
    }
}

