/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;

@Explain(displayName="Create/Drop Trigger to pool mappings", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class CreateOrDropTriggerToPoolMappingDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 383046258694558029L;
    private String resourcePlanName;
    private String triggerName;
    private String poolPath;
    private boolean isUnmanagedPool;
    private boolean drop;

    public CreateOrDropTriggerToPoolMappingDesc() {
    }

    public CreateOrDropTriggerToPoolMappingDesc(String resourcePlanName, String triggerName, String poolPath, boolean drop, boolean isUnmanagedPool) {
        this.resourcePlanName = resourcePlanName;
        this.triggerName = triggerName;
        this.poolPath = poolPath;
        this.isUnmanagedPool = isUnmanagedPool;
        this.drop = drop;
    }

    @Explain(displayName="resourcePlanName", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getResourcePlanName() {
        return this.resourcePlanName;
    }

    public void setResourcePlanName(String resourcePlanName) {
        this.resourcePlanName = resourcePlanName;
    }

    @Explain(displayName="Trigger name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    @Explain(displayName="Pool path", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getPoolPathForExplain() {
        return this.isUnmanagedPool ? "<unmanaged queries>" : this.poolPath;
    }

    public String getPoolPath() {
        return this.poolPath;
    }

    public boolean isUnmanagedPool() {
        return this.isUnmanagedPool;
    }

    public void setPoolPath(String poolPath) {
        this.poolPath = poolPath;
    }

    @Explain(displayName="drop or create", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean shouldDrop() {
        return this.drop;
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }
}

